/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minepiece.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.mcreator.minepiece.MinepieceMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MinepieceModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        MinepieceMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        MinepieceMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MinepieceMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.UseDevilAbilities = message.data.UseDevilAbilities;
                    variables.team_gui_entity = message.data.team_gui_entity;
                    variables.team_captain_name = message.data.team_captain_name;
                    variables.team_captain = message.data.team_captain;
                    variables.pvp_oldDevilFruit = message.data.pvp_oldDevilFruit;
                    variables.pvp_oldBounty = message.data.pvp_oldBounty;
                    variables.PlayerTechniqueUsedNumber = message.data.PlayerTechniqueUsedNumber;
                    variables.PlayerTeamBehaviorMode = message.data.PlayerTeamBehaviorMode;
                    variables.PlayerSkill1 = message.data.PlayerSkill1;
                    variables.PlayerSelectNumber = message.data.PlayerSelectNumber;
                    variables.PlayerSelectName = message.data.PlayerSelectName;
                    variables.PlayerSelectCostOrgin = message.data.PlayerSelectCostOrgin;
                    variables.PlayerSelectCost = message.data.PlayerSelectCost;
                    variables.PlayerLevel = message.data.PlayerLevel;
                    variables.PlayerFlag_B = message.data.PlayerFlag_B;
                    variables.PlayerFlag_A = message.data.PlayerFlag_A;
                    variables.PlayerEnergyMAX = message.data.PlayerEnergyMAX;
                    variables.PlayerEnergyFormer = message.data.PlayerEnergyFormer;
                    variables.PlayerEnergyChange = message.data.PlayerEnergyChange;
                    variables.PlayerEnergy = message.data.PlayerEnergy;
                    variables.PlayerDevilFruit = message.data.PlayerDevilFruit;
                    variables.PlayerBountyOld = message.data.PlayerBountyOld;
                    variables.PlayerBountyLimit = message.data.PlayerBountyLimit;
                    variables.PlayerBounty = message.data.PlayerBounty;
                    variables.player_size = message.data.player_size;
                    variables.player_form = message.data.player_form;
                    variables.pirates_crew_name = message.data.pirates_crew_name;
                    variables.PhysicalAttack = message.data.PhysicalAttack;
                    variables.perona = message.data.perona;
                    variables.PassiveTechnique = message.data.PassiveTechnique;
                    variables.p_skillName = message.data.p_skillName;
                    variables.p_passive = message.data.p_passive;
                    variables.p_cost = message.data.p_cost;
                    variables.OverlayEnergy = message.data.OverlayEnergy;
                    variables.OverlayCost = message.data.OverlayCost;
                    variables.noChangeTechnique = message.data.noChangeTechnique;
                    variables.friend_num_keep = message.data.friend_num_keep;
                    variables.ExpSupremeKing = message.data.ExpSupremeKing;
                    variables.ExpObservation = message.data.ExpObservation;
                    variables.ExpArmament = message.data.ExpArmament;
                    variables.config_showSeaLocation = message.data.config_showSeaLocation;
                    variables.ComboTechnique = message.data.ComboTechnique;
                    variables.form_zoro = message.data.form_zoro;
                    variables.form_sanji = message.data.form_sanji;
                    variables.form_haoshoku = message.data.form_haoshoku;
                    variables.flag_shift = message.data.flag_shift;
                    variables.flag_w = message.data.flag_w;
                    variables.flag_space = message.data.flag_space;
                    variables.flag_s = message.data.flag_s;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean UseDevilAbilities = false;
        public String team_gui_entity = "\"\"";
        public String team_captain_name = "\"\"";
        public boolean team_captain = false;
        public ItemStack pvp_oldDevilFruit = ItemStack.f_41583_;
        public double pvp_oldBounty = 0.0;
        public double PlayerTechniqueUsedNumber = 0.0;
        public double PlayerTeamBehaviorMode = 0.0;
        public double PlayerSkill1 = 0.0;
        public double PlayerSelectNumber = 0.0;
        public String PlayerSelectName = "\"\"";
        public double PlayerSelectCostOrgin = 0.0;
        public double PlayerSelectCost = 0.0;
        public double PlayerLevel = 1.0;
        public boolean PlayerFlag_B = false;
        public boolean PlayerFlag_A = false;
        public double PlayerEnergyMAX = 200.0;
        public double PlayerEnergyFormer = 200.0;
        public double PlayerEnergyChange = 0.0;
        public double PlayerEnergy = 0.0;
        public ItemStack PlayerDevilFruit = ItemStack.f_41583_;
        public double PlayerBountyOld = -1.0;
        public double PlayerBountyLimit = 10000.0;
        public double PlayerBounty = 0.0;
        public double player_size = 0.0;
        public double player_form = 0.0;
        public String pirates_crew_name = "\"\"";
        public boolean PhysicalAttack = false;
        public boolean perona = false;
        public boolean PassiveTechnique = false;
        public String p_skillName = "\"\"";
        public boolean p_passive = false;
        public double p_cost = 0.0;
        public String OverlayEnergy = "Curse Power";
        public String OverlayCost = "Cost";
        public boolean noChangeTechnique = false;
        public double friend_num_keep = 0.0;
        public double ExpSupremeKing = 0.0;
        public double ExpObservation = 0.0;
        public double ExpArmament = 0.0;
        public boolean config_showSeaLocation = true;
        public boolean ComboTechnique = false;
        public double form_zoro = 0.0;
        public double form_sanji = 0.0;
        public double form_haoshoku = 0.0;
        public double flag_shift = 0.0;
        public double flag_w = 0.0;
        public double flag_space = 0.0;
        public double flag_s = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MinepieceMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("UseDevilAbilities", this.UseDevilAbilities);
            nbt.m_128359_("team_gui_entity", this.team_gui_entity);
            nbt.m_128359_("team_captain_name", this.team_captain_name);
            nbt.m_128379_("team_captain", this.team_captain);
            nbt.m_128365_("pvp_oldDevilFruit", (Tag)this.pvp_oldDevilFruit.m_41739_(new CompoundTag()));
            nbt.m_128347_("pvp_oldBounty", this.pvp_oldBounty);
            nbt.m_128347_("PlayerTechniqueUsedNumber", this.PlayerTechniqueUsedNumber);
            nbt.m_128347_("PlayerTeamBehaviorMode", this.PlayerTeamBehaviorMode);
            nbt.m_128347_("PlayerSkill1", this.PlayerSkill1);
            nbt.m_128347_("PlayerSelectNumber", this.PlayerSelectNumber);
            nbt.m_128359_("PlayerSelectName", this.PlayerSelectName);
            nbt.m_128347_("PlayerSelectCostOrgin", this.PlayerSelectCostOrgin);
            nbt.m_128347_("PlayerSelectCost", this.PlayerSelectCost);
            nbt.m_128347_("PlayerLevel", this.PlayerLevel);
            nbt.m_128379_("PlayerFlag_B", this.PlayerFlag_B);
            nbt.m_128379_("PlayerFlag_A", this.PlayerFlag_A);
            nbt.m_128347_("PlayerEnergyMAX", this.PlayerEnergyMAX);
            nbt.m_128347_("PlayerEnergyFormer", this.PlayerEnergyFormer);
            nbt.m_128347_("PlayerEnergyChange", this.PlayerEnergyChange);
            nbt.m_128347_("PlayerEnergy", this.PlayerEnergy);
            nbt.m_128365_("PlayerDevilFruit", (Tag)this.PlayerDevilFruit.m_41739_(new CompoundTag()));
            nbt.m_128347_("PlayerBountyOld", this.PlayerBountyOld);
            nbt.m_128347_("PlayerBountyLimit", this.PlayerBountyLimit);
            nbt.m_128347_("PlayerBounty", this.PlayerBounty);
            nbt.m_128347_("player_size", this.player_size);
            nbt.m_128347_("player_form", this.player_form);
            nbt.m_128359_("pirates_crew_name", this.pirates_crew_name);
            nbt.m_128379_("PhysicalAttack", this.PhysicalAttack);
            nbt.m_128379_("perona", this.perona);
            nbt.m_128379_("PassiveTechnique", this.PassiveTechnique);
            nbt.m_128359_("p_skillName", this.p_skillName);
            nbt.m_128379_("p_passive", this.p_passive);
            nbt.m_128347_("p_cost", this.p_cost);
            nbt.m_128359_("OverlayEnergy", this.OverlayEnergy);
            nbt.m_128359_("OverlayCost", this.OverlayCost);
            nbt.m_128379_("noChangeTechnique", this.noChangeTechnique);
            nbt.m_128347_("friend_num_keep", this.friend_num_keep);
            nbt.m_128347_("ExpSupremeKing", this.ExpSupremeKing);
            nbt.m_128347_("ExpObservation", this.ExpObservation);
            nbt.m_128347_("ExpArmament", this.ExpArmament);
            nbt.m_128379_("config_showSeaLocation", this.config_showSeaLocation);
            nbt.m_128379_("ComboTechnique", this.ComboTechnique);
            nbt.m_128347_("form_zoro", this.form_zoro);
            nbt.m_128347_("form_sanji", this.form_sanji);
            nbt.m_128347_("form_haoshoku", this.form_haoshoku);
            nbt.m_128347_("flag_shift", this.flag_shift);
            nbt.m_128347_("flag_w", this.flag_w);
            nbt.m_128347_("flag_space", this.flag_space);
            nbt.m_128347_("flag_s", this.flag_s);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt;
            if (tag == null) {
                tag = this.writeNBT();
            }
            if ((nbt = (CompoundTag)tag) == null) {
                nbt = (CompoundTag)this.writeNBT();
            }
            this.UseDevilAbilities = nbt.m_128471_("UseDevilAbilities");
            this.team_gui_entity = nbt.m_128461_("team_gui_entity");
            this.team_captain_name = nbt.m_128461_("team_captain_name");
            this.team_captain = nbt.m_128471_("team_captain");
            this.pvp_oldDevilFruit = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("pvp_oldDevilFruit"));
            this.pvp_oldBounty = nbt.m_128459_("pvp_oldBounty");
            this.PlayerTechniqueUsedNumber = nbt.m_128459_("PlayerTechniqueUsedNumber");
            this.PlayerTeamBehaviorMode = nbt.m_128459_("PlayerTeamBehaviorMode");
            this.PlayerSkill1 = nbt.m_128459_("PlayerSkill1");
            this.PlayerSelectNumber = nbt.m_128459_("PlayerSelectNumber");
            this.PlayerSelectName = nbt.m_128461_("PlayerSelectName");
            this.PlayerSelectCostOrgin = nbt.m_128459_("PlayerSelectCostOrgin");
            this.PlayerSelectCost = nbt.m_128459_("PlayerSelectCost");
            this.PlayerLevel = nbt.m_128459_("PlayerLevel");
            this.PlayerFlag_B = nbt.m_128471_("PlayerFlag_B");
            this.PlayerFlag_A = nbt.m_128471_("PlayerFlag_A");
            this.PlayerEnergyMAX = nbt.m_128459_("PlayerEnergyMAX");
            this.PlayerEnergyFormer = nbt.m_128459_("PlayerEnergyFormer");
            this.PlayerEnergyChange = nbt.m_128459_("PlayerEnergyChange");
            this.PlayerEnergy = nbt.m_128459_("PlayerEnergy");
            this.PlayerDevilFruit = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("PlayerDevilFruit"));
            this.PlayerBountyOld = nbt.m_128459_("PlayerBountyOld");
            this.PlayerBountyLimit = nbt.m_128459_("PlayerBountyLimit");
            this.PlayerBounty = nbt.m_128459_("PlayerBounty");
            this.player_size = nbt.m_128459_("player_size");
            this.player_form = nbt.m_128459_("player_form");
            this.pirates_crew_name = nbt.m_128461_("pirates_crew_name");
            this.PhysicalAttack = nbt.m_128471_("PhysicalAttack");
            this.perona = nbt.m_128471_("perona");
            this.PassiveTechnique = nbt.m_128471_("PassiveTechnique");
            this.p_skillName = nbt.m_128461_("p_skillName");
            this.p_passive = nbt.m_128471_("p_passive");
            this.p_cost = nbt.m_128459_("p_cost");
            this.OverlayEnergy = nbt.m_128461_("OverlayEnergy");
            this.OverlayCost = nbt.m_128461_("OverlayCost");
            this.noChangeTechnique = nbt.m_128471_("noChangeTechnique");
            this.friend_num_keep = nbt.m_128459_("friend_num_keep");
            this.ExpSupremeKing = nbt.m_128459_("ExpSupremeKing");
            this.ExpObservation = nbt.m_128459_("ExpObservation");
            this.ExpArmament = nbt.m_128459_("ExpArmament");
            this.config_showSeaLocation = nbt.m_128471_("config_showSeaLocation");
            this.ComboTechnique = nbt.m_128471_("ComboTechnique");
            this.form_zoro = nbt.m_128459_("form_zoro");
            this.form_sanji = nbt.m_128459_("form_sanji");
            this.form_haoshoku = nbt.m_128459_("form_haoshoku");
            this.flag_shift = nbt.m_128459_("flag_shift");
            this.flag_w = nbt.m_128459_("flag_w");
            this.flag_space = nbt.m_128459_("flag_space");
            this.flag_s = nbt.m_128459_("flag_s");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("minepiece", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "minepiece_mapvars";
        public double pvp_z_center = 0.0;
        public double pvp_x_center = 0.0;
        public double pvp_world_distance = 0.0;
        public double pvp_totalDamage = 0.0;
        public boolean pvp_oldPvP = false;
        public boolean pvp_oldNaturalRegeneration = false;
        public boolean pvp_oldMobSpawning = false;
        public boolean pvp_oldDoImmediateRespawn = false;
        public boolean pvp_mode = false;
        public boolean pvp_finish = false;
        public String pvp_3rd_damage_name = "\"\"";
        public double pvp_3rd_damage = 0.0;
        public String pvp_3rd = "\"\"";
        public String pvp_2nd_damage_name = "\"\"";
        public double pvp_2nd_damage = 0.0;
        public String pvp_2nd = "\"\"";
        public String pvp_1st_damage_name = "\"\"";
        public double pvp_1st_damage = 0.0;
        public boolean config_doVanillaMobSpawning = false;
        public boolean pvp_oldDoMobLoot = false;
        public boolean pvp_oldDoEntityDrops = false;
        public double raid_stage = 0.0;
        public double raid_timer = 0.0;
        public double raid_sea_location = 0.0;
        public double raid_remainder_number = 0.0;
        public double raid_remainder_map = 0.0;
        public double raid_friend = 0.0;
        public boolean raid_finish = false;
        public String raid_stage_name = "\"\"";
        public double raid_start_timer = 0.0;
        public double pvp_y_center = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            if (nbt == null) {
                nbt = this.m_7176_(new CompoundTag());
            }
            this.pvp_z_center = nbt.m_128459_("pvp_z_center");
            this.pvp_x_center = nbt.m_128459_("pvp_x_center");
            this.pvp_world_distance = nbt.m_128459_("pvp_world_distance");
            this.pvp_totalDamage = nbt.m_128459_("pvp_totalDamage");
            this.pvp_oldPvP = nbt.m_128471_("pvp_oldPvP");
            this.pvp_oldNaturalRegeneration = nbt.m_128471_("pvp_oldNaturalRegeneration");
            this.pvp_oldMobSpawning = nbt.m_128471_("pvp_oldMobSpawning");
            this.pvp_oldDoImmediateRespawn = nbt.m_128471_("pvp_oldDoImmediateRespawn");
            this.pvp_mode = nbt.m_128471_("pvp_mode");
            this.pvp_finish = nbt.m_128471_("pvp_finish");
            this.pvp_3rd_damage_name = nbt.m_128461_("pvp_3rd_damage_name");
            this.pvp_3rd_damage = nbt.m_128459_("pvp_3rd_damage");
            this.pvp_3rd = nbt.m_128461_("pvp_3rd");
            this.pvp_2nd_damage_name = nbt.m_128461_("pvp_2nd_damage_name");
            this.pvp_2nd_damage = nbt.m_128459_("pvp_2nd_damage");
            this.pvp_2nd = nbt.m_128461_("pvp_2nd");
            this.pvp_1st_damage_name = nbt.m_128461_("pvp_1st_damage_name");
            this.pvp_1st_damage = nbt.m_128459_("pvp_1st_damage");
            this.config_doVanillaMobSpawning = nbt.m_128471_("config_doVanillaMobSpawning");
            this.pvp_oldDoMobLoot = nbt.m_128471_("pvp_oldDoMobLoot");
            this.pvp_oldDoEntityDrops = nbt.m_128471_("pvp_oldDoEntityDrops");
            this.raid_stage = nbt.m_128459_("raid_stage");
            this.raid_timer = nbt.m_128459_("raid_timer");
            this.raid_sea_location = nbt.m_128459_("raid_sea_location");
            this.raid_remainder_number = nbt.m_128459_("raid_remainder_number");
            this.raid_remainder_map = nbt.m_128459_("raid_remainder_map");
            this.raid_friend = nbt.m_128459_("raid_friend");
            this.raid_finish = nbt.m_128471_("raid_finish");
            this.raid_stage_name = nbt.m_128461_("raid_stage_name");
            this.raid_start_timer = nbt.m_128459_("raid_start_timer");
            this.pvp_y_center = nbt.m_128459_("pvp_y_center");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("pvp_z_center", this.pvp_z_center);
            nbt.m_128347_("pvp_x_center", this.pvp_x_center);
            nbt.m_128347_("pvp_world_distance", this.pvp_world_distance);
            nbt.m_128347_("pvp_totalDamage", this.pvp_totalDamage);
            nbt.m_128379_("pvp_oldPvP", this.pvp_oldPvP);
            nbt.m_128379_("pvp_oldNaturalRegeneration", this.pvp_oldNaturalRegeneration);
            nbt.m_128379_("pvp_oldMobSpawning", this.pvp_oldMobSpawning);
            nbt.m_128379_("pvp_oldDoImmediateRespawn", this.pvp_oldDoImmediateRespawn);
            nbt.m_128379_("pvp_mode", this.pvp_mode);
            nbt.m_128379_("pvp_finish", this.pvp_finish);
            nbt.m_128359_("pvp_3rd_damage_name", this.pvp_3rd_damage_name);
            nbt.m_128347_("pvp_3rd_damage", this.pvp_3rd_damage);
            nbt.m_128359_("pvp_3rd", this.pvp_3rd);
            nbt.m_128359_("pvp_2nd_damage_name", this.pvp_2nd_damage_name);
            nbt.m_128347_("pvp_2nd_damage", this.pvp_2nd_damage);
            nbt.m_128359_("pvp_2nd", this.pvp_2nd);
            nbt.m_128359_("pvp_1st_damage_name", this.pvp_1st_damage_name);
            nbt.m_128347_("pvp_1st_damage", this.pvp_1st_damage);
            nbt.m_128379_("config_doVanillaMobSpawning", this.config_doVanillaMobSpawning);
            nbt.m_128379_("pvp_oldDoMobLoot", this.pvp_oldDoMobLoot);
            nbt.m_128379_("pvp_oldDoEntityDrops", this.pvp_oldDoEntityDrops);
            nbt.m_128347_("raid_stage", this.raid_stage);
            nbt.m_128347_("raid_timer", this.raid_timer);
            nbt.m_128347_("raid_sea_location", this.raid_sea_location);
            nbt.m_128347_("raid_remainder_number", this.raid_remainder_number);
            nbt.m_128347_("raid_remainder_map", this.raid_remainder_map);
            nbt.m_128347_("raid_friend", this.raid_friend);
            nbt.m_128379_("raid_finish", this.raid_finish);
            nbt.m_128359_("raid_stage_name", this.raid_stage_name);
            nbt.m_128347_("raid_start_timer", this.raid_start_timer);
            nbt.m_128347_("pvp_y_center", this.pvp_y_center);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                MinepieceMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "minepiece_worldvars";
        public double sky_tot_musica = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.sky_tot_musica = nbt.m_128459_("sky_tot_musica");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("sky_tot_musica", this.sky_tot_musica);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                MinepieceMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.team_captain_name = original.team_captain_name;
            clone.team_captain = original.team_captain;
            clone.pvp_oldDevilFruit = original.pvp_oldDevilFruit;
            clone.pvp_oldBounty = original.pvp_oldBounty;
            clone.PlayerTechniqueUsedNumber = original.PlayerTechniqueUsedNumber;
            clone.PlayerTeamBehaviorMode = original.PlayerTeamBehaviorMode;
            clone.PlayerSkill1 = original.PlayerSkill1;
            clone.PlayerSelectNumber = original.PlayerSelectNumber;
            clone.PlayerSelectName = original.PlayerSelectName;
            clone.PlayerSelectCostOrgin = original.PlayerSelectCostOrgin;
            clone.PlayerSelectCost = original.PlayerSelectCost;
            clone.PlayerLevel = original.PlayerLevel;
            clone.PlayerFlag_A = original.PlayerFlag_A;
            clone.PlayerEnergyMAX = original.PlayerEnergyMAX;
            clone.PlayerEnergyFormer = original.PlayerEnergyFormer;
            clone.PlayerEnergy = original.PlayerEnergy;
            clone.PlayerDevilFruit = original.PlayerDevilFruit;
            clone.PlayerBountyOld = original.PlayerBountyOld;
            clone.PlayerBountyLimit = original.PlayerBountyLimit;
            clone.PlayerBounty = original.PlayerBounty;
            clone.player_size = original.player_size;
            clone.player_form = original.player_form;
            clone.pirates_crew_name = original.pirates_crew_name;
            clone.perona = original.perona;
            clone.OverlayEnergy = original.OverlayEnergy;
            clone.OverlayCost = original.OverlayCost;
            clone.noChangeTechnique = original.noChangeTechnique;
            clone.friend_num_keep = original.friend_num_keep;
            clone.ExpSupremeKing = original.ExpSupremeKing;
            clone.ExpObservation = original.ExpObservation;
            clone.ExpArmament = original.ExpArmament;
            clone.config_showSeaLocation = original.config_showSeaLocation;
            if (!event.isWasDeath()) {
                clone.UseDevilAbilities = original.UseDevilAbilities;
                clone.team_gui_entity = original.team_gui_entity;
                clone.PlayerFlag_B = original.PlayerFlag_B;
                clone.PlayerEnergyChange = original.PlayerEnergyChange;
                clone.PhysicalAttack = original.PhysicalAttack;
                clone.PassiveTechnique = original.PassiveTechnique;
                clone.p_skillName = original.p_skillName;
                clone.p_passive = original.p_passive;
                clone.p_cost = original.p_cost;
                clone.ComboTechnique = original.ComboTechnique;
                clone.form_zoro = original.form_zoro;
                clone.form_sanji = original.form_sanji;
                clone.form_haoshoku = original.form_haoshoku;
                clone.flag_shift = original.flag_shift;
                clone.flag_w = original.flag_w;
                clone.flag_space = original.flag_space;
                clone.flag_s = original.flag_s;
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    MinepieceMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    MinepieceMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                MinepieceMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

