/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.creeperfirework.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import plus.dragons.creeperfirework.Configuration;
import plus.dragons.creeperfirework.FireworkEffect;

@Mixin(value={Creeper.class})
public abstract class CreeperEntityMixin
extends Monster {
    @Shadow
    private int explosionRadius;
    @Final
    @Shadow
    private static EntityDataAccessor<Boolean> DATA_IS_POWERED;

    @Shadow
    public abstract boolean isPowered();

    @Shadow
    protected abstract void spawnLingeringCloud();

    protected CreeperEntityMixin(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"explodeCreeper()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;explode(Lnet/minecraft/world/entity/Entity;DDDFLnet/minecraft/world/level/Level$ExplosionInteraction;)V")}, cancellable=true)
    private void injected(CallbackInfo ci) {
        if (Configuration.isCreeperExplodeIntoFirework() && Math.random() < Configuration.becomeFireworkChance()) {
            this.spawnLingeringCloud();
            FireworkEffect.create((Creeper)this);
            this.level().explode((Entity)this, Explosion.getDefaultDamageSource((Level)this.level(), (Entity)this), (ExplosionDamageCalculator)new EntityBasedExplosionDamageCalculator(this, (Entity)this){

                public boolean shouldBlockExplode(Explosion explosion, BlockGetter world, BlockPos pos, BlockState state, float power) {
                    if (Configuration.isFireworkDestroyBlock()) {
                        return super.shouldBlockExplode(explosion, world, pos, state, power);
                    }
                    return false;
                }

                public boolean shouldDamageEntity(Explosion explosion, Entity entity) {
                    if (Configuration.isFireworkHurtCreature()) {
                        return super.shouldDamageEntity(explosion, entity);
                    }
                    return false;
                }
            }, this.getX(), this.getY(), this.getZ(), (float)this.explosionRadius * (this.isPowered() ? 2.0f : 1.0f), false, Level.ExplosionInteraction.MOB);
            this.triggerOnDeathMobEffects((ServerLevel)this.level(), Entity.RemovalReason.KILLED);
            this.discard();
            ci.cancel();
        }
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        if (!this.level().isClientSide() && Configuration.isCreeperExplodeIntoFireworkWhenDie() && Math.random() < Configuration.becomeFireworkChanceWhenDie()) {
            FireworkEffect.create((Creeper)this);
            this.level().explode((Entity)this, Explosion.getDefaultDamageSource((Level)this.level(), (Entity)this), (ExplosionDamageCalculator)new EntityBasedExplosionDamageCalculator(this, (Entity)this){

                public boolean shouldBlockExplode(Explosion explosion, BlockGetter world, BlockPos pos, BlockState state, float power) {
                    if (Configuration.isDeathFireworkDestroyBlock()) {
                        return super.shouldBlockExplode(explosion, world, pos, state, power);
                    }
                    return false;
                }

                public boolean shouldDamageEntity(Explosion explosion, Entity entity) {
                    if (Configuration.isDeathFireworkHurtCreature()) {
                        return super.shouldDamageEntity(explosion, entity);
                    }
                    return false;
                }
            }, this.getX(), this.getY(), this.getZ(), (float)this.explosionRadius * (this.isPowered() ? 2.0f : 1.0f), false, Level.ExplosionInteraction.MOB);
        }
    }
}

