/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pokefenn.totemic.TotemicConfig;
import pokefenn.totemic.advancements.ModCriteriaTriggers;
import pokefenn.totemic.apiimpl.registry.RegistryApiImpl;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.compat.kubejs.TotemicKubeEventHandler;
import pokefenn.totemic.data.TotemicBlockStateProvider;
import pokefenn.totemic.data.TotemicBlockTagsProvider;
import pokefenn.totemic.data.TotemicDamageTypeTagsProvider;
import pokefenn.totemic.data.TotemicDataMapProvider;
import pokefenn.totemic.data.TotemicDatapackEntryProvider;
import pokefenn.totemic.data.TotemicEntityTypeTagsProvider;
import pokefenn.totemic.data.TotemicItemTagsProvider;
import pokefenn.totemic.data.TotemicLootTableProvider;
import pokefenn.totemic.data.TotemicRecipeProvider;
import pokefenn.totemic.handler.PlayerInteract;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModDataComponents;
import pokefenn.totemic.init.ModDataMapTypes;
import pokefenn.totemic.init.ModEntityTypes;
import pokefenn.totemic.init.ModItems;
import pokefenn.totemic.init.ModMobEffects;
import pokefenn.totemic.init.ModSounds;
import pokefenn.totemic.network.NetworkHandler;

@Mod(value="totemic")
public final class Totemic {
    public static final Logger logger = LogManager.getLogger(Totemic.class);

    public Totemic(IEventBus modBus, ModContainer container) {
        modBus.addListener(this::commonSetup);
        modBus.addListener(this::gatherData);
        ModBlocks.REGISTER.register(modBus);
        ModItems.REGISTER.register(modBus);
        ModItems.ARMOR_MATERIALS.register(modBus);
        ModDataComponents.REGISTER.register(modBus);
        ModMobEffects.REGISTER.register(modBus);
        ModBlockEntities.REGISTER.register(modBus);
        ModEntityTypes.REGISTER.register(modBus);
        ModSounds.REGISTER.register(modBus);
        ModContent.INSTRUMENTS.register(modBus);
        ModContent.WOOD_TYPES.register(modBus);
        ModContent.CARVINGS.register(modBus);
        ModContent.CEREMONIES.register(modBus);
        modBus.addListener(ModItems::init);
        modBus.addListener(ModCriteriaTriggers::init);
        modBus.addListener(ModDataMapTypes::init);
        modBus.addListener(ModEntityTypes::registerAttributes);
        modBus.addListener(RegistryApiImpl::registerRegistries);
        modBus.addListener(ModContent::registerCustomWoodTypes);
        modBus.addListener(ModBlocks::addCedarSignToSignBlockEntityType);
        modBus.addListener(TotemBaseBlockEntity::registerCapability);
        modBus.addListener(NetworkHandler::init);
        TotemicConfig.register(container);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModBlocks.addPlantsToFlowerPot();
            ModBlocks.setFireInfo();
        });
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.register(PlayerInteract.class);
        if (ModList.get().isLoaded("kubejs")) {
            eventBus.register(TotemicKubeEventHandler.class);
            TotemicKubeEventHandler.postModificationEvents();
        }
        RegistryApiImpl.createSelectorsToCeremonyMap();
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper efh = event.getExistingFileHelper();
        PackOutput out = gen.getPackOutput();
        TotemicDatapackEntryProvider datapackProvider = (TotemicDatapackEntryProvider)gen.addProvider(event.includeServer(), (DataProvider)new TotemicDatapackEntryProvider(out, event.getLookupProvider()));
        CompletableFuture lookup = datapackProvider.getRegistryProvider();
        TotemicBlockTagsProvider blockTP = (TotemicBlockTagsProvider)gen.addProvider(event.includeServer(), (DataProvider)new TotemicBlockTagsProvider(out, lookup, efh));
        gen.addProvider(event.includeServer(), (DataProvider)new TotemicItemTagsProvider(out, lookup, blockTP.contentsGetter(), efh));
        gen.addProvider(event.includeServer(), (DataProvider)new TotemicEntityTypeTagsProvider(out, lookup, efh));
        gen.addProvider(event.includeServer(), (DataProvider)new TotemicLootTableProvider(out, lookup));
        gen.addProvider(event.includeServer(), (DataProvider)new TotemicRecipeProvider(out, lookup));
        gen.addProvider(event.includeServer(), (DataProvider)new TotemicDamageTypeTagsProvider(out, lookup, efh));
        gen.addProvider(event.includeServer(), (DataProvider)new TotemicDataMapProvider(out, lookup));
        gen.addProvider(event.includeClient(), (DataProvider)new TotemicBlockStateProvider(out, efh));
    }

    public static ResourceLocation resloc(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"totemic", (String)path);
    }
}

