/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.music;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.apache.logging.log4j.LogManager;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.music.MusicInstrument;

public class DefaultMusicAcceptor
implements MusicAcceptor,
INBTSerializable<CompoundTag> {
    private Vec3 position;
    private final Object2IntMap<MusicInstrument> music = new Object2IntOpenHashMap(TotemicAPI.get().registry().instruments().size());
    private int totalMusic = 0;

    public DefaultMusicAcceptor(Vec3 position) {
        this.position = position;
    }

    public DefaultMusicAcceptor() {
        this(Vec3.ZERO);
    }

    @Override
    public MusicAcceptor.MusicResult acceptMusic(MusicInstrument instr, int amount, Vec3 from, @Nullable Entity entity) {
        int oldVal = this.music.getInt((Object)instr);
        int newVal = Math.min(oldVal + amount, instr.getMusicMaximum());
        if (newVal != oldVal) {
            this.music.put((Object)instr, newVal);
            this.totalMusic += newVal - oldVal;
            return newVal == oldVal + amount ? MusicAcceptor.MusicResult.SUCCESS : MusicAcceptor.MusicResult.SUCCESS_SATURATED;
        }
        return MusicAcceptor.MusicResult.SATURATED;
    }

    public int getMusicAmount(MusicInstrument instr) {
        return this.music.getInt((Object)instr);
    }

    public void setMusicAmount(MusicInstrument instr, int amount) {
        Objects.requireNonNull(instr);
        int oldVal = this.music.getInt((Object)instr);
        if (amount != oldVal) {
            this.music.put((Object)instr, amount);
            this.totalMusic += amount - oldVal;
        }
    }

    public int getTotalMusic() {
        return this.totalMusic;
    }

    @Override
    public Vec3 getPosition() {
        return this.position;
    }

    public void setPosition(Vec3 position) {
        this.position = position;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        for (Object2IntMap.Entry entry : this.music.object2IntEntrySet()) {
            nbt.putInt(((MusicInstrument)entry.getKey()).toString(), entry.getIntValue());
        }
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.music.clear();
        this.totalMusic = 0;
        Registry<MusicInstrument> instrRegistry = TotemicAPI.get().registry().instruments();
        for (String key : tag.getAllKeys()) {
            MusicInstrument instr = (MusicInstrument)instrRegistry.get(ResourceLocation.tryParse((String)key));
            if (instr != null) {
                int amount = tag.getInt(key);
                this.music.put((Object)instr, amount);
                this.totalMusic += amount;
                continue;
            }
            LogManager.getLogger().warn("Unknown music instrument: '{}'", (Object)key);
        }
    }
}

