/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.totem;

import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import pokefenn.totemic.api.totem.MedicineBagEffect;
import pokefenn.totemic.api.totem.PlayerTotemEffect;
import pokefenn.totemic.api.totem.TotemEffectContext;

public class PotionTotemEffect
extends PlayerTotemEffect
implements MedicineBagEffect {
    protected final Holder<MobEffect> mobEffect;
    protected final boolean scaleAmplifier;

    public PotionTotemEffect(Holder<MobEffect> mobEffect) {
        this(mobEffect, true);
    }

    public PotionTotemEffect(Holder<MobEffect> mobEffect, boolean scaleAmplifier) {
        this(mobEffect, scaleAmplifier, 80);
    }

    public PotionTotemEffect(Holder<MobEffect> mobEffect, boolean scaleAmplifier, int interval) {
        super(interval);
        this.mobEffect = Objects.requireNonNull(mobEffect);
        this.scaleAmplifier = scaleAmplifier;
    }

    protected int getAmplifier(LivingEntity entity, int repetition, TotemEffectContext context) {
        int musicThreshold = 5760;
        if (this.scaleAmplifier) {
            return (repetition - 1) / 2 + (context.getTotemEffectMusic() >= 5760 ? 1 : 0);
        }
        return 0;
    }

    protected int getAmplifierForMedicineBag(Player player, ItemStack medicineBag, int charge) {
        return 0;
    }

    protected int getLingeringTime() {
        return 20;
    }

    protected MobEffectInstance getEffectInstance(LivingEntity entity, int repetition, TotemEffectContext context) {
        return new MobEffectInstance(this.mobEffect, this.getInterval() + this.getLingeringTime(), this.getAmplifier(entity, repetition, context), true, false);
    }

    protected MobEffectInstance getEffectInstanceForMedicineBag(Player player, ItemStack medicineBag, int charge) {
        return new MobEffectInstance(this.mobEffect, this.getInterval() + this.getLingeringTime(), this.getAmplifierForMedicineBag(player, medicineBag, charge), true, false);
    }

    @Override
    public void applyTo(Player player, int repetition, TotemEffectContext context) {
        player.addEffect(this.getEffectInstance((LivingEntity)player, repetition, context));
    }

    @Override
    public void medicineBagEffect(Player player, ItemStack medicineBag, int charge) {
        if (!player.level().isClientSide) {
            player.addEffect(this.getEffectInstanceForMedicineBag(player, medicineBag, charge));
        }
    }
}

