/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.apiimpl.registry;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;
import net.neoforged.neoforge.registries.datamaps.DataMapType;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.api.registry.RegistryAPI;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.init.ModDataMapTypes;

public enum RegistryApiImpl implements RegistryAPI
{
    INSTANCE;

    private static final Registry<MusicInstrument> MUSIC_INSTRUMENT;
    private static final DefaultedRegistry<TotemWoodType> WOOD_TYPE;
    private static final DefaultedRegistry<TotemCarving> TOTEM_CARVING;
    private static final Registry<Ceremony> CEREMONY;
    private static Map<List<MusicInstrument>, Ceremony> selectorsToCeremonyMap;

    public static void registerRegistries(NewRegistryEvent event) {
        event.register(MUSIC_INSTRUMENT);
        event.register(WOOD_TYPE);
        event.register(TOTEM_CARVING);
        event.register(CEREMONY);
    }

    public static void createSelectorsToCeremonyMap() {
        selectorsToCeremonyMap = CEREMONY.stream().collect(Collectors.toUnmodifiableMap(Ceremony::getSelectors, Function.identity()));
    }

    public static Optional<Ceremony> getCeremony(List<MusicInstrument> selectors) {
        return Optional.ofNullable(selectorsToCeremonyMap.get(selectors));
    }

    @Override
    public Registry<MusicInstrument> instruments() {
        return MUSIC_INSTRUMENT;
    }

    @Override
    public DefaultedRegistry<TotemWoodType> woodTypes() {
        return WOOD_TYPE;
    }

    @Override
    public DefaultedRegistry<TotemCarving> totemCarvings() {
        return TOTEM_CARVING;
    }

    @Override
    public Registry<Ceremony> ceremonies() {
        return CEREMONY;
    }

    @Override
    public DataMapType<EntityType<?>, EntityType<? extends Mob>> cleansingCeremonyConversionsDataMap() {
        return ModDataMapTypes.CLEANSING_CEREMONY_CONVERSIONS;
    }

    static {
        MUSIC_INSTRUMENT = new RegistryBuilder(MUSIC_INSTRUMENT_REGISTRY).sync(true).create();
        WOOD_TYPE = (DefaultedRegistry)new RegistryBuilder(WOOD_TYPE_REGISTRY).defaultKey(Totemic.resloc("oak")).sync(false).create();
        TOTEM_CARVING = (DefaultedRegistry)new RegistryBuilder(TOTEM_CARVING_REGISTRY).defaultKey(Totemic.resloc("none")).sync(true).create();
        CEREMONY = new RegistryBuilder(CEREMONY_REGISTRY).sync(false).create();
    }
}

