/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.apiimpl.totem;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.api.totem.TotemEffectAPI;
import pokefenn.totemic.api.totem.TotemEffectContext;

public enum TotemEffectApiImpl implements TotemEffectAPI
{
    INSTANCE;

    private static Map<TotemEffect, TotemCarving> effectToCarvingMap;

    @Override
    public int getDefaultRange(int repetition, TotemEffectContext context) {
        int baseRange = 5;
        int musicStep = 1920;
        return 5 + context.getTotemEffectMusic() / 1920 + (context.getPoleSize() == 5 ? 1 : 0);
    }

    @Override
    public TotemCarving getCarvingForEffect(TotemEffect effect) {
        ImmutableMap localEffectToCarvingMap = effectToCarvingMap;
        if (localEffectToCarvingMap == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (TotemCarving carving : TotemicAPI.get().registry().totemCarvings()) {
                for (TotemEffect eff : carving.getEffects()) {
                    builder.put((Object)eff, (Object)carving);
                }
            }
            effectToCarvingMap = localEffectToCarvingMap = builder.build();
        }
        return localEffectToCarvingMap.get(effect);
    }

    static {
        effectToCarvingMap = null;
    }
}

