/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import pokefenn.totemic.block.TipiBlock;
import pokefenn.totemic.init.ModBlocks;

public class DummyTipiBlock
extends Block {
    public DummyTipiBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        this.findMainTipiBlock(level, pos).ifPresent(pair -> {
            BlockPos tipiPos = (BlockPos)pair.getFirst();
            BlockState tipiState = (BlockState)pair.getSecond();
            tipiState.getBlock().playerWillDestroy(level, tipiPos, tipiState, player);
            if (!player.isCreative()) {
                DummyTipiBlock.dropResources((BlockState)tipiState, (Level)level, (BlockPos)tipiPos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
            level.setBlock(tipiPos, Blocks.AIR.defaultBlockState(), 11);
        });
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void wasExploded(Level level, BlockPos pos, Explosion explosion) {
        this.findMainTipiBlock(level, pos).ifPresent(pair -> {
            BlockPos tipiPos = (BlockPos)pair.getFirst();
            BlockState tipiState = (BlockState)pair.getSecond();
            tipiState.onBlockExploded(level, tipiPos, explosion);
        });
        super.wasExploded(level, pos, explosion);
    }

    private Optional<Pair<BlockPos, BlockState>> findMainTipiBlock(Level level, BlockPos pos) {
        int y;
        for (y = 0; y < 2; ++y) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos p = pos.relative(dir).below(y);
                BlockState state = level.getBlockState(p);
                if (!state.is((Block)ModBlocks.tipi.get())) continue;
                return Optional.of(Pair.of((Object)p, (Object)state));
            }
        }
        for (y = 3; y < 6; ++y) {
            BlockPos p = pos.below(y);
            BlockState state = level.getBlockState(p);
            if (!state.is((Block)ModBlocks.tipi.get())) continue;
            return Optional.of(Pair.of((Object)p, (Object)state));
        }
        return Optional.empty();
    }

    public ItemStack getCloneItemStack(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)ModBlocks.tipi.get());
    }

    protected boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    protected VoxelShape getVisualShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.empty();
    }

    protected VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return Shapes.empty();
    }

    protected VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.empty();
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public String getDescriptionId() {
        return ((TipiBlock)((Object)ModBlocks.tipi.get())).getDescriptionId();
    }
}

