/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.TotemicEventHooks;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemState;
import pokefenn.totemic.client.CeremonyHUD;
import pokefenn.totemic.util.MiscUtil;

public final class StateCeremonyEffect
extends TotemState
implements CeremonyEffectContext {
    static final byte ID = 3;
    private Ceremony ceremony;
    private CeremonyInstance instance;
    @Nullable
    private Entity initiator;
    private int time = 0;

    StateCeremonyEffect(TotemBaseBlockEntity tile, Ceremony ceremony, CeremonyInstance instance, @Nullable Entity initiator) {
        super(tile);
        this.ceremony = ceremony;
        this.instance = instance;
        this.initiator = initiator;
    }

    StateCeremonyEffect(TotemBaseBlockEntity tile) {
        super(tile);
    }

    @Override
    public boolean canAcceptMusic(MusicInstrument instr) {
        return false;
    }

    @Override
    public MusicAcceptor.MusicResult acceptMusic(MusicInstrument instr, int amount, Vec3 from, @Nullable Entity entity) {
        return MusicAcceptor.MusicResult.FAILURE;
    }

    @Override
    public void tick() {
        Level world = this.tile.getLevel();
        BlockPos pos = this.tile.getBlockPos();
        if (TotemicEventHooks.get().fireCeremonyEffectTick((LevelAccessor)world, pos, this.ceremony, this.instance, this)) {
            this.instance.effect(world, pos, this);
        }
        ++this.time;
        if (!world.isClientSide) {
            if (this.time >= this.instance.getEffectTime()) {
                this.tile.setTotemState(new StateTotemEffect(this.tile));
            }
        } else if (this.instance.getEffectTime() == 0) {
            this.tile.setTotemState(new StateTotemEffect(this.tile));
        } else {
            CeremonyHUD.INSTANCE.setActiveTotem(this.tile);
        }
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public int getAnalogOutputSignal() {
        return 15;
    }

    @Override
    public Optional<Player> getInitiatingPlayer() {
        return MiscUtil.filterAndCast(this.getInitiator(), Player.class);
    }

    @Override
    public Optional<Entity> getInitiator() {
        return Optional.ofNullable(this.initiator);
    }

    @Override
    public void endCeremony() {
        this.tile.setTotemState(new StateTotemEffect(this.tile));
    }

    public Ceremony getCeremony() {
        return this.ceremony;
    }

    public CeremonyInstance getCeremonyInstance() {
        return this.instance;
    }

    @Override
    byte getID() {
        return 3;
    }

    @Override
    void save(CompoundTag tag, HolderLookup.Provider regsitries) {
        tag.putString("Ceremony", this.ceremony.getRegistryName().toString());
        Tag instanceData = this.instance.serializeNBT(regsitries);
        if (instanceData != EndTag.INSTANCE) {
            tag.put("InstanceData", instanceData);
        }
        tag.putInt("Time", this.time);
    }

    @Override
    void load(CompoundTag tag, HolderLookup.Provider regsitries) {
        String ceremonyName = tag.getString("Ceremony");
        this.ceremony = (Ceremony)TotemicAPI.get().registry().ceremonies().get(ResourceLocation.tryParse((String)ceremonyName));
        if (this.ceremony == null) {
            Totemic.logger.error("Unknown Ceremony: '{}'", (Object)ceremonyName);
            this.tile.setTotemState(new StateTotemEffect(this.tile));
            return;
        }
        this.instance = this.ceremony.createInstance();
        if (tag.contains("InstanceData")) {
            this.instance.deserializeNBT(regsitries, tag.get("InstanceData"));
        }
        this.time = tag.getInt("Time");
    }
}

