/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.TotemicEventHooks;
import pokefenn.totemic.advancements.ModCriteriaTriggers;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.ceremony.StartupContext;
import pokefenn.totemic.api.music.DefaultMusicAcceptor;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.block.totem.entity.StateCeremonyEffect;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemState;
import pokefenn.totemic.client.CeremonyHUD;
import pokefenn.totemic.network.ClientboundPacketStartupMusic;
import pokefenn.totemic.util.MiscUtil;

public final class StateStartup
extends TotemState
implements StartupContext {
    private static final int ADVANCEMENT_TRIGGER_RANGE = 8;
    static final byte ID = 2;
    private Ceremony ceremony;
    private CeremonyInstance instance;
    @Nullable
    private Entity initiator;
    private final DefaultMusicAcceptor musicHandler = new DefaultMusicAcceptor();
    private int time = 0;

    StateStartup(TotemBaseBlockEntity tile, Ceremony ceremony, CeremonyInstance instance, @Nullable Entity initiator) {
        super(tile);
        this.ceremony = ceremony;
        this.instance = instance;
        this.initiator = initiator;
    }

    StateStartup(TotemBaseBlockEntity tile) {
        super(tile);
    }

    @Override
    public boolean canAcceptMusic(MusicInstrument instr) {
        return this.musicHandler.canAcceptMusic(instr);
    }

    @Override
    public MusicAcceptor.MusicResult acceptMusic(MusicInstrument instr, int amount, Vec3 from, @Nullable Entity entity) {
        MusicAcceptor.MusicResult result = this.musicHandler.acceptMusic(instr, amount, from, entity);
        if (result.isSuccess()) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.tile.getLevel()), (ChunkPos)new ChunkPos(this.tile.getBlockPos()), (CustomPacketPayload)new ClientboundPacketStartupMusic(this.tile.getBlockPos(), instr, this.musicHandler.getMusicAmount(instr)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.tile.setChanged();
        }
        return result;
    }

    @Override
    public int getPriority() {
        return 16;
    }

    @Override
    public void tick() {
        Level world = this.tile.getLevel();
        BlockPos pos = this.tile.getBlockPos();
        if (!world.isClientSide) {
            if (this.musicHandler.getTotalMusic() >= this.ceremony.getMusicNeeded()) {
                if (this.instance.canStartEffect(world, pos, this) && TotemicEventHooks.get().fireCeremonyStartupSuccess((LevelAccessor)world, pos, this.ceremony, this.instance, this)) {
                    this.startCeremony();
                } else {
                    this.failCeremony();
                }
            } else if (this.time >= this.ceremony.getAdjustedMaxStartupTime(world.getDifficulty())) {
                TotemicEventHooks.get().fireCeremonyStartupFail((LevelAccessor)world, pos, this.ceremony, this.instance, this);
                this.instance.onStartupFail(world, pos, this);
                this.failCeremony();
            } else {
                this.startupTick(world, pos);
            }
        } else {
            this.startupTick(world, pos);
            CeremonyHUD.INSTANCE.setActiveTotem(this.tile);
        }
        ++this.time;
    }

    private void startupTick(Level world, BlockPos pos) {
        if (TotemicEventHooks.get().fireCeremonyStartupTick((LevelAccessor)world, pos, this.ceremony, this.instance, this)) {
            this.instance.onStartup(world, pos, this);
        }
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public int getTotalMusic() {
        return this.musicHandler.getTotalMusic();
    }

    @Override
    public int getMusic(MusicInstrument instrument) {
        return this.musicHandler.getMusicAmount(instrument);
    }

    public void setMusic(MusicInstrument instrument, int amount) {
        this.musicHandler.setMusicAmount(instrument, amount);
    }

    @Override
    public int getAnalogOutputSignal() {
        return this.getTotalMusic() * 15 / this.ceremony.getMusicNeeded();
    }

    @Override
    public Optional<Player> getInitiatingPlayer() {
        return MiscUtil.filterAndCast(this.getInitiator(), Player.class);
    }

    @Override
    public Optional<Entity> getInitiator() {
        return Optional.ofNullable(this.initiator);
    }

    @Override
    public void failCeremony() {
        if (this.tile.getLevel().isClientSide) {
            return;
        }
        MiscUtil.spawnAlwaysVisibleServerParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.tile.getLevel(), this.getPosition(), 16, new Vec3(0.6, 0.5, 0.6), 0.0);
        this.tile.setTotemState(new StateTotemEffect(this.tile));
    }

    @Override
    public void startCeremony() {
        if (this.tile.getLevel().isClientSide) {
            return;
        }
        MiscUtil.spawnAlwaysVisibleServerParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.tile.getLevel(), this.getPosition(), 16, new Vec3(0.6, 0.5, 0.6), 1.0);
        this.tile.setTotemState(new StateCeremonyEffect(this.tile, this.ceremony, this.instance, this.initiator));
        TotemicEntityUtil.getPlayersIn(this.tile.getLevel(), TotemicEntityUtil.getAABBAround(this.tile.getBlockPos(), 8.0)).forEach(player -> ModCriteriaTriggers.PERFORM_CEREMONY.trigger((ServerPlayer)player, this.ceremony));
    }

    public Ceremony getCeremony() {
        return this.ceremony;
    }

    public CeremonyInstance getCeremonyInstance() {
        return this.instance;
    }

    @Override
    byte getID() {
        return 2;
    }

    @Override
    void save(CompoundTag tag, HolderLookup.Provider regsitries) {
        tag.putString("Ceremony", this.ceremony.getRegistryName().toString());
        Tag instanceData = this.instance.serializeNBT(regsitries);
        if (instanceData != EndTag.INSTANCE) {
            tag.put("InstanceData", instanceData);
        }
        tag.put("Music", (Tag)this.musicHandler.serializeNBT(regsitries));
        tag.putInt("Time", this.time);
    }

    @Override
    void load(CompoundTag tag, HolderLookup.Provider regsitries) {
        String ceremonyName = tag.getString("Ceremony");
        this.ceremony = (Ceremony)TotemicAPI.get().registry().ceremonies().get(ResourceLocation.tryParse((String)ceremonyName));
        if (this.ceremony == null) {
            Totemic.logger.error("Unknown Ceremony: '{}'", (Object)ceremonyName);
            this.tile.setTotemState(new StateTotemEffect(this.tile));
            return;
        }
        this.instance = this.ceremony.createInstance();
        if (tag.contains("InstanceData")) {
            this.instance.deserializeNBT(regsitries, tag.get("InstanceData"));
        }
        this.musicHandler.deserializeNBT(regsitries, tag.getCompound("Music"));
        this.time = tag.getInt("Time");
    }
}

