/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.ceremony;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.TotemicEntityTypeTags;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.util.MiscUtil;

public enum AnimalGrowthCeremony implements CeremonyInstance
{
    INSTANCE;

    private static final int RADIUS = 8;
    private static final int TURTLE_HATCH_RADIUS = 6;

    @Override
    public void effect(Level level, BlockPos pos, CeremonyEffectContext context) {
        if (context.getTime() % 20 == 0) {
            AABB aabb = TotemicEntityUtil.getAABBAround(pos, 8.0);
            AnimalGrowthCeremony.growAnimals(level, aabb);
            AnimalGrowthCeremony.hatchChickenEggs(level, aabb);
            AnimalGrowthCeremony.hatchTurtleEggs(level, pos);
        }
    }

    private static void growAnimals(Level level, AABB aabb) {
        level.getEntitiesOfClass(Animal.class, aabb, animal -> animal.isBaby() && !animal.getType().is(TotemicEntityTypeTags.HYMN_OF_MATURITY_BLACKLIST)).forEach(animal -> {
            if (level.random.nextInt(4) == 0) {
                if (!level.isClientSide) {
                    animal.ageUp(level.random.nextInt(60));
                } else {
                    AABB animalBB = animal.getBoundingBox();
                    AnimalGrowthCeremony.spawnParticles(level, animal.position().add(0.0, animalBB.getYsize() * 0.5, 0.0), animalBB.getXsize() * 0.5, animalBB.getYsize() * 0.5, animalBB.getZsize() * 0.5);
                }
            }
        });
    }

    private static void hatchChickenEggs(Level level, AABB aabb) {
        if (!level.isClientSide) {
            level.getEntities((EntityTypeTest)EntityType.ITEM, aabb, e -> e.getItem().is(Items.EGG)).forEach(egg -> {
                if (level.random.nextInt(4) == 0) {
                    MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, level, egg.position(), 10, new Vec3(0.5, 0.5, 0.5), 1.0);
                    Chicken chicken = (Chicken)EntityType.CHICKEN.create(level);
                    if (chicken == null) {
                        return;
                    }
                    chicken.setAge(-24000);
                    chicken.moveTo(egg.position(), level.random.nextFloat() * 360.0f, 0.0f);
                    level.addFreshEntity((Entity)chicken);
                    MiscUtil.shrinkItemEntity(egg);
                }
            });
        }
    }

    private static void hatchTurtleEggs(Level level, BlockPos pos) {
        TotemicAPI.get().ceremony().forEachBlockIn(level, TotemicEntityUtil.getBoundingBoxAround(pos, 6), (p, state) -> {
            if (state.is(Blocks.TURTLE_EGG) && TurtleEggBlock.onSand((BlockGetter)level, (BlockPos)p)) {
                if (!level.isClientSide) {
                    if (level.random.nextInt(45) == 0) {
                        AnimalGrowthCeremony.hatchTurtleEgg(level, p, state);
                    }
                } else if (level.random.nextInt(4) == 0) {
                    AnimalGrowthCeremony.spawnParticles(level, Vec3.atBottomCenterOf((Vec3i)p).add(0.0, 0.25, 0.0), 0.5, 0.5, 0.5);
                }
            }
        });
    }

    private static void hatchTurtleEgg(Level level, BlockPos pos, BlockState state) {
        int age = (Integer)state.getValue((Property)TurtleEggBlock.HATCH);
        if (age < 2) {
            level.playSound(null, pos, SoundEvents.TURTLE_EGG_CRACK, SoundSource.BLOCKS, 0.7f, 0.9f + level.random.nextFloat() * 0.2f);
            level.setBlock(pos, (BlockState)state.setValue((Property)TurtleEggBlock.HATCH, (Comparable)Integer.valueOf(age + 1)), 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
        } else {
            level.playSound(null, pos, SoundEvents.TURTLE_EGG_HATCH, SoundSource.BLOCKS, 0.7f, 0.9f + level.random.nextFloat() * 0.2f);
            level.removeBlock(pos, false);
            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((BlockState)state));
            for (int j = 0; j < (Integer)state.getValue((Property)TurtleEggBlock.EGGS); ++j) {
                level.levelEvent(2001, pos, Block.getId((BlockState)state));
                Turtle turtle = (Turtle)EntityType.TURTLE.create(level);
                if (turtle == null) continue;
                turtle.setAge(-24000);
                turtle.setHomePos(pos);
                turtle.moveTo((double)pos.getX() + 0.3 + (double)j * 0.2, (double)pos.getY(), (double)pos.getZ() + 0.3, 0.0f, 0.0f);
                level.addFreshEntity((Entity)turtle);
            }
        }
    }

    private static void spawnParticles(Level level, Vec3 pos, double xSpread, double ySpread, double zSpread) {
        RandomSource rand = level.random;
        for (int i = 0; i < 10; ++i) {
            Vec3 vec = pos.add(rand.nextGaussian() * xSpread, rand.nextGaussian() * ySpread, rand.nextGaussian() * zSpread);
            level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, vec.x, vec.y, vec.z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int getEffectTime() {
        return 900;
    }
}

