/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.ceremony;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.util.MiscUtil;

public enum FertilityCeremony implements CeremonyInstance
{
    INSTANCE;

    private static final int RADIUS = 8;
    private static final int SAPLING_TRANSFORM_RADIUS = 6;

    @Override
    public void effect(Level level, BlockPos pos, CeremonyEffectContext context) {
        if (level.isClientSide) {
            return;
        }
        if (context.getTime() % 20 == 0) {
            FertilityCeremony.transformSaplings(level, pos);
            FertilityCeremony.breedAnimalsAndVillagers(level, pos, context);
        }
    }

    private static void transformSaplings(Level level, BlockPos pos) {
        BlockPos.betweenClosedStream((BoundingBox)TotemicEntityUtil.getBoundingBoxAround(pos, 6)).filter(p -> {
            BlockState state = level.getBlockState(p);
            return state.is(BlockTags.SAPLINGS) && state.getBlock() != ModBlocks.cedar_sapling.get();
        }).findAny().ifPresent(p -> {
            level.setBlock(p, ((SaplingBlock)ModBlocks.cedar_sapling.get()).defaultBlockState(), 3);
            MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, level, Vec3.atCenterOf((Vec3i)p), 10, new Vec3(0.5, 0.5, 0.5), 0.0);
        });
    }

    private static void breedAnimalsAndVillagers(Level level, BlockPos pos, CeremonyEffectContext context) {
        AABB aabb = TotemicEntityUtil.getAABBAround(pos, 8.0);
        for (Animal animal : level.getEntitiesOfClass(Animal.class, aabb, a -> a.getAge() == 0 && !a.isInLove())) {
            Optional<ItemEntity> itemE = FertilityCeremony.findItemEntity(level, pos, arg_0 -> ((Animal)animal).isFood(arg_0));
            if (!itemE.isPresent()) continue;
            if (level.random.nextInt(3) < 2) {
                MiscUtil.shrinkItemEntity(itemE.get());
            }
            animal.setInLove((Player)context.getInitiatingPlayer().orElse(null));
            return;
        }
    }

    private static Optional<ItemEntity> findItemEntity(Level level, BlockPos pos, Predicate<ItemStack> predicate) {
        List list = level.getEntities((EntityTypeTest)EntityType.ITEM, TotemicEntityUtil.getAABBAround(pos, 8.0), e -> predicate.test(e.getItem()));
        return !list.isEmpty() ? Optional.of((ItemEntity)list.get(0)) : Optional.empty();
    }

    @Override
    public int getEffectTime() {
        return 400;
    }
}

