/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.ceremony;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.ceremony.StartupContext;
import pokefenn.totemic.init.ModResources;

public enum SunDanceCeremony implements CeremonyInstance
{
    INSTANCE;

    private static final int RANGE = 8;

    @Override
    public void onStartup(Level level, BlockPos pos, StartupContext context) {
        if (!level.isClientSide && context.getTime() % 20 == 10) {
            DamageSource dmgSrc = new DamageSource((Holder)level.damageSources().damageTypes.getHolderOrThrow(ModResources.SUN_DANCE_DMG), pos.getCenter());
            TotemicEntityUtil.getPlayersIn(level, TotemicEntityUtil.getAABBAround(pos, 8.0), player -> !player.isSpectator() && player.getHealth() > 1.0f).forEach(player -> player.hurt(dmgSrc, 1.0f));
        }
    }

    @Override
    public void effect(Level level, BlockPos pos, CeremonyEffectContext context) {
        if (!level.isClientSide) {
            TotemicEntityUtil.getPlayersIn(level, TotemicEntityUtil.getAABBAround(pos, 8.0)).forEach(player -> {
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 300, 3), (Entity)context.getInitiator().orElse(null));
                player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 6000, 4), (Entity)context.getInitiator().orElse(null));
            });
        }
    }
}

