/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import pokefenn.totemic.entity.BaldEagle;

public class BaldEagleModel<T extends BaldEagle>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart tail;

    public BaldEagleModel(ModelPart root) {
        super(true, 10.0f, 1.0f);
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leftLeg = root.getChild("leftLeg");
        this.rightLeg = root.getChild("rightLeg");
        this.leftWing = root.getChild("leftWing");
        this.rightWing = root.getChild("rightWing");
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(10, 5).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f, false), PartPose.offset((float)0.0f, (float)15.0f, (float)-2.76f));
        head.addOrReplaceChild("headTop", CubeListBuilder.create().texOffs(8, 0).addBox(-1.0f, -0.5f, -2.0f, 2.0f, 1.0f, 4.0f, false), PartPose.offset((float)0.0f, (float)-2.0f, (float)-1.0f));
        head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(2, 0).addBox(-0.5f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, false), PartPose.offset((float)-0.5f, (float)-0.5f, (float)-1.5f));
        PartDefinition beak = head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(0, 3).addBox(-0.5f, 0.1f, -3.3f, 2.0f, 2.0f, 3.0f, false), PartPose.offsetAndRotation((float)-0.5f, (float)-1.65f, (float)-1.65f, (float)0.0f, (float)0.006457718f, (float)0.0f));
        beak.addOrReplaceChild("beakTip", CubeListBuilder.create().texOffs(2, 8).addBox(-0.5f, 1.2f, -3.35f, 2.0f, 1.0f, 1.0f, false), PartPose.offset((float)0.0f, (float)0.15f, (float)0.05f));
        root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(8, 10).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 7.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)16.0f, (float)-3.0f, (float)0.49375364f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(8, 20).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.offset((float)-1.0f, (float)22.0f, (float)-1.05f));
        root.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(12, 20).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.offset((float)1.0f, (float)22.0f, (float)-1.05f));
        root.addOrReplaceChild("leftWing", CubeListBuilder.create().texOffs(0, 10).addBox(-0.5f, 0.0f, -1.5f, 1.0f, 6.0f, 3.0f, false), PartPose.offsetAndRotation((float)-1.5f, (float)16.94f, (float)-2.76f, (float)-0.6981317f, (float)((float)(-Math.PI)), (float)0.08726646f));
        root.addOrReplaceChild("rightWing", CubeListBuilder.create().texOffs(20, 10).addBox(-0.5f, 0.0f, -1.5f, 1.0f, 6.0f, 3.0f, false), PartPose.offsetAndRotation((float)1.5f, (float)16.94f, (float)-2.76f, (float)-0.6981317f, (float)((float)(-Math.PI)), (float)-0.08726646f));
        root.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 20).addBox(-1.5f, -0.2f, -1.0f, 3.0f, 5.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)21.07f, (float)1.16f, (float)1.0831513f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    protected Iterable<ModelPart> headParts() {
        return List.of(this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return List.of(this.body, this.leftLeg, this.rightLeg, this.leftWing, this.rightWing, this.tail);
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.setupAnim(this.getState(pEntity), pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
    }

    private void setupAnim(State state, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.xRot = pHeadPitch * ((float)Math.PI / 180);
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.zRot = 0.0f;
        this.head.x = 0.0f;
        this.body.x = 0.0f;
        this.tail.x = 0.0f;
        this.rightWing.x = -1.5f;
        this.leftWing.x = 1.5f;
        switch (state.ordinal()) {
            case 2: {
                break;
            }
            case 1: {
                this.leftLeg.xRot += Mth.cos((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
                this.rightLeg.xRot += Mth.cos((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
            }
            default: {
                float f2 = pAgeInTicks * 0.3f;
                this.head.y = 15.69f + f2;
                this.tail.xRot = 1.015f + Mth.cos((float)(pLimbSwing * 0.6662f)) * 0.3f * pLimbSwingAmount;
                this.tail.y = 21.07f + f2;
                this.body.y = 16.5f + f2;
                this.leftWing.zRot = -0.0873f - pAgeInTicks;
                this.leftWing.y = 16.94f + f2;
                this.rightWing.zRot = 0.0873f + pAgeInTicks;
                this.rightWing.y = 16.94f + f2;
                this.leftLeg.y = 22.0f + f2;
                this.rightLeg.y = 22.0f + f2;
            }
        }
    }

    public void prepareMobModel(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.prepare(this.getState(pEntity));
    }

    private void prepare(State state) {
        this.body.xRot = 0.4937f;
        this.leftWing.xRot = -0.6981f;
        this.leftWing.yRot = (float)(-Math.PI);
        this.rightWing.xRot = -0.6981f;
        this.rightWing.yRot = (float)(-Math.PI);
        this.leftLeg.xRot = -0.0299f;
        this.rightLeg.xRot = -0.0299f;
        this.leftLeg.y = 22.0f;
        this.rightLeg.y = 22.0f;
        this.leftLeg.zRot = 0.0f;
        this.rightLeg.zRot = 0.0f;
        switch (state.ordinal()) {
            case 2: {
                this.head.y = 17.59f;
                this.tail.xRot = 1.5388988f;
                this.tail.y = 22.97f;
                this.body.y = 18.4f;
                this.leftWing.zRot = -0.0873f;
                this.leftWing.y = 18.84f;
                this.rightWing.zRot = 0.0873f;
                this.rightWing.y = 18.84f;
                this.leftLeg.y += 1.0f;
                this.rightLeg.y += 1.0f;
                this.leftLeg.xRot += 1.0f;
                this.rightLeg.xRot += 1.0f;
                break;
            }
            default: {
                break;
            }
            case 0: {
                this.leftLeg.xRot += 0.6981317f;
                this.rightLeg.xRot += 0.6981317f;
            }
        }
    }

    public void renderToBuffer(PoseStack ps, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        ps.pushPose();
        ps.translate(0.0f, -0.75f, 0.0f);
        ps.scale(1.5f, 1.5f, 1.5f);
        super.renderToBuffer(ps, buffer, packedLight, packedOverlay, color);
        ps.popPose();
    }

    private State getState(T entity) {
        if (entity.isInSittingPose()) {
            return State.SITTING;
        }
        return ((BaldEagle)((Object)entity)).isFlying() ? State.FLYING : State.STANDING;
    }

    private static enum State {
        FLYING,
        STANDING,
        SITTING;

    }
}

