/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.compat.kubejs;

import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import pokefenn.totemic.api.music.MusicInstrument;

public class ModifyMusicInstrumentsKubeEvent
implements KubeEvent {
    @Info(value="Modifies the given Music Instrument.\n")
    public void modify(MusicInstrument instr, Consumer<MusicInstrumentModification> c) {
        c.accept(new MusicInstrumentModification(instr));
    }

    public record MusicInstrumentModification(MusicInstrument instrument) {
        @Info(value="Sets the item stack that is associated with this instrument. This will be displayed in the Totempedia and on the Ceremony HUD.")
        public void setItem(ItemStack item) {
            this.instrument.setItem(item);
        }

        @Info(value="Sets the sound associated with this instrument. May be `null`, in which case no sound will be played.")
        public void setSound(@Nullable SoundEvent sound) {
            if (sound != null) {
                this.instrument.setSound(() -> sound);
            } else {
                this.instrument.setSound(null);
            }
        }

        @Info(value="Sets the default music output when the instrument is played. The instrument's actual music output may differ\nfrom this value, as the instrument can generally override it.\n\nHigher values generally make Ceremonies easier to perform.\n")
        public void setBaseOutput(int baseOutput) {
            this.instrument.setBaseOutput(baseOutput);
        }

        @Info(value="Sets the maximum amount of music that a Totem Base can receive from this instrument before getting saturated.\n\nThese values determine which Ceremonies can be performed at a given point in Totemic's progression, and should\nbe modified with care.\n")
        public void setMusicMaximum(int musicMaximum) {
            this.instrument.setMusicMaximum(musicMaximum);
        }
    }
}

