/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.data;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.init.ModEntityTypes;
import pokefenn.totemic.init.ModItems;

public final class TotemicLootTableProvider
extends LootTableProvider {
    public TotemicLootTableProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(pOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(TotemicBlockLoot::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(TotemicEntityLoot::new, LootContextParamSets.ENTITY)), registries);
    }

    private static class TotemicEntityLoot
    extends EntityLootSubProvider {
        public TotemicEntityLoot(HolderLookup.Provider registries) {
            super(FeatureFlags.REGISTRY.allFlags(), registries);
        }

        public void generate() {
            this.add(ModEntityTypes.buffalo.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.buffalo_hide.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)4.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.buffalo_tooth.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)0.6666667f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.buffalo_meat.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when((LootItemCondition.Builder)this.shouldSmeltLoot())).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))))));
            this.add(ModEntityTypes.bald_eagle.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.eagle_bone.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)0.6666667f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.eagle_feather.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add(ModEntityTypes.baykok.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)8.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ROTTEN_FLESH).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ARROW).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)10.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.lootTableItem((ItemLike)Items.WITHER_SKELETON_SKULL).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.25f, (float)0.05f)), LootItem.lootTableItem((ItemLike)Items.SKELETON_SKULL)}))));
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return ModEntityTypes.REGISTER.getEntries().stream().map(DeferredHolder::get);
        }
    }

    private static class TotemicBlockLoot
    extends BlockLootSubProvider {
        public TotemicBlockLoot(HolderLookup.Provider registries) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
        }

        protected void generate() {
            this.dropSelf((Block)ModBlocks.cedar_log.get());
            this.dropSelf((Block)ModBlocks.stripped_cedar_log.get());
            this.dropSelf((Block)ModBlocks.cedar_wood.get());
            this.dropSelf((Block)ModBlocks.stripped_cedar_wood.get());
            this.add((Block)ModBlocks.cedar_leaves.get(), b -> this.createLeavesDrops((Block)b, (Block)ModBlocks.cedar_sapling.get(), NORMAL_LEAVES_SAPLING_CHANCES));
            this.dropSelf((Block)ModBlocks.cedar_sapling.get());
            this.dropSelf((Block)ModBlocks.cedar_planks.get());
            this.dropSelf((Block)ModBlocks.cedar_button.get());
            this.dropSelf((Block)ModBlocks.cedar_fence.get());
            this.dropSelf((Block)ModBlocks.cedar_fence_gate.get());
            this.dropSelf((Block)ModBlocks.cedar_pressure_plate.get());
            this.dropSelf((Block)ModBlocks.cedar_sign.get());
            this.dropSelf((Block)ModBlocks.cedar_hanging_sign.get());
            this.add((Block)ModBlocks.cedar_slab.get(), x$0 -> this.createSlabItemTable((Block)x$0));
            this.dropSelf((Block)ModBlocks.cedar_stairs.get());
            this.add((Block)ModBlocks.cedar_door.get(), x$0 -> this.createDoorTable((Block)x$0));
            this.dropSelf((Block)ModBlocks.cedar_trapdoor.get());
            this.add((Block)ModBlocks.potted_cedar_sapling.get(), this.createPotFlowerItemTable((ItemLike)ModBlocks.cedar_sapling.get()));
            this.dropSelf((Block)ModBlocks.drum.get());
            this.dropSelf((Block)ModBlocks.wind_chime.get());
            this.dropSelf((Block)ModBlocks.totem_torch.get());
            this.dropSelf((Block)ModBlocks.tipi.get());
            this.add((Block)ModBlocks.totem_base.get(), TotemicBlockLoot.noDrop());
            this.add((Block)ModBlocks.totem_pole.get(), TotemicBlockLoot.noDrop());
        }

        protected Iterable<Block> getKnownBlocks() {
            return ModBlocks.REGISTER.getEntries().stream().map(DeferredHolder::get)::iterator;
        }
    }
}

