/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import pokefenn.totemic.TotemicConfig;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.block.totem.TotemBaseBlock;
import pokefenn.totemic.block.totem.TotemPoleBlock;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModDataComponents;

public class TotemKnifeItem
extends Item {
    private static List<TotemCarving> totemList;

    public TotemKnifeItem(Item.Properties props) {
        super(props);
    }

    private static MutableComponent getCarvingName(Optional<TotemCarving> carving) {
        return carving.map(TotemCarving::getDisplayName).orElseGet(() -> Component.translatable((String)"block.totemic.totem_base"));
    }

    public static Optional<TotemCarving> getCarving(ItemStack stack) {
        return Optional.ofNullable((TotemCarving)stack.get(ModDataComponents.CARVING));
    }

    public static ItemStack changeIndex(ItemStack stack, boolean direction) {
        Optional<TotemCarving> optCarving;
        int index;
        List<TotemCarving> locTotemList = totemList;
        if (locTotemList == null) {
            totemList = locTotemList = TotemicAPI.get().registry().totemCarvings().stream().filter(e -> e != ModContent.none.get()).toList();
        }
        int n = index = (optCarving = TotemKnifeItem.getCarving(stack)).isEmpty() ? -1 : locTotemList.indexOf(optCarving.get());
        if (index == -1) {
            index = direction ? 0 : locTotemList.size() - 1;
        } else if ((index += direction ? 1 : -1) >= locTotemList.size()) {
            index = -1;
        }
        ItemStack newStack = stack.copy();
        if (index == -1) {
            newStack.remove(ModDataComponents.CARVING);
        } else {
            newStack.set(ModDataComponents.CARVING, (Object)locTotemList.get(index));
        }
        return newStack;
    }

    public InteractionResult useOn(UseOnContext c) {
        Player player = c.getPlayer();
        if (player != null && player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        BlockState state = c.getLevel().getBlockState(c.getClickedPos());
        Optional<TotemWoodType> woodType = TotemKnifeItem.getWoodTypeForLog(state);
        if (woodType.isEmpty()) {
            return InteractionResult.FAIL;
        }
        Optional<TotemCarving> carving = TotemKnifeItem.getCarving(c.getItemInHand());
        if (carving.isPresent()) {
            if (TotemKnifeItem.isCarvingDisabled(carving.get(), player)) {
                return InteractionResult.FAIL;
            }
            BlockState newState = ((TotemPoleBlock)((Object)ModBlocks.totem_pole.get())).getStateForPlacement(new BlockPlaceContext(c));
            c.getLevel().setBlock(c.getClickedPos(), newState, 11);
            c.getLevel().getBlockEntity(c.getClickedPos(), ModBlockEntities.totem_pole.get()).ifPresent(pole -> pole.setAppearance((TotemWoodType)woodType.get(), (TotemCarving)carving.get()));
        } else {
            BlockState newState = ((TotemBaseBlock)((Object)ModBlocks.totem_base.get())).getStateForPlacement(new BlockPlaceContext(c));
            c.getLevel().setBlock(c.getClickedPos(), newState, 11);
            c.getLevel().getBlockEntity(c.getClickedPos(), ModBlockEntities.totem_base.get()).ifPresent(base -> base.setWoodType((TotemWoodType)woodType.get()));
        }
        if (player != null) {
            c.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)c.getHand()));
        }
        c.getLevel().levelEvent(player, 2001, c.getClickedPos(), Block.getId((BlockState)state));
        return InteractionResult.sidedSuccess((boolean)c.getLevel().isClientSide);
    }

    private static Optional<TotemWoodType> getWoodTypeForLog(BlockState state) {
        return TotemicAPI.get().registry().woodTypes().stream().filter(wood -> state.is(wood.logTag())).findAny().or(() -> {
            if (state.is(BlockTags.LOGS_THAT_BURN)) {
                return Optional.of((TotemWoodType)ModContent.oak.get());
            }
            return Optional.empty();
        });
    }

    private static boolean isCarvingDisabled(TotemCarving carving, @Nullable Player player) {
        if (((List)TotemicConfig.SERVER.disabledTotemCarvings.get()).contains(carving.getRegistryName().toString())) {
            if (player != null && player.level().isClientSide()) {
                player.sendSystemMessage((Component)Component.translatable((String)"totemic.carvingDisabled", (Object[])new Object[]{carving.getDisplayName()}));
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            return InteractionResultHolder.success((Object)TotemKnifeItem.changeIndex(stack, true));
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId(stack), (Object[])new Object[]{TotemKnifeItem.getCarvingName(TotemKnifeItem.getCarving(stack))});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip")));
    }
}

