/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.InMemoryFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import pokefenn.totemic.api.TotemicAPI;

public final class TotemicConfig {
    public static final Common COMMON;
    public static final Client CLIENT;
    public static final Server SERVER;
    private static final ForgeConfigSpec commonSpec;
    private static final ForgeConfigSpec clientSpec;
    private static final ForgeConfigSpec serverSpec;

    private static Predicate<Object> isValidRegistryKey(Supplier<IForgeRegistry<?>> registry) {
        return obj -> {
            if (!(obj instanceof String)) {
                return false;
            }
            String str = (String)obj;
            ResourceLocation key = ResourceLocation.m_135820_((String)str);
            if (key == null) {
                return false;
            }
            return ((IForgeRegistry)registry.get()).containsKey(key);
        };
    }

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
        ModConfig commonModConfig = new ModConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec, context.getActiveContainer());
        context.getActiveContainer().addConfig(commonModConfig);
        Path configPath = FMLPaths.CONFIGDIR.get().resolve(commonModConfig.getFileName());
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().preserveInsertionOrder().autosave().onFileNotFound(FileNotFoundAction.READ_NOTHING).writingMode(WritingMode.REPLACE).build();
        configData.load();
        commonSpec.acceptConfig((CommentedConfig)configData);
    }

    static {
        Pair commonPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)commonPair.getLeft();
        commonSpec = (ForgeConfigSpec)commonPair.getRight();
        Pair clientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT = (Client)clientPair.getLeft();
        clientSpec = (ForgeConfigSpec)clientPair.getRight();
        Pair serverPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER = (Server)serverPair.getLeft();
        serverSpec = (ForgeConfigSpec)serverPair.getRight();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends Config>> customTotemWoodTypes;

        Common(ForgeConfigSpec.Builder builder) {
            Config emptyConfig = Config.wrap(Map.of(), (ConfigFormat)InMemoryFormat.defaultInstance());
            this.customTotemWoodTypes = builder.comment("This config option allows you to add custom wood types for Totem Bases and Totem Poles.\nMust be a list of tables with the following keys:\n  id: Required: The wood type's ID. Must be a valid resource location (Example: \"my_mod:my_wood_type\").\n  logs: Required: Specifies which log blocks are recognized as belonging to this wood type by the Totem Whittling Knife.\n        Currently, only block tags are supported. Must be a string starting with '#' specifying a valid block tag\n        (Example: \"#minecraft:crimson_stems\").\n  woodColor: Optional: An integer between 0 and 61 specifying the map color of the wood's inside.\n             See https://minecraft.wiki/w/Map_item_format#Color_table for a list of possible colors. Defaults to 13\n             (Oak Log's wood color).\n  barkColor: Optional: An integer between 0 and 61 specifying the map color of the wood's bark, see above. Defaults\n             to 34 (Oak Log's bark color).\n\nTextures and language keys for the corresponding Totem Pole/Base blocks need to be added via a resource pack.\nSee here for an example resource pack: https://github.com/TeamTotemic/Totemic/tree/1.20.1/CustomWoodTypeTestResources\n\nPlease note that issues will arise if the wood types are not the same on the server and client.\n\nExample entry:\n[[customTotemWoodTypes]]\n    id = \"my_mod:crimson\"\n    logs = \"#minecraft:crimson_stems\"\n    woodColor = 53  #optional\n    barkColor = 54  #optional").translation("totemic.config.customTotemWoodTypes").worldRestart().defineList(List.of("customTotemWoodTypes"), () -> List.of(emptyConfig), o -> o instanceof Config);
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Integer> ceremonyHudPositionX;
        public final ForgeConfigSpec.ConfigValue<Integer> ceremonyHudPositionY;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Totemic client-only configuration settings").translation("totemic.config.client").push("client");
            this.ceremonyHudPositionX = builder.comment("Horizontal position of the ceremony HUD (offset from center of the screen)").translation("totemic.config.ceremonyHudPositionX").define("ceremonyHudPositionX", (Object)0);
            this.ceremonyHudPositionY = builder.comment("Vertical position of the ceremony HUD (offset from center of the screen)").translation("totemic.config.ceremonyHudPositionY").define("ceremonyHudPositionY", (Object)-70);
        }
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> disabledCeremonies;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> disabledTotemCarvings;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Totemic server configuration settings. These settings are world specific and are synced from the server to clients.").translation("totemic.config.server").push("server");
            this.disabledCeremonies = builder.comment("List of Ceremonies that should be disabled. Note that disabling some of the Ceremonies will prevent progression in Totemic.").comment("Example: [\"totemic:rain\", \"totemic:drought\"]").comment("See the Totempedia with advanced tooltips enabled (F3+H) to look up the Ceremonies' IDs.").translation("totemic.config.disabledCeremonies").defineListAllowEmpty(List.of("disabledCeremonies"), List::of, TotemicConfig.isValidRegistryKey(() -> TotemicAPI.get().registry().ceremonies()));
            this.disabledTotemCarvings = builder.comment("List of Totem Carvings that should be disabled from being carved.").comment("Example: [\"totemic:spider\"]").comment("Use advanced tooltips (F3+H) to look up the Totem Carvings' IDs.").translation("totemic.config.disabledTotemCarvings").defineListAllowEmpty(List.of("disabledTotemCarvings"), List::of, TotemicConfig.isValidRegistryKey(() -> TotemicAPI.get().registry().totemCarvings()));
        }
    }
}

