/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.advancements.criterion;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.ceremony.Ceremony;

public class CeremonyTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private static final ResourceLocation ID = Totemic.resloc("performed_ceremony");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public TriggerInstance createInstance(JsonObject pJson, ContextAwarePredicate pPlayer, DeserializationContext pContext) {
        ResourceLocation name = new ResourceLocation(GsonHelper.m_13906_((JsonObject)pJson, (String)"ceremony"));
        Ceremony ceremony = (Ceremony)TotemicAPI.get().registry().ceremonies().getValue(name);
        if (ceremony == null) {
            throw new JsonSyntaxException("Unknown Ceremony '" + name + "'");
        }
        return new TriggerInstance(pPlayer, ceremony);
    }

    public void trigger(ServerPlayer player, Ceremony ceremony) {
        this.m_66234_(player, ti -> ti.matches(ceremony));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final Ceremony ceremony;

        public TriggerInstance(ContextAwarePredicate pPlayer, Ceremony ceremony) {
            super(ID, pPlayer);
            this.ceremony = ceremony;
        }

        public static TriggerInstance performedCeremony(Ceremony ceremony) {
            return new TriggerInstance(ContextAwarePredicate.f_285567_, ceremony);
        }

        public boolean matches(Ceremony cer) {
            return this.ceremony == cer;
        }

        public JsonObject m_7683_(SerializationContext pConditions) {
            JsonObject json = super.m_7683_(pConditions);
            json.addProperty("ceremony", this.ceremony.getRegistryName().toString());
            return json;
        }
    }
}

