/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.api.totem;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.totem.TotemEffect;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class TotemCarving {
    private final List<TotemEffect> effects;
    @Nullable
    private String descriptionId;

    public TotemCarving(TotemEffect effect) {
        this.effects = List.of(effect);
    }

    public TotemCarving(TotemEffect ... effects) {
        this.effects = List.of(effects);
    }

    public TotemCarving(List<? extends TotemEffect> effects) {
        this.effects = List.copyOf(effects);
    }

    public String getDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"totemic.totem", (ResourceLocation)this.getRegistryName());
        }
        return this.descriptionId;
    }

    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)this.getDescriptionId());
    }

    public final ResourceLocation getRegistryName() {
        return TotemicAPI.get().registry().totemCarvings().getKey((Object)this);
    }

    public List<TotemEffect> getEffects() {
        return this.effects;
    }

    public String toString() {
        return this.getRegistryName().toString();
    }
}

