/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.apiimpl.music;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import pokefenn.totemic.api.TotemicCapabilities;
import pokefenn.totemic.api.music.MusicAPI;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemState;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.util.BlockUtil;
import pokefenn.totemic.util.MiscUtil;

public enum MusicApiImpl implements MusicAPI
{
    INSTANCE;


    @Override
    public void playMusic(Level level, Vec3 pos, @Nullable Entity entity, MusicInstrument instr) {
        this.playMusic(level, pos, entity, instr, 5, instr.getBaseOutput());
    }

    @Override
    public void playMusic(@Nonnull Entity entity, MusicInstrument instr) {
        this.playMusic(entity.m_9236_(), entity.m_20182_(), entity, instr, 5, instr.getBaseOutput());
    }

    @Override
    public void playMusic(Level level, BlockPos pos, @Nullable Entity entity, MusicInstrument instr) {
        this.playMusic(level, Vec3.m_82512_((Vec3i)pos), entity, instr);
    }

    @Override
    public void playMusic(Level level, Vec3 pos, @Nullable Entity entity, MusicInstrument instr, int range, int amount) {
        MusicApiImpl.playInstrumentSound(level, pos, entity, instr);
        if (level.f_46443_) {
            return;
        }
        level.m_46473_().m_6180_("totemic.playMusic");
        MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.f_123758_, level, pos, 6, new Vec3(0.5, 0.5, 0.5), 0.0);
        List<MusicAcceptor> list = BlockUtil.getBlockEntitiesInRange(null, level, BlockPos.m_274446_((Position)pos), range).map(tile -> tile.getCapability(TotemicCapabilities.MUSIC_ACCEPTOR)).filter(LazyOptional::isPresent).map(lo -> (MusicAcceptor)lo.orElse(null)).filter(acc -> acc.canAcceptMusic(instr)).collect(MiscUtil.collectMaxElements(Comparator.comparing(MusicAcceptor::getPriority)));
        for (MusicAcceptor acc2 : list) {
            MusicAcceptor.MusicResult result = acc2.acceptMusic(instr, amount / list.size(), pos, entity);
            if (result.isSuccess()) {
                MiscUtil.spawnAlwaysVisibleServerParticles((ParticleOptions)ParticleTypes.f_123758_, level, acc2.getPosition(), 6, new Vec3(0.5, 0.5, 0.5), 0.0);
            }
            if (!result.isSaturated()) continue;
            MiscUtil.spawnAlwaysVisibleServerParticles((ParticleOptions)ParticleTypes.f_123796_, level, acc2.getPosition(), 6, new Vec3(0.5, 0.5, 0.5), 0.0);
        }
        level.m_46473_().m_7238_();
    }

    @Override
    public void playSelector(Level level, Vec3 pos, @Nonnull Entity entity, MusicInstrument instr) {
        this.playSelector(level, pos, entity, instr, 5);
    }

    @Override
    public void playSelector(@Nonnull Entity entity, MusicInstrument instr) {
        this.playSelector(entity.m_9236_(), entity.m_20182_(), entity, instr, 5);
    }

    @Override
    public void playSelector(Level level, BlockPos pos, @Nonnull Entity entity, MusicInstrument instr) {
        this.playSelector(level, Vec3.m_82512_((Vec3i)pos), entity, instr);
    }

    @Override
    public void playSelector(Level level, Vec3 pos, @Nonnull Entity entity, MusicInstrument instr, int range) {
        MusicApiImpl.playInstrumentSound(level, pos, entity, instr);
        if (level.f_46443_) {
            return;
        }
        level.m_46473_().m_6180_("totemic.playSelector");
        MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.f_123758_, level, pos, 6, new Vec3(0.5, 0.5, 0.5), 0.0);
        MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.f_123815_, level, pos, 2, new Vec3(0.5, 0.5, 0.5), 0.0);
        BlockUtil.getBlockEntitiesInRange((BlockEntityType)ModBlockEntities.totem_base.get(), level, BlockPos.m_274446_((Position)pos), range).map(TotemBaseBlockEntity::getTotemState).filter(TotemState::canSelect).max(Comparator.comparing(MusicAcceptor::getPriority).thenComparingDouble(acc -> -acc.getPosition().m_82557_(pos))).ifPresent(t -> t.addSelector(entity, instr));
        level.m_46473_().m_7238_();
    }

    private static void playInstrumentSound(Level level, Vec3 pos, @Nullable Entity entity, MusicInstrument instr) {
        if (instr.getSound() != null) {
            SoundSource source = entity instanceof Player ? SoundSource.PLAYERS : SoundSource.BLOCKS;
            level.m_6263_(entity instanceof Player ? (Player)entity : null, pos.f_82479_, pos.f_82480_, pos.f_82481_, instr.getSound().get(), source, 1.0f, 1.0f);
        }
    }
}

