/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemPoleBlockEntity;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.item.TotemPoleItem;
import pokefenn.totemic.util.BlockUtil;

public class TotemPoleBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.875);

    public TotemPoleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, WATERLOGGED});
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP) {
            this.findTotemBase((BlockGetter)level, currentPos).ifPresent(TotemBaseBlockEntity::onPoleChange);
        }
        BlockUtil.scheduleWaterloggedTick(state, currentPos, level);
        return state;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TotemWoodType woodType = TotemPoleItem.getWoodType(stack);
        TotemCarving carving = TotemPoleItem.getCarving(stack);
        level.m_141902_(pos, (BlockEntityType)ModBlockEntities.totem_pole.get()).ifPresent(pole -> pole.setAppearance(woodType, carving));
        this.findTotemBase((BlockGetter)level, pos).ifPresent(TotemBaseBlockEntity::onPoleChange);
    }

    private Optional<TotemBaseBlockEntity> findTotemBase(BlockGetter level, BlockPos currentPos) {
        for (int i = 0; i < 5; ++i) {
            BlockPos searchPos = currentPos.m_6625_(i + 1);
            BlockEntity blockEntity = level.m_7702_(searchPos);
            if (blockEntity instanceof TotemBaseBlockEntity) {
                TotemBaseBlockEntity base = (TotemBaseBlockEntity)blockEntity;
                return Optional.of(base);
            }
            if (!(blockEntity instanceof TotemPoleBlockEntity)) break;
        }
        return Optional.empty();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(BlockUtil.placedInWater(context)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter world, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new TotemPoleBlockEntity(pPos, pState);
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        return level.m_141902_(pos, (BlockEntityType)ModBlockEntities.totem_pole.get()).map(pole -> pole.getWoodType().getWoodColor()).orElse(defaultColor);
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        Optional tile = pLevel.m_141902_(pPos, (BlockEntityType)ModBlockEntities.totem_pole.get());
        TotemWoodType woodType = tile.map(TotemPoleBlockEntity::getWoodType).orElseGet((Supplier<TotemWoodType>)ModContent.oak);
        TotemCarving carving = tile.map(TotemPoleBlockEntity::getCarving).orElseGet((Supplier<TotemCarving>)ModContent.none);
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.m_41784_().m_128359_("Carving", carving.getRegistryName().toString());
        stack.m_41783_().m_128359_("Wood", woodType.getRegistryName().toString());
        return stack;
    }

    public void m_5871_(ItemStack pStack, BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        if (pFlag.m_7050_()) {
            String carvingID = Optional.ofNullable(pStack.m_41783_()).map(tag -> tag.m_128461_("Carving")).filter(str -> !str.isEmpty()).orElse("totemic:none");
            String woodTypeID = Optional.ofNullable(pStack.m_41783_()).map(tag -> tag.m_128461_("Wood")).filter(str -> !str.isEmpty()).orElse("totemic:oak");
            pTooltip.add((Component)Component.m_237110_((String)"totemic.carvingIdTooltip", (Object[])new Object[]{carvingID}).m_130940_(ChatFormatting.GRAY));
            pTooltip.add((Component)Component.m_237110_((String)"totemic.woodTypeIdTooltip", (Object[])new Object[]{woodTypeID}).m_130940_(ChatFormatting.GRAY));
        }
    }
}

