/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem.entity;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.TotemicCapabilities;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemPoleBlockEntity;
import pokefenn.totemic.block.totem.entity.TotemState;
import pokefenn.totemic.client.model.totem.TotemPoleModelData;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModContent;

public class TotemBaseBlockEntity
extends BlockEntity {
    private boolean needPoleUpdate = true;
    private ResourceLocation woodTypeLoc = ModContent.oak.getId();
    private volatile TotemWoodType woodType = (TotemWoodType)ModContent.oak.get();
    private final List<TotemCarving> carvingList = new ArrayList<TotemCarving>(5);
    private Set<TotemCarving> carvingSet = null;
    private Multiset<TotemEffect> totemEffects = ImmutableMultiset.of();
    private int commonTotemEffectInterval = Integer.MAX_VALUE;
    private TotemState state = new StateTotemEffect(this);
    private LazyOptional<MusicAcceptor> musicHandler = LazyOptional.of(() -> this.state);

    public TotemBaseBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.totem_base.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, TotemBaseBlockEntity tile) {
        if (tile.needPoleUpdate) {
            tile.calculateTotemEffects();
            tile.needPoleUpdate = false;
        }
        tile.state.tick();
    }

    private void calculateTotemEffects() {
        BlockEntity blockEntity;
        this.carvingList.clear();
        this.carvingSet = null;
        ImmutableMultiset.Builder totemEffectsBuilder = ImmutableMultiset.builder();
        for (int i = 0; i < 5 && (blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_6630_(i + 1))) instanceof TotemPoleBlockEntity; ++i) {
            TotemPoleBlockEntity pole = (TotemPoleBlockEntity)blockEntity;
            TotemCarving carving = pole.getCarving();
            this.carvingList.add(carving);
            totemEffectsBuilder.addAll(carving.getEffects());
        }
        this.totemEffects = totemEffectsBuilder.build();
        this.commonTotemEffectInterval = this.totemEffects.elementSet().stream().mapToInt(TotemEffect::getInterval).reduce(IntMath::gcd).orElse(Integer.MAX_VALUE);
    }

    public void onPoleChange() {
        this.needPoleUpdate = true;
    }

    public TotemWoodType getWoodType() {
        return this.woodType;
    }

    public void setWoodType(TotemWoodType woodType) {
        this.woodType = Objects.requireNonNull(woodType);
        this.woodTypeLoc = woodType.getRegistryName();
        this.requestModelDataUpdate();
        this.m_6596_();
    }

    public List<TotemCarving> getCarvingList() {
        return this.carvingList;
    }

    public boolean hasCarving(TotemCarving carving) {
        if (this.carvingSet == null) {
            this.carvingSet = Set.copyOf(this.carvingList);
        }
        return this.carvingSet.contains(carving);
    }

    public Multiset<TotemEffect> getTotemEffects() {
        return this.totemEffects;
    }

    public int getPoleSize() {
        return this.carvingList.size();
    }

    public int getCommonTotemEffectInterval() {
        return this.commonTotemEffectInterval;
    }

    public TotemState getTotemState() {
        return this.state;
    }

    void setTotemState(TotemState state) {
        if (state != this.state) {
            this.state = state;
            this.musicHandler.invalidate();
            this.musicHandler = LazyOptional.of(() -> this.state);
            if (this.f_58857_ != null) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
                this.m_6596_();
            }
        }
    }

    public void resetTotemState() {
        this.state.resetTotemState();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("Wood", this.woodTypeLoc.toString());
        tag.m_128344_("State", this.state.getID());
        this.state.save(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.woodTypeLoc = Objects.requireNonNullElse(ResourceLocation.m_135820_((String)tag.m_128461_("Wood")), ModContent.oak.getId());
        if (!TotemicAPI.get().registry().woodTypes().containsKey(this.woodTypeLoc)) {
            Totemic.logger.warn("Unknown Totem Wood Type: '{}'", (Object)this.woodTypeLoc);
        }
        this.woodType = (TotemWoodType)TotemicAPI.get().registry().woodTypes().getValue(this.woodTypeLoc);
        this.requestModelDataUpdate();
        if (tag.m_128425_("State", 99)) {
            byte id = tag.m_128445_("State");
            if (id != this.state.getID()) {
                this.state = TotemState.fromID(id, this);
            }
            this.state.load(tag);
        } else {
            this.state = new StateTotemEffect(this);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.musicHandler.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == TotemicCapabilities.MUSIC_ACCEPTOR) {
            return this.musicHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(TotemPoleModelData.WOOD_TYPE_PROPERTY, (Object)this.woodType).build();
    }
}

