/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem.entity;

import javax.annotation.Nonnull;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.block.totem.entity.StateCeremonyEffect;
import pokefenn.totemic.block.totem.entity.StateSelection;
import pokefenn.totemic.block.totem.entity.StateStartup;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemBaseBlockEntity;
import pokefenn.totemic.util.MiscUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TotemState
implements MusicAcceptor {
    final TotemBaseBlockEntity tile;

    TotemState(TotemBaseBlockEntity tile) {
        this.tile = tile;
    }

    public abstract void tick();

    public boolean canSelect() {
        return false;
    }

    public void addSelector(@Nonnull Entity entity, MusicInstrument instr) {
    }

    @Override
    public Vec3 getPosition() {
        return Vec3.m_82512_((Vec3i)this.tile.m_58899_());
    }

    public int getAnalogOutputSignal() {
        return 0;
    }

    void resetTotemState() {
        if (this.tile.m_58904_().f_46443_) {
            return;
        }
        MiscUtil.spawnAlwaysVisibleServerParticles((ParticleOptions)ParticleTypes.f_123755_, this.tile.m_58904_(), this.getPosition(), 16, new Vec3(0.6, 0.5, 0.6), 0.0);
        this.tile.setTotemState(new StateTotemEffect(this.tile));
    }

    static TotemState fromID(byte id, TotemBaseBlockEntity tile) {
        return switch (id) {
            case 0 -> new StateTotemEffect(tile);
            case 1 -> new StateSelection(tile);
            case 2 -> new StateStartup(tile);
            case 3 -> new StateCeremonyEffect(tile);
            default -> throw new IllegalArgumentException("Invalid Totem state");
        };
    }

    abstract byte getID();

    abstract void save(CompoundTag var1);

    abstract void load(CompoundTag var1);
}

