/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.ceremony;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.api.TotemicEntityTypeTags;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.entity.Buffalo;
import pokefenn.totemic.init.ModEntityTypes;
import pokefenn.totemic.util.MiscUtil;

public enum BuffaloDanceCeremony implements CeremonyInstance
{
    INSTANCE;

    private static final int RANGE = 8;
    private static final Predicate<Mob> CAN_APPLY_BUFFALO_DANCE;

    @Override
    public void effect(Level level, BlockPos pos, CeremonyEffectContext context) {
        if (level.f_46443_) {
            return;
        }
        level.m_6443_(Mob.class, TotemicEntityUtil.getAABBAround(pos, 8.0), CAN_APPLY_BUFFALO_DANCE).stream().limit(2L).forEach(cow -> {
            Buffalo buffalo = (Buffalo)((EntityType)ModEntityTypes.buffalo.get()).m_20615_(level);
            if (buffalo == null) {
                return;
            }
            float health = cow.m_21223_() / cow.m_21233_() * buffalo.m_21233_();
            buffalo.m_21153_(health);
            buffalo.m_146762_(-24000);
            buffalo.m_20359_((Entity)cow);
            if (cow.m_21523_()) {
                buffalo.m_21463_(cow.m_21524_(), true);
            }
            cow.m_146870_();
            level.m_7967_((Entity)buffalo);
            MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.f_123748_, level, buffalo.m_20182_().m_82520_(0.0, 1.0, 0.0), 24, new Vec3(0.6, 0.5, 0.6), 1.0);
        });
    }

    @Override
    public boolean canSelect(Level level, BlockPos pos, Entity initiator) {
        if (level.m_6443_(Mob.class, TotemicEntityUtil.getAABBAround(pos, 8.0), CAN_APPLY_BUFFALO_DANCE).isEmpty()) {
            initiator.m_213846_((Component)Component.m_237115_((String)"totemic.noCowsNearby"));
            return false;
        }
        return true;
    }

    static {
        CAN_APPLY_BUFFALO_DANCE = mob -> mob.m_6095_().m_204039_(TotemicEntityTypeTags.BUFFALO_DANCE_TARGETS) && mob.m_6084_();
    }
}

