/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import pokefenn.totemic.entity.BaldEagle;

public class BaldEagleModel<T extends BaldEagle>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart tail;

    public BaldEagleModel(ModelPart root) {
        super(true, 10.0f, 1.0f);
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.leftLeg = root.m_171324_("leftLeg");
        this.rightLeg = root.m_171324_("rightLeg");
        this.leftWing = root.m_171324_("leftWing");
        this.rightWing = root.m_171324_("rightWing");
        this.tail = root.m_171324_("tail");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(10, 5).m_171506_(-1.0f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f, false), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-2.76f));
        head.m_171599_("headTop", CubeListBuilder.m_171558_().m_171514_(8, 0).m_171506_(-1.0f, -0.5f, -2.0f, 2.0f, 1.0f, 4.0f, false), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-1.0f));
        head.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(2, 0).m_171506_(-0.5f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, false), PartPose.m_171419_((float)-0.5f, (float)-0.5f, (float)-1.5f));
        PartDefinition beak = head.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171506_(-0.5f, 0.1f, -3.3f, 2.0f, 2.0f, 3.0f, false), PartPose.m_171423_((float)-0.5f, (float)-1.65f, (float)-1.65f, (float)0.0f, (float)0.006457718f, (float)0.0f));
        beak.m_171599_("beakTip", CubeListBuilder.m_171558_().m_171514_(2, 8).m_171506_(-0.5f, 1.2f, -3.35f, 2.0f, 1.0f, 1.0f, false), PartPose.m_171419_((float)0.0f, (float)0.15f, (float)0.05f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(8, 10).m_171506_(-1.5f, 0.0f, -1.5f, 3.0f, 7.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-3.0f, (float)0.49375364f, (float)0.0f, (float)0.0f));
        root.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(8, 20).m_171506_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171419_((float)-1.0f, (float)22.0f, (float)-1.05f));
        root.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(12, 20).m_171506_(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f, false), PartPose.m_171419_((float)1.0f, (float)22.0f, (float)-1.05f));
        root.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171506_(-0.5f, 0.0f, -1.5f, 1.0f, 6.0f, 3.0f, false), PartPose.m_171423_((float)-1.5f, (float)16.94f, (float)-2.76f, (float)-0.6981317f, (float)((float)(-Math.PI)), (float)0.08726646f));
        root.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(20, 10).m_171506_(-0.5f, 0.0f, -1.5f, 1.0f, 6.0f, 3.0f, false), PartPose.m_171423_((float)1.5f, (float)16.94f, (float)-2.76f, (float)-0.6981317f, (float)((float)(-Math.PI)), (float)-0.08726646f));
        root.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171506_(-1.5f, -0.2f, -1.0f, 3.0f, 5.0f, 1.0f, false), PartPose.m_171423_((float)0.0f, (float)21.07f, (float)1.16f, (float)1.0831513f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return List.of(this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.body, this.leftLeg, this.rightLeg, this.leftWing, this.rightWing, this.tail);
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.setupAnim(this.getState(pEntity), pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
    }

    private void setupAnim(State state, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104205_ = 0.0f;
        this.head.f_104200_ = 0.0f;
        this.body.f_104200_ = 0.0f;
        this.tail.f_104200_ = 0.0f;
        this.rightWing.f_104200_ = -1.5f;
        this.leftWing.f_104200_ = 1.5f;
        switch (state) {
            case SITTING: {
                break;
            }
            case STANDING: {
                this.leftLeg.f_104203_ += Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount;
                this.rightLeg.f_104203_ += Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount;
            }
            default: {
                float f2 = pAgeInTicks * 0.3f;
                this.head.f_104201_ = 15.69f + f2;
                this.tail.f_104203_ = 1.015f + Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 0.3f * pLimbSwingAmount;
                this.tail.f_104201_ = 21.07f + f2;
                this.body.f_104201_ = 16.5f + f2;
                this.leftWing.f_104205_ = -0.0873f - pAgeInTicks;
                this.leftWing.f_104201_ = 16.94f + f2;
                this.rightWing.f_104205_ = 0.0873f + pAgeInTicks;
                this.rightWing.f_104201_ = 16.94f + f2;
                this.leftLeg.f_104201_ = 22.0f + f2;
                this.rightLeg.f_104201_ = 22.0f + f2;
            }
        }
    }

    public void prepareMobModel(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.prepare(this.getState(pEntity));
    }

    private void prepare(State state) {
        this.body.f_104203_ = 0.4937f;
        this.leftWing.f_104203_ = -0.6981f;
        this.leftWing.f_104204_ = (float)(-Math.PI);
        this.rightWing.f_104203_ = -0.6981f;
        this.rightWing.f_104204_ = (float)(-Math.PI);
        this.leftLeg.f_104203_ = -0.0299f;
        this.rightLeg.f_104203_ = -0.0299f;
        this.leftLeg.f_104201_ = 22.0f;
        this.rightLeg.f_104201_ = 22.0f;
        this.leftLeg.f_104205_ = 0.0f;
        this.rightLeg.f_104205_ = 0.0f;
        switch (state) {
            case SITTING: {
                this.head.f_104201_ = 17.59f;
                this.tail.f_104203_ = 1.5388988f;
                this.tail.f_104201_ = 22.97f;
                this.body.f_104201_ = 18.4f;
                this.leftWing.f_104205_ = -0.0873f;
                this.leftWing.f_104201_ = 18.84f;
                this.rightWing.f_104205_ = 0.0873f;
                this.rightWing.f_104201_ = 18.84f;
                this.leftLeg.f_104201_ += 1.0f;
                this.rightLeg.f_104201_ += 1.0f;
                this.leftLeg.f_104203_ += 1.0f;
                this.rightLeg.f_104203_ += 1.0f;
                break;
            }
            default: {
                break;
            }
            case FLYING: {
                this.leftLeg.f_104203_ += 0.6981317f;
                this.rightLeg.f_104203_ += 0.6981317f;
            }
        }
    }

    public void m_7695_(PoseStack ps, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        ps.m_85836_();
        ps.m_252880_(0.0f, -0.75f, 0.0f);
        ps.m_85841_(1.5f, 1.5f, 1.5f);
        super.m_7695_(ps, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        ps.m_85849_();
    }

    private State getState(T entity) {
        if (entity.m_21825_()) {
            return State.SITTING;
        }
        return ((BaldEagle)((Object)entity)).m_29443_() ? State.FLYING : State.STANDING;
    }

    private static enum State {
        FLYING,
        STANDING,
        SITTING;

    }
}

