/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.client.model.totem;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.registries.IForgeRegistry;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemWoodType;
import pokefenn.totemic.client.model.totem.BakedTotemPoleModel;
import pokefenn.totemic.client.model.totem.TotemPoleModelData;

public final class TotemPoleModel
implements IUnbakedGeometry<TotemPoleModel> {
    private Map<TotemPoleModelData, UnbakedModel> totemModels = null;

    private TotemPoleModel() {
    }

    public BakedModel bake(IGeometryBakingContext ctx, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        Map<TotemPoleModelData, BakedModel> bakedModels = Map.copyOf(Maps.transformValues(this.totemModels, unbaked -> unbaked.m_7611_(bakery, spriteGetter, modelState, modelLocation)));
        return new BakedTotemPoleModel(bakedModels);
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext ctx) {
        if (this.totemModels == null) {
            IForgeRegistry<TotemWoodType> woodTypeRegistry = TotemicAPI.get().registry().woodTypes();
            IForgeRegistry<TotemCarving> carvingRegistry = TotemicAPI.get().registry().totemCarvings();
            this.totemModels = Maps.newHashMapWithExpectedSize((int)(woodTypeRegistry.getValues().size() * carvingRegistry.getValues().size()));
            for (TotemWoodType woodType : woodTypeRegistry) {
                BlockModel woodTypeModel = (BlockModel)modelGetter.apply(TotemPoleModel.getWoodTypeModelName(woodType));
                if (woodTypeModel.getParentLocation() != null) {
                    Totemic.logger.error("Error loading {}: Parents are not supported for Totem Wood Type models", (Object)woodTypeModel);
                }
                Map textureMap = woodTypeModel.f_111417_;
                for (TotemCarving carving : carvingRegistry) {
                    BlockModel model = new BlockModel(TotemPoleModel.getPoleModelName(carving), List.of(), textureMap, Boolean.valueOf(ctx.useAmbientOcclusion()), null, ctx.getTransforms(), List.of());
                    model.f_111416_ = ctx.getModelName() + "[" + woodType.getRegistryName() + ", " + carving.getRegistryName() + "]";
                    this.totemModels.put(new TotemPoleModelData(woodType, carving), (UnbakedModel)model);
                    model.m_5500_(modelGetter);
                }
            }
        }
    }

    private static ResourceLocation getWoodTypeModelName(TotemWoodType woodType) {
        ResourceLocation woodName = woodType.getRegistryName();
        return new ResourceLocation(woodName.m_135827_(), "block/" + woodName.m_135815_() + "_totem_pole");
    }

    private static ResourceLocation getPoleModelName(TotemCarving carving) {
        ResourceLocation carvingName = carving.getRegistryName();
        return new ResourceLocation(carvingName.m_135827_(), "block/totem_pole_" + carvingName.m_135815_());
    }

    public static enum Loader implements IGeometryLoader<TotemPoleModel>
    {
        INSTANCE;


        public TotemPoleModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return new TotemPoleModel();
        }
    }
}

