/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.compat;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.ceremony.Ceremony;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class CeremonyComponentProcessor
implements IComponentProcessor {
    private Ceremony ceremony;

    public void setup(Level level, IVariableProvider variables) {
        String ceremonyId = variables.get("ceremony").asString();
        this.ceremony = (Ceremony)TotemicAPI.get().registry().ceremonies().getValue(new ResourceLocation(ceremonyId));
        if (this.ceremony == null) {
            throw new IllegalArgumentException("Invalid Ceremony: '" + ceremonyId + "'");
        }
    }

    public IVariable process(Level level, String key) {
        return switch (key) {
            case "selector0" -> IVariable.from((Object)this.getSelectorItem(0));
            case "selector1" -> IVariable.from((Object)this.getSelectorItem(1));
            default -> null;
        };
    }

    private ItemStack getSelectorItem(int index) {
        return this.ceremony.getSelectors().get(index).getItem();
    }
}

