/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.data;

import java.util.Set;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.ObjModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.util.TransformationHelper;
import net.minecraftforge.registries.RegistryObject;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.block.TipiBlock;
import pokefenn.totemic.block.totem.TotemBaseBlock;
import pokefenn.totemic.block.totem.TotemPoleBlock;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.init.ModItems;

public final class TotemicBlockStateProvider
extends BlockStateProvider {
    public TotemicBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "totemic", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.logBlock((RotatedPillarBlock)ModBlocks.cedar_log.get());
        this.logBlock((RotatedPillarBlock)ModBlocks.stripped_cedar_log.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.cedar_wood.get(), this.blockTexture((Block)ModBlocks.cedar_log.get()), this.blockTexture((Block)ModBlocks.cedar_log.get()));
        this.axisBlock((RotatedPillarBlock)ModBlocks.stripped_cedar_wood.get(), this.blockTexture((Block)ModBlocks.stripped_cedar_log.get()), this.blockTexture((Block)ModBlocks.stripped_cedar_log.get()));
        this.simpleBlock((Block)ModBlocks.cedar_leaves.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent("totemic:cedar_leaves", "block/leaves")).texture("all", "totemic:block/cedar_leaves"));
        ((BlockModelBuilder)this.models().withExistingParent("totemic:cedar_leaves_opaque", "block/leaves")).texture("all", "totemic:block/cedar_leaves_opaque");
        this.simpleBlock((Block)ModBlocks.cedar_sapling.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ModBlocks.cedar_sapling.getId().toString(), "block/cross")).texture("cross", this.blockTexture((Block)ModBlocks.cedar_sapling.get()))).renderType("cutout"));
        this.simpleBlock((Block)ModBlocks.drum.get(), (ModelFile)this.models().getExistingFile(this.modLoc("drum")));
        this.simpleBlock((Block)ModBlocks.wind_chime.get(), (ModelFile)this.blockEntityRenderer(ModBlocks.wind_chime, this.mcLoc("block/white_terracotta")).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 1.25f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.875f).end().end());
        this.simpleBlock((Block)ModBlocks.cedar_planks.get());
        ResourceLocation cedarPlankTex = this.blockTexture((Block)ModBlocks.cedar_planks.get());
        this.buttonBlock((ButtonBlock)ModBlocks.cedar_button.get(), cedarPlankTex);
        this.fenceBlock((FenceBlock)ModBlocks.cedar_fence.get(), cedarPlankTex);
        this.fenceGateBlock((FenceGateBlock)ModBlocks.cedar_fence_gate.get(), cedarPlankTex);
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.cedar_pressure_plate.get(), cedarPlankTex);
        this.signBlock((StandingSignBlock)ModBlocks.cedar_sign.get(), (WallSignBlock)ModBlocks.cedar_wall_sign.get(), cedarPlankTex);
        this.hangingSignBlock(ModBlocks.cedar_hanging_sign, ModBlocks.cedar_wall_hanging_sign, this.blockTexture((Block)ModBlocks.stripped_cedar_log.get()));
        this.slabBlock((SlabBlock)ModBlocks.cedar_slab.get(), ModBlocks.cedar_planks.getId(), cedarPlankTex, cedarPlankTex, cedarPlankTex);
        this.stairsBlock((StairBlock)ModBlocks.cedar_stairs.get(), cedarPlankTex);
        this.doorBlock((DoorBlock)ModBlocks.cedar_door.get(), this.modLoc("block/cedar_door_bottom"), this.modLoc("block/cedar_door_top"));
        this.trapdoorBlock((TrapDoorBlock)ModBlocks.cedar_trapdoor.get(), this.modLoc("block/cedar_trapdoor"), true);
        this.simpleBlock((Block)ModBlocks.potted_cedar_sapling.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(ModBlocks.potted_cedar_sapling.getId().toString(), this.mcLoc("block/flower_pot_cross"), "plant", this.blockTexture((Block)ModBlocks.cedar_sapling.get()))).renderType("cutout"));
        this.simpleBlock((Block)ModBlocks.totem_torch.get(), (ModelFile)this.models().getExistingFile(this.modLoc("totem_torch")));
        this.horizontalBlockIgnoringProperties((Block)ModBlocks.tipi.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((ObjModelBuilder)((BlockModelBuilder)this.models().getBuilder(ModBlocks.tipi.getId().toString())).customLoader(ObjModelBuilder::begin)).modelLocation(this.modLoc("models/block/tipi.obj")).end()).texture("particle", this.mcLoc("block/white_wool"))).rootTransforms().origin(TransformationHelper.TransformOrigin.CORNER).translation(0.0f, 0.95f, 0.0f).scale(2.85f).end(), 0, new Property[]{TipiBlock.OCCUPIED});
        this.simpleBlock((Block)ModBlocks.dummy_tipi.get(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent(ModBlocks.dummy_tipi.getId().toString(), "block/air")).texture("particle", this.mcLoc("block/white_wool")));
        this.horizontalBlockIgnoringProperties((Block)ModBlocks.totem_pole.get(), (ModelFile)this.models().getExistingFile(this.modLoc("dynamic_totem_pole")), new Property[]{TotemPoleBlock.WATERLOGGED});
        this.horizontalBlockIgnoringProperties((Block)ModBlocks.totem_base.get(), (ModelFile)this.models().getExistingFile(this.modLoc("dynamic_totem_base")), new Property[]{TotemBaseBlock.WATERLOGGED});
        this.totemWoodTypes();
        ItemModelProvider im = this.itemModels();
        Set<ResourceLocation> blocksWithCustomItemModel = Set.of(ModBlocks.cedar_sapling.getId(), ModBlocks.cedar_button.getId(), ModBlocks.cedar_fence.getId(), ModBlocks.cedar_door.getId(), ModBlocks.cedar_trapdoor.getId(), ModBlocks.cedar_sign.getId(), ModBlocks.cedar_wall_sign.getId(), ModBlocks.cedar_hanging_sign.getId(), ModBlocks.cedar_wall_hanging_sign.getId(), ModBlocks.potted_cedar_sapling.getId(), ModBlocks.totem_torch.getId(), ModBlocks.tipi.getId(), ModBlocks.dummy_tipi.getId(), ModBlocks.totem_base.getId(), ModBlocks.totem_pole.getId());
        for (RegistryObject blockO : ModBlocks.REGISTER.getEntries()) {
            if (blocksWithCustomItemModel.contains(blockO.getId())) continue;
            this.existingBlockItem((RegistryObject<? extends Block>)blockO);
        }
        im.singleTexture(ModBlocks.cedar_sapling.getId().toString(), this.mcLoc("item/generated"), "layer0", this.blockTexture((Block)ModBlocks.cedar_sapling.get()));
        ((ItemModelBuilder)im.withExistingParent(ModBlocks.cedar_button.getId().toString(), "block/button_inventory")).texture("texture", cedarPlankTex);
        ((ItemModelBuilder)im.withExistingParent(ModBlocks.cedar_fence.getId().toString(), "block/fence_inventory")).texture("texture", cedarPlankTex);
        im.basicItem(ModBlocks.cedar_door.getId());
        im.withExistingParent(ModBlocks.cedar_trapdoor.getId().toString(), this.modLoc("block/cedar_trapdoor_bottom"));
        im.basicItem(ModBlocks.cedar_sign.getId());
        im.basicItem(ModBlocks.cedar_hanging_sign.getId());
        ((ItemModelBuilder)im.withExistingParent(ModBlocks.totem_torch.getId().toString(), this.modLoc("block/totem_torch"))).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, 45.0f, 0.0f).translation(0.0f, 1.5f, 1.0f).scale(0.25f).end().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, -1.0f, 0.0f).scale(0.625f).end().transform(ItemDisplayContext.FIXED).translation(0.0f, 0.0f, 0.25f).scale(0.5f).end().end();
        ((ItemModelBuilder)((ObjModelBuilder)((ItemModelBuilder)im.getBuilder(ModBlocks.tipi.getId().toString())).customLoader(ObjModelBuilder::begin)).modelLocation(this.modLoc("models/block/tipi.obj")).end()).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, -2.5f, 0.0f).scale(0.4f).end().transform(ItemDisplayContext.GROUND).scale(0.25f).end().transform(ItemDisplayContext.FIXED).translation(0.0f, -2.5f, 0.0f).scale(0.4f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 0.05f, 0.0f).scale(0.25f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 0.05f, 0.0f).scale(0.25f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 45.0f, 0.0f).scale(0.25f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).scale(0.25f).end().end();
        im.withExistingParent(ModBlocks.totem_base.getId().toString(), this.modLoc("block/dynamic_totem_base"));
        im.withExistingParent(ModBlocks.totem_pole.getId().toString(), this.modLoc("block/dynamic_totem_pole"));
        im.basicItem(ModItems.flute.getId());
        im.basicItem(ModItems.infused_flute.getId());
        im.basicItem(ModItems.jingle_dress.getId());
        this.basicItemWithParent(ModItems.rattle, this.mcLoc("item/handheld"));
        im.basicItem(ModItems.eagle_bone_whistle.getId());
        this.basicItemWithParent(ModItems.totem_whittling_knife, this.mcLoc("item/handheld"));
        this.basicItemWithParent(ModItems.totemic_staff, this.mcLoc("item/handheld"));
        this.basicItemWithParent(ModItems.ceremony_cheat, this.mcLoc("item/handheld"));
        im.withExistingParent(ModItems.buffalo_spawn_egg.getId().toString(), "item/template_spawn_egg");
        im.withExistingParent(ModItems.bald_eagle_spawn_egg.getId().toString(), "item/template_spawn_egg");
        im.withExistingParent(ModItems.baykok_spawn_egg.getId().toString(), "item/template_spawn_egg");
        im.basicItem(ModItems.buffalo_meat.getId());
        im.basicItem(ModItems.cooked_buffalo_meat.getId());
        im.basicItem(ModItems.buffalo_tooth.getId());
        im.basicItem(ModItems.buffalo_hide.getId());
        im.basicItem(ModItems.iron_bells.getId());
        im.basicItem(ModItems.eagle_bone.getId());
        im.basicItem(ModItems.eagle_feather.getId());
        ItemModelBuilder baykokBow = (ItemModelBuilder)((ItemModelBuilder)im.withExistingParent(ModItems.baykok_bow.getId().toString(), "item/bow")).texture("layer0", this.modLoc("item/baykok_bow"));
        baykokBow.override().predicate(this.mcLoc("pulling"), 1.0f).model((ModelFile)im.basicItem(this.modLoc("baykok_bow_pulling_0")).parent((ModelFile)baykokBow)).end();
        baykokBow.override().predicate(this.mcLoc("pulling"), 1.0f).predicate(this.mcLoc("pull"), 0.65f).model((ModelFile)im.basicItem(this.modLoc("baykok_bow_pulling_1")).parent((ModelFile)baykokBow)).end();
        baykokBow.override().predicate(this.mcLoc("pulling"), 1.0f).predicate(this.mcLoc("pull"), 0.9f).model((ModelFile)im.basicItem(this.modLoc("baykok_bow_pulling_2")).parent((ModelFile)baykokBow)).end();
        im.basicItem(this.modLoc("totempedia"));
        ItemModelBuilder medBagOpen = im.basicItem(this.modLoc("medicine_bag_open"));
        ItemModelBuilder medBag = im.basicItem(ModItems.medicine_bag.getId()).override().predicate(this.modLoc("open"), 1.0f).model((ModelFile)medBagOpen).end();
        ((ItemModelBuilder)((ItemModelBuilder)im.getBuilder(ModItems.creative_medicine_bag.getId().toString())).parent((ModelFile)medBag)).override().predicate(this.modLoc("open"), 1.0f).model((ModelFile)medBagOpen).end();
    }

    private void totemWoodTypes() {
        for (ResourceLocation woodTypeKey : TotemicAPI.get().registry().woodTypes().getKeys()) {
            String namespace = woodTypeKey.m_135815_().equals("cedar") ? "totemic" : "minecraft";
            BlockModelBuilder poleModel = (BlockModelBuilder)this.models().getBuilder(woodTypeKey.toString() + "_totem_pole");
            BlockModelBuilder baseModel = (BlockModelBuilder)this.models().withExistingParent(woodTypeKey.toString() + "_totem_base", this.modLoc("totem_base"));
            this.setTotemTextures(poleModel, namespace, woodTypeKey.m_135815_());
            this.setTotemTextures(baseModel, namespace, woodTypeKey.m_135815_());
        }
    }

    private BlockModelBuilder setTotemTextures(BlockModelBuilder model, String namespace, String woodType) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)model.texture("wood", new ResourceLocation(namespace, "block/stripped_" + woodType + "_log"))).texture("bark", new ResourceLocation(namespace, "block/" + woodType + "_log"))).texture("top", new ResourceLocation(namespace, "block/stripped_" + woodType + "_log_top"))).texture("particle", new ResourceLocation(namespace, "block/stripped_" + woodType + "_log"));
    }

    private void horizontalBlockIgnoringProperties(Block block, ModelFile model, Property<?> ... ignored) {
        this.horizontalBlockIgnoringProperties(block, model, 180, ignored);
    }

    private void horizontalBlockIgnoringProperties(Block block, ModelFile model, int angleOffset, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(model).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + angleOffset) % 360).build(), ignored);
    }

    private void hangingSignBlock(RegistryObject<? extends CeilingHangingSignBlock> ceilingSign, RegistryObject<? extends WallHangingSignBlock> wallSign, ResourceLocation texture) {
        BlockModelBuilder hangingSignModel = (BlockModelBuilder)this.models().sign(ceilingSign.getId().m_135815_(), texture);
        this.simpleBlock((Block)ceilingSign.get(), (ModelFile)hangingSignModel);
        this.simpleBlock((Block)wallSign.get(), (ModelFile)hangingSignModel);
    }

    private void existingBlockItem(RegistryObject<? extends Block> block) {
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(block.getId()));
    }

    private void basicItemWithParent(RegistryObject<? extends Item> item, ResourceLocation parent) {
        ResourceLocation id = item.getId();
        ((ItemModelBuilder)this.itemModels().withExistingParent(id.toString(), parent)).texture("layer0", new ResourceLocation(id.m_135827_(), "item/" + id.m_135815_()));
    }

    private BlockModelBuilder blockEntityRenderer(RegistryObject<? extends Block> block, ResourceLocation particleTexture) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(block.getId().toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).texture("particle", particleTexture)).guiLight(BlockModel.GuiLight.SIDE)).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 225.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.625f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f).end().transform(ItemDisplayContext.FIXED).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.5f).end().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 45.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 225.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.4f).end().end();
    }
}

