/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.client.CeremonyHUD;
import pokefenn.totemic.client.model.totem.TotemBaseModel;
import pokefenn.totemic.client.model.totem.TotemPoleModel;
import pokefenn.totemic.init.ModBlocks;

public class ClientInitHandlers {
    private static final ResourceLocation OPAQUE_CEDAR_LEAVES = Totemic.resloc("block/cedar_leaves_opaque");

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, tintGetter, pos, tintIndex) -> tintIndex, new Block[]{(Block)ModBlocks.totem_pole.get()});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex, new ItemLike[]{(ItemLike)ModBlocks.totem_pole.get()});
    }

    @SubscribeEvent
    public static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("totem_pole", (IGeometryLoader)TotemPoleModel.Loader.INSTANCE);
        event.register("totem_base", (IGeometryLoader)TotemBaseModel.Loader.INSTANCE);
    }

    @SubscribeEvent
    public static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        if (!Minecraft.m_91405_()) {
            event.register(OPAQUE_CEDAR_LEAVES);
        }
    }

    @SubscribeEvent
    public static void onBakingComplete(ModelEvent.ModifyBakingResult event) {
        BakedModel opaqueLeaves;
        if (!Minecraft.m_91405_() && (opaqueLeaves = (BakedModel)event.getModels().get(OPAQUE_CEDAR_LEAVES)) != null) {
            for (BlockState state : ((LeavesBlock)ModBlocks.cedar_leaves.get()).m_49965_().m_61056_()) {
                event.getModels().put(BlockModelShaper.m_110895_((BlockState)state), opaqueLeaves);
            }
        }
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "ceremony_hud", (IGuiOverlay)CeremonyHUD.INSTANCE);
    }
}

