/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.item;

import it.unimi.dsi.fastutil.ints.IntBooleanPair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.TotemicEventHooks;
import pokefenn.totemic.api.TotemicAPI;
import pokefenn.totemic.api.totem.MedicineBagEffect;
import pokefenn.totemic.api.totem.PortableTotemCarving;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.block.totem.entity.StateTotemEffect;
import pokefenn.totemic.block.totem.entity.TotemPoleBlockEntity;
import pokefenn.totemic.init.ModBlockEntities;
import pokefenn.totemic.init.ModContent;
import pokefenn.totemic.init.ModItems;
import pokefenn.totemic.util.BlockUtil;
import pokefenn.totemic.util.MiscUtil;

public class MedicineBagItem
extends Item {
    public static final String TOTEM_TAG = "Totem";
    public static final String CHARGE_TAG = "Charge";
    public static final String OPEN_TAG = "Open";
    private static final Map<ItemStack, Optional<PortableTotemCarving>> carvingCache = Collections.synchronizedMap(new WeakHashMap(8));

    public MedicineBagItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void registerItemProperties() {
        ItemPropertyFunction func = (stack, level, entity, seed) -> MedicineBagItem.isOpen(stack) ? 1.0f : 0.0f;
        ResourceLocation name = Totemic.resloc("open");
        ItemProperties.register((Item)((Item)ModItems.medicine_bag.get()), (ResourceLocation)name, (ItemPropertyFunction)func);
        ItemProperties.register((Item)((Item)ModItems.creative_medicine_bag.get()), (ResourceLocation)name, (ItemPropertyFunction)func);
    }

    public static Optional<PortableTotemCarving> getCarving(ItemStack stack) {
        return carvingCache.computeIfAbsent(stack, st -> MiscUtil.filterAndCast(Optional.ofNullable(st.m_41783_()).filter(tag -> tag.m_128425_(TOTEM_TAG, 8)).map(tag -> (TotemCarving)TotemicAPI.get().registry().totemCarvings().getValue(ResourceLocation.m_135820_((String)tag.m_128461_(TOTEM_TAG)))).filter(carving -> carving != ModContent.none.get()), PortableTotemCarving.class));
    }

    public static List<MedicineBagEffect> getEffects(ItemStack stack) {
        return MedicineBagItem.getCarving(stack).map(PortableTotemCarving::getMedicineBagEffects).orElse(List.of());
    }

    public static int getCharge(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_().m_128451_(CHARGE_TAG) : 0;
    }

    public static boolean isOpen(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_().m_128471_(OPEN_TAG) : false;
    }

    public static int getMaxCharge(ItemStack stack) {
        int unbreaking = stack.getEnchantmentLevel(Enchantments.f_44986_);
        return (4 + 2 * unbreaking) * 60 * 20;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        int charge;
        level.m_46473_().m_6180_("totemic.medicineBag");
        if (!level.f_46443_ && level.m_46467_() % 20L == 0L) {
            this.tryCharge(stack, level, entity.m_20183_());
        }
        if (MedicineBagItem.isOpen(stack) && (charge = MedicineBagItem.getCharge(stack)) > 0) {
            MedicineBagItem.getEffects(stack).forEach(effect -> {
                int interval = effect.getInterval();
                if (level.m_46467_() % (long)interval == 0L) {
                    PortableTotemCarving carving = MedicineBagItem.getCarving(stack).get();
                    Player player = (Player)entity;
                    IntBooleanPair eventResult = TotemicEventHooks.get().fireMedicineBagEffectEvent((MedicineBagEffect)effect, carving, player, stack, charge, interval);
                    int chargeToDeduct = eventResult.firstInt();
                    if (eventResult.secondBoolean()) {
                        effect.medicineBagEffect(player, stack, charge);
                    }
                    if (!level.f_46443_) {
                        stack.m_41783_().m_128405_(CHARGE_TAG, Math.max(charge - chargeToDeduct, 0));
                    }
                }
            });
        }
        level.m_46473_().m_7238_();
    }

    private void tryCharge(ItemStack stack, Level level, BlockPos pos) {
        int maxCharge;
        int charge = MedicineBagItem.getCharge(stack);
        if (charge < (maxCharge = MedicineBagItem.getMaxCharge(stack))) {
            MedicineBagItem.getCarving(stack).ifPresent(carving -> {
                if (BlockUtil.getBlockEntitiesInRange((BlockEntityType)ModBlockEntities.totem_base.get(), level, pos, 6).anyMatch(tile -> tile.getTotemState() instanceof StateTotemEffect && tile.hasCarving((TotemCarving)carving))) {
                    stack.m_41783_().m_128405_(CHARGE_TAG, Math.min(charge + maxCharge / 12, maxCharge));
                }
            });
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        return this.toggleOpen(pPlayer.m_21120_(pUsedHand));
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        ItemStack stack = ctx.m_43722_();
        if (!ctx.m_7078_()) {
            InteractionResultHolder<ItemStack> result = this.toggleOpen(stack);
            return result.m_19089_();
        }
        return this.trySetCarving(stack, ctx.m_43723_(), ctx.m_43725_(), ctx.m_8083_(), ctx.m_43724_());
    }

    private InteractionResultHolder<ItemStack> toggleOpen(ItemStack stack) {
        if (MedicineBagItem.getCarving(stack).isPresent()) {
            CompoundTag tag;
            tag.m_128379_(OPEN_TAG, !(tag = stack.m_41783_()).m_128471_(OPEN_TAG));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    private InteractionResult trySetCarving(ItemStack stack, Player player, Level level, BlockPos pos, InteractionHand hand) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TotemPoleBlockEntity) {
            TotemPoleBlockEntity pole = (TotemPoleBlockEntity)blockEntity;
            TotemCarving carving = pole.getCarving();
            if (carving instanceof PortableTotemCarving) {
                ItemStack newStack = stack.m_41777_();
                carvingCache.remove(stack);
                CompoundTag tag = newStack.m_41784_();
                tag.m_128359_(TOTEM_TAG, carving.getRegistryName().toString());
                if (!newStack.m_150930_((Item)ModItems.creative_medicine_bag.get())) {
                    tag.m_128405_(CHARGE_TAG, 0);
                }
                player.m_21008_(hand, newStack);
                return InteractionResult.SUCCESS;
            }
            if (level.f_46443_) {
                player.m_5661_((Component)Component.m_237110_((String)"totemic.medicineBag.notPortable", (Object[])new Object[]{carving.getDisplayName()}), true);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public boolean m_8120_(ItemStack pStack) {
        return true;
    }

    public int m_6473_() {
        return 8;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44984_ || enchantment == Enchantments.f_44986_ || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public Component m_7626_(ItemStack stack) {
        return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{MedicineBagItem.getCarving(stack).orElseGet((Supplier<PortableTotemCarving>)ModContent.none).getDisplayName()});
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        String key = MedicineBagItem.getCarving(stack).isPresent() ? (MedicineBagItem.getCharge(stack) > 0 ? (MedicineBagItem.isOpen(stack) ? "open" : "closed") : "empty") : "tooltip";
        tooltip.add((Component)Component.m_237115_((String)("totemic.medicineBag." + key)));
        if (flag.m_7050_()) {
            tooltip.add((Component)Component.m_237110_((String)"totemic.medicineBag.charge", (Object[])new Object[]{MedicineBagItem.getCharge(stack), MedicineBagItem.getMaxCharge(stack)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean m_142522_(ItemStack pStack) {
        return true;
    }

    public int m_142158_(ItemStack pStack) {
        return Math.round(13.0f * (float)MedicineBagItem.getCharge(pStack) / (float)MedicineBagItem.getMaxCharge(pStack));
    }

    public int m_142159_(ItemStack pStack) {
        float f = (float)MedicineBagItem.getCharge(pStack) / (float)MedicineBagItem.getMaxCharge(pStack);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }
}

