/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.util;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import pokefenn.totemic.api.TotemicEntityUtil;

public final class BlockUtil {
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    public static <T extends BlockEntity> Stream<T> getBlockEntitiesInRange(@Nullable BlockEntityType<T> type, Level level, BlockPos pos, int range) {
        return BlockUtil.getBlockEntitiesIn(type, level, TotemicEntityUtil.getBoundingBoxAround(pos, range));
    }

    public static <T extends BlockEntity> Stream<T> getBlockEntitiesIn(@Nullable BlockEntityType<T> type, Level level, BoundingBox box) {
        level.m_46473_().m_6174_("totemic.getBlockEntitiesIn");
        return ChunkPos.m_45599_((ChunkPos)new ChunkPos(BlockUtil.lowerCorner(box)), (ChunkPos)new ChunkPos(BlockUtil.upperCorner(box))).filter(chunkPos -> level.m_7232_(chunkPos.f_45578_, chunkPos.f_45579_)).map(chunkPos -> level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_)).flatMap(chunk -> chunk.m_62954_().values().stream()).filter(tile -> (type == null || tile.m_58903_() == type) && !tile.m_58901_() && box.m_71051_((Vec3i)tile.m_58899_()));
    }

    public static BlockPos lowerCorner(BoundingBox box) {
        return new BlockPos(box.m_162395_(), box.m_162396_(), box.m_162398_());
    }

    public static BlockPos upperCorner(BoundingBox box) {
        return new BlockPos(box.m_162399_(), box.m_162400_(), box.m_162401_());
    }

    public static boolean placedInWater(BlockPlaceContext context) {
        return context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
    }

    public static void scheduleWaterloggedTick(BlockState state, BlockPos currentPos, LevelAccessor level) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
    }
}

