/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.untitledduckmod.common.config.UntitledConfig;
import net.untitledduckmod.common.entity.WaterfowlEntity;
import net.untitledduckmod.common.entity.ai.goal.common.EatGoal;
import net.untitledduckmod.common.entity.ai.goal.common.SwimGoal;
import net.untitledduckmod.common.entity.ai.goal.common.WFollowParentGoal;
import net.untitledduckmod.common.init.ModEntityTypes;
import net.untitledduckmod.common.init.ModItems;
import net.untitledduckmod.common.init.ModSoundEvents;
import net.untitledduckmod.common.init.ModTags;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GooseEntity
extends WaterfowlEntity
implements NeutralMob,
AnimationController.ParticleKeyframeHandler<GooseEntity> {
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.defineId(GooseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt ANGER_TIME_RANGE = UniformInt.of((int)20, (int)39);
    private UUID targetUuid;
    public static final byte ANIMATION_BITE = 2;
    public static final int ANIMATION_BITE_LEN = 22;
    public static final byte ANIMATION_INTIMIDATE = 6;
    private static final RawAnimation INTIMIDATE_ANIM = RawAnimation.begin().thenPlay("intimidate");
    private static final RawAnimation HONK_ANIM = RawAnimation.begin().thenPlay("honk");
    private static final RawAnimation BITE_ANIM = RawAnimation.begin().thenPlay("bite");
    private static final RawAnimation CHARGE_ANIM = RawAnimation.begin().thenPlay("charge");
    public static final Ingredient FOOD = Ingredient.of(ModTags.ItemTags.GOOSE_FOOD);
    private static final Ingredient BREEDING_INGREDIENT = Ingredient.of(ModTags.ItemTags.GOOSE_BREEDING_FOOD);
    private static final Ingredient TAMING_INGREDIENT = Ingredient.of(ModTags.ItemTags.GOOSE_TAMING_FOOD);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean wasSongPlaying = false;
    private int animationTimer = 0;

    public GooseEntity(EntityType<? extends WaterfowlEntity> entityType, Level world) {
        super(entityType, world);
        this.setCanPickUpLoot(true);
    }

    public static boolean checkGooseSpawnRules(EntityType<GooseEntity> goose, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        boolean isValidSurface;
        BlockState downState = world.getBlockState(pos.below());
        boolean bl = isValidSurface = downState.is(ModTags.BlockTags.GEESE_SPAWNABLE_ON) || downState.getFluidState().is(FluidTags.WATER) || downState.is(Blocks.ICE) || downState.is(Blocks.FROSTED_ICE);
        boolean hasEnoughSpace = downState.is(Blocks.ICE) || downState.is(Blocks.FROSTED_ICE) ? world.getBlockState(pos).isAir() && world.getBlockState(pos.above()).isAir() : world.getBlockState(pos).isAir();
        return isValidSurface && hasEnoughSpace;
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 7.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    @Override
    public void setTame(boolean tamed, boolean updateAttributes) {
        super.setTame(tamed, updateAttributes);
        Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(2.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANGER_TIME, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.addPersistentAngerSaveData(tag);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readPersistentAngerSaveData(this.level(), tag);
    }

    public void setRecordPlayingNearby(BlockPos songPosition, boolean playing) {
        if (playing && !this.wasSongPlaying) {
            this.setAnimation((byte)3);
            this.wasSongPlaying = true;
        } else if (!playing && this.wasSongPlaying) {
            this.setAnimation((byte)0);
            this.wasSongPlaying = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte status) {
        if (status == 100) {
            SimpleParticleType particleEffect = ParticleTypes.HAPPY_VILLAGER;
            for (int i = 0; i < 7; ++i) {
                double d = this.random.nextGaussian() * 0.02;
                double e = this.random.nextGaussian() * 0.02;
                double f = this.random.nextGaussian() * 0.02;
                this.level().addParticle((ParticleOptions)particleEffect, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), d, e, f);
            }
        }
        super.handleEntityEvent(status);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SwimGoal(this));
        this.goalSelector.addGoal(1, (Goal)new GooseEscapeDangerGoal(this, 1.7));
        this.goalSelector.addGoal(2, (Goal)new IntimidateMobsGoal(this));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new EatGoal(this));
        this.goalSelector.addGoal(4, (Goal)new StealItemGoal(this));
        this.goalSelector.addGoal(5, (Goal)new PickupFoodGoal(this));
        this.goalSelector.addGoal(6, (Goal)new GooseMeleeAttackGoal(this, 1.5, true));
        this.goalSelector.addGoal(7, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)BREEDING_INGREDIENT, false));
        this.goalSelector.addGoal(8, (Goal)new WFollowParentGoal(this, 1.1));
        this.goalSelector.addGoal(9, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.6, 10.0f, 2.0f));
        this.goalSelector.addGoal(9, (Goal)new CleanGoal(this));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new GooseRevengeGoal(this).setAlertOthers(new Class[0]));
    }

    public boolean isFood(ItemStack stack) {
        if (this.isAngry()) {
            return false;
        }
        if (this.isTame()) {
            return TAMING_INGREDIENT.test(stack) || BREEDING_INGREDIENT.test(stack);
        }
        return BREEDING_INGREDIENT.test(stack);
    }

    public void onEquipItem(EquipmentSlot slot, ItemStack oldStack, ItemStack newStack) {
        ItemEntity ie;
        UUID thrower;
        if (this.level().isClientSide) {
            return;
        }
        Entity holder = newStack.getEntityRepresentation();
        if (holder != null && this.isAngry() && holder instanceof ItemEntity && (thrower = this.getThrower(ie = (ItemEntity)holder)) != null) {
            this.stopBeingAngry();
        }
        super.onEquipItem(slot, oldStack, newStack);
    }

    private UUID getThrower(ItemEntity ie) {
        CompoundTag nbt = new CompoundTag();
        ie.addAdditionalSaveData(nbt);
        if (nbt.hasUUID("Thrower")) {
            return nbt.getUUID("Thrower");
        }
        return null;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide && this.animationTimer > 0) {
            --this.animationTimer;
            if (this.animationTimer == 0) {
                this.setAnimation((byte)0);
            }
        }
    }

    @Override
    protected void handlePanicAnimation() {
        if (!this.panicked && (this.getHealth() < this.getMaxHealth() / 2.0f || this.isBaby()) && (this.getLastHurtByMob() != null || this.isOnFire())) {
            this.setAnimation((byte)4);
            this.panicked = true;
        } else if (this.panicked && this.getLastHurtByMob() == null && !this.isOnFire()) {
            this.setAnimation((byte)0);
            this.panicked = false;
        }
    }

    @Override
    protected boolean tryTaming(Player player, ItemStack stack) {
        if (this.isAngry()) {
            if (FOOD.test(stack)) {
                ItemStack newStack = stack.copy();
                newStack.setCount(1);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                if (!this.equipItemIfPossible(newStack).isEmpty()) {
                    this.stopBeingAngry();
                }
            }
            return false;
        }
        return super.tryTaming(player, stack);
    }

    @Override
    protected boolean isTamableItem(ItemStack stack) {
        return TAMING_INGREDIENT.test(stack);
    }

    @Override
    protected boolean isTamable(Player player, ItemStack stack) {
        return super.isTamable(player, stack) && !this.isAngry();
    }

    public boolean isAngry() {
        return this.getTarget() != null;
    }

    public void stopBeingAngry() {
        this.setLastHurtByMob(null);
        this.setPersistentAngerTarget(null);
        this.setTarget(null);
        this.setRemainingPersistentAngerTime(0);
        this.level().broadcastEntityEvent((Entity)this, (byte)100);
    }

    public ItemStack equipItemIfPossible(ItemStack equipment) {
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        ItemStack itemStack = this.getMainHandItem();
        if (FOOD.test(equipment) || this.canHoldItem(equipment)) {
            ItemEntity itemEntity;
            if (!itemStack.isEmpty() && (itemEntity = this.spawnAtLocation(itemStack)) != null) {
                itemEntity.setPickUpDelay(40);
            }
            this.setItemSlotAndDropWhenKilled(equipmentSlot, equipment);
            return equipment;
        }
        return ItemStack.EMPTY;
    }

    private boolean isWeapon(ItemStack stack) {
        return stack.is(ItemTags.SWORDS) || stack.is(ItemTags.AXES);
    }

    protected void pickUpItem(ItemEntity item) {
        if (this.getThrower(item) == this.getUUID()) {
            return;
        }
        if (this.isTame()) {
            Player player;
            Entity entity = item.getOwner();
            if (entity instanceof Player && this.isOwnedBy((LivingEntity)(player = (Player)entity))) {
                super.pickUpItem(item);
            }
            return;
        }
        super.pickUpItem(item);
    }

    public boolean canHoldItem(ItemStack stack) {
        ItemStack mainHandStack = this.getMainHandItem();
        if (this.isWeapon(stack)) {
            return this.isTame() && this.getOwner() != null && this.getHealth() == this.getMaxHealth();
        }
        if (!FOOD.test(mainHandStack) && FOOD.test(stack)) {
            return true;
        }
        if (mainHandStack.isEmpty()) {
            return !stack.is(ModItems.GOOSE_EGG.get());
        }
        return false;
    }

    public boolean canPickUpLoot() {
        if (this.isBaby()) {
            return false;
        }
        return super.canPickUpLoot();
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        GooseEntity gooseEntity = (GooseEntity)ModEntityTypes.getGoose().create((Level)world);
        if (gooseEntity != null && entity instanceof GooseEntity) {
            GooseEntity goose = (GooseEntity)entity;
            if (this.random.nextBoolean()) {
                gooseEntity.setVariant(this.getVariant());
            } else {
                gooseEntity.setVariant(goose.getVariant());
            }
            if (this.isTame()) {
                gooseEntity.setOwnerUUID(this.getOwnerUUID());
                gooseEntity.setTame(true, true);
            }
        }
        return gooseEntity;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate);
        controller.setParticleKeyframeHandler((AnimationController.ParticleKeyframeHandler)this);
        controllerRegistrar.add(controller);
    }

    @Override
    protected SoundEvent getLayEggSound() {
        return ModSoundEvents.GOOSE_LAY_EGG.get();
    }

    @Override
    public Item getEggItem() {
        return ModItems.GOOSE_EGG.get();
    }

    private <P extends GeoAnimatable> PlayState predicate(AnimationState<P> event) {
        float limbSwingAmount = event.getLimbSwingAmount();
        boolean isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
        boolean inWater = this.isInWater();
        AnimationController controller = event.getController();
        if (this.isFlapping) {
            controller.setAnimation(FLY_ANIM);
            return PlayState.CONTINUE;
        }
        if (this.isInSittingPose()) {
            controller.setAnimation(SIT_ANIM);
            return PlayState.CONTINUE;
        }
        byte currentAnimation = this.getAnimation();
        switch (currentAnimation) {
            case 2: {
                controller.setAnimation(BITE_ANIM);
                this.animationTimer = 22;
                break;
            }
            case 6: {
                controller.setAnimation(INTIMIDATE_ANIM);
                break;
            }
            case 5: {
                controller.setAnimation(EAT_ANIM);
                break;
            }
            case 1: {
                controller.setAnimation(inWater ? SWIM_ANIM : CLEAN_ANIM);
                break;
            }
            case 3: {
                controller.setAnimation(HONK_ANIM);
                break;
            }
            case 4: {
                controller.setAnimation(PANIC_ANIM);
                break;
            }
            default: {
                if (inWater) {
                    controller.setAnimation(isMoving ? SWIM_ANIM : SWIM_IDLE_ANIM);
                    break;
                }
                if (this.isAggressive()) {
                    controller.setAnimation(CHARGE_ANIM);
                    return PlayState.CONTINUE;
                }
                controller.setAnimation(isMoving ? WALK_ANIM : IDLE_ANIM);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void playAmbientSound() {
        if (this.isBaby()) {
            this.playSound(ModSoundEvents.GOSLING_AMBIENT.get(), 0.3f, this.getVoicePitch());
            return;
        }
        if (this.isAngry()) {
            this.playSound(ModSoundEvents.GOOSE_HONK.get(), 0.6f, this.getVoicePitch());
        }
    }

    @Nullable
    public ItemEntity spawnAtLocation(ItemStack stack, float yOffset) {
        ItemEntity droppedStack = super.spawnAtLocation(stack, yOffset);
        if (droppedStack == null) {
            return null;
        }
        droppedStack.setThrower((Entity)this);
        return droppedStack;
    }

    protected void playHurtSound(DamageSource source) {
        if (this.isBaby()) {
            this.playSound(ModSoundEvents.GOSLING_HURT.get(), 0.3f, this.getVoicePitch() + 0.25f);
            return;
        }
        this.playSound(ModSoundEvents.GOOSE_HONK.get(), 0.7f, this.getVoicePitch());
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        if (this.isBaby()) {
            return ModSoundEvents.GOSLING_DEATH.get();
        }
        return ModSoundEvents.GOOSE_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(ModSoundEvents.DUCK_STEP.get(), 0.15f, 1.0f);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int ticks) {
        this.entityData.set(ANGER_TIME, (Object)ticks);
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.targetUuid;
    }

    public void setPersistentAngerTarget(@Nullable UUID uuid) {
        this.targetUuid = uuid;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    public void handle(ParticleKeyframeEvent particleKeyframeEvent) {
        ItemStack stack = this.getMainHandItem();
        if (stack == ItemStack.EMPTY) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            Vec3 vel = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vel = vel.xRot(-this.getXRot() * ((float)Math.PI / 180));
            vel = vel.yRot(-this.getYRot() * ((float)Math.PI / 180));
            Vec3 rotationVec = Vec3.directionFromRotation((float)0.0f, (float)this.yBodyRot);
            Vec3 pos = new Vec3(this.getX() + rotationVec.x / 2.0, this.getEyeY() - 0.2, this.getZ() + rotationVec.z / 2.0);
            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), pos.x, pos.y, pos.z, vel.x, vel.y + 0.05, vel.z);
        }
    }

    public boolean wantsToPickupItem() {
        return !this.isOrderedToSit() && this.getLastHurtByMob() == null && this.getTarget() == null;
    }

    @Override
    public boolean isHungry() {
        return this.isAngry() || super.isHungry();
    }

    public float getAgeScale() {
        if (UntitledConfig.gooseBabyRandomSize()) {
            float babyScale = this.getBabyScale();
            float modelScale = this.isBaby() ? babyScale : 0.8f + babyScale * 0.5f;
            return modelScale;
        }
        return super.getAgeScale();
    }

    static class GooseEscapeDangerGoal
    extends PanicGoal {
        private final GooseEntity goose;

        public GooseEscapeDangerGoal(GooseEntity goose, double speed) {
            super((PathfinderMob)goose, speed);
            this.goose = goose;
        }

        public boolean canUse() {
            return (this.goose.getHealth() < this.goose.getMaxHealth() / 2.0f || this.goose.isBaby()) && super.canUse();
        }
    }

    static class IntimidateMobsGoal
    extends Goal {
        private static final int STARTING_DELAY = 10;
        private static final int ANIMATION_LENGTH = 25;
        private static final double INTIMIDATE_DISTANCE = 12.0;
        private final GooseEntity goose;
        private int animationTime;
        private int delayTime;
        private int cooldown;
        protected Entity targetEntity;
        private Vec3 originalLocation;

        public IntimidateMobsGoal(GooseEntity goose) {
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.goose = goose;
        }

        public boolean canUse() {
            if (this.cooldown-- > 0) {
                return false;
            }
            if (this.goose.tickCount % 5 == 0) {
                this.targetEntity = this.goose.level().getNearestEntity(AbstractIllager.class, TargetingConditions.forCombat(), (LivingEntity)this.goose, this.goose.getX(), this.goose.getY(), this.goose.getZ(), this.goose.getBoundingBox().inflate(12.0, 3.0, 12.0));
                return this.targetEntity != null;
            }
            return false;
        }

        public void start() {
            this.goose.getNavigation().stop();
            this.animationTime = 25;
            this.delayTime = 10;
            this.originalLocation = this.goose.position();
            this.goose.getNavigation().moveTo(this.targetEntity, 1.2);
        }

        public void stop() {
            this.goose.setAnimation((byte)0);
            this.goose.getNavigation().moveTo(this.originalLocation.x, this.originalLocation.y, this.originalLocation.z, 1.2);
            this.cooldown = 20;
            this.targetEntity = null;
        }

        public boolean canContinueToUse() {
            return this.targetEntity.isAlive() && this.goose.distanceToSqr(this.originalLocation) <= 144.0 && this.animationTime >= 0;
        }

        public void tick() {
            this.goose.getLookControl().setLookAt(this.targetEntity.getX(), this.targetEntity.getEyeY(), this.targetEntity.getZ());
            if (this.delayTime > 0) {
                --this.delayTime;
                if (this.delayTime == 0) {
                    this.goose.getNavigation().stop();
                    this.goose.setAnimation((byte)6);
                    this.goose.playSound(ModSoundEvents.GOOSE_HONK.get(), 1.0f, 1.0f);
                }
                return;
            }
            --this.animationTime;
        }
    }

    static class StealItemGoal
    extends Goal {
        private static final double SPEED = 1.3;
        private final GooseEntity goose;
        Player targetPlayer;
        int nextStealTime;
        private ItemStack playerHandStack;

        public StealItemGoal(GooseEntity goose) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.goose = goose;
            this.nextStealTime = goose.tickCount + goose.getRandom().nextInt(1200) + 1200;
        }

        public boolean canUse() {
            if (this.goose.isBaby() || this.goose.isTame() || !this.goose.getMainHandItem().isEmpty()) {
                return false;
            }
            if (this.goose.tickCount <= this.nextStealTime) {
                return false;
            }
            if (this.goose.getRandom().nextInt(10) != 0) {
                return false;
            }
            this.targetPlayer = this.goose.level().getNearestPlayer(this.goose.getX(), this.goose.getY(), this.goose.getZ(), 10.0, true);
            if (this.targetPlayer == null) {
                this.nextStealTime = this.goose.tickCount + this.goose.getRandom().nextInt(200) + 200;
                return false;
            }
            this.playerHandStack = this.targetPlayer.getMainHandItem();
            return FOOD.test(this.playerHandStack);
        }

        public boolean canContinueToUse() {
            if (this.targetPlayer == null) {
                return false;
            }
            this.playerHandStack = this.targetPlayer.getMainHandItem();
            return FOOD.test(this.playerHandStack);
        }

        public void start() {
            this.goose.getNavigation().moveTo((Entity)this.targetPlayer, 1.3);
        }

        public void stop() {
            this.nextStealTime = this.goose.tickCount + this.goose.getRandom().nextInt(1200) + 1200;
            this.targetPlayer = null;
        }

        public void tick() {
            if (this.goose.distanceTo((Entity)this.targetPlayer) <= 2.0f) {
                ItemStack stolenItemStack = this.playerHandStack.copy();
                stolenItemStack.setCount(1);
                if (!this.goose.equipItemIfPossible(stolenItemStack).isEmpty()) {
                    this.playerHandStack.shrink(1);
                }
                this.goose.setItemInHand(InteractionHand.MAIN_HAND, stolenItemStack);
                this.stop();
            } else {
                this.goose.getNavigation().moveTo((Entity)this.targetPlayer, 1.3);
            }
        }
    }

    static class PickupFoodGoal
    extends Goal {
        public static final double SPEED = 1.3;
        private final GooseEntity goose;
        private static final Predicate<ItemEntity> PICKABLE_DROP_FILTER = itemEntity -> !itemEntity.hasPickUpDelay() && itemEntity.isAlive() && FOOD.test(itemEntity.getItem());

        public PickupFoodGoal(GooseEntity goose) {
            this.goose = goose;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.goose.isBaby() || !this.goose.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                return false;
            }
            if (!this.goose.wantsToPickupItem()) {
                return false;
            }
            if (this.goose.getRandom().nextInt(10) != 0) {
                return false;
            }
            List list = this.goose.level().getEntitiesOfClass(ItemEntity.class, this.goose.getBoundingBox().inflate(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            return !list.isEmpty() && this.goose.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty();
        }

        public void tick() {
            ItemStack itemStack = this.goose.getItemBySlot(EquipmentSlot.MAINHAND);
            if (itemStack.isEmpty()) {
                this.start();
            }
        }

        public void start() {
            List list = this.goose.level().getEntitiesOfClass(ItemEntity.class, this.goose.getBoundingBox().inflate(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            if (!list.isEmpty()) {
                this.goose.getNavigation().moveTo((Entity)list.getFirst(), 1.3);
            }
        }
    }

    static class GooseMeleeAttackGoal
    extends MeleeAttackGoal {
        private final GooseEntity goose;
        private static final int ANIMATION_LEN = 22;
        private static final int ANIMATION_ATTACK = 5;
        private int animationTimer = 0;

        public GooseMeleeAttackGoal(GooseEntity gooseEntity, double speed, boolean pauseWhenIdle) {
            super((PathfinderMob)gooseEntity, speed, pauseWhenIdle);
            this.goose = gooseEntity;
        }

        public boolean canUse() {
            return !this.goose.isBaby() && !this.goose.isInWater() && super.canUse();
        }

        protected void checkAndPerformAttack(LivingEntity target) {
            if (this.canPerformAttack(target) && this.animationTimer <= 0) {
                this.goose.setAnimation((byte)2);
                this.animationTimer = 22;
                this.goose.playSound(ModSoundEvents.GOOSE_HONK.get(), 0.8f, 1.2f);
            }
            if (this.animationTimer > 0) {
                --this.animationTimer;
                if (this.animationTimer == 5) {
                    this.mob.doHurtTarget((Entity)target);
                }
                if (this.animationTimer == 0) {
                    this.goose.setAnimation((byte)0);
                }
            }
        }

        public void stop() {
            super.stop();
            this.goose.setAnimation((byte)0);
            this.animationTimer = 0;
        }
    }

    static class CleanGoal
    extends Goal {
        private static final int ANIMATION_LENGTH = 32;
        private final GooseEntity goose;
        private int cleanTime;
        private int nextCleanTime;

        public CleanGoal(GooseEntity goose) {
            this.goose = goose;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.nextCleanTime = goose.tickCount + (200 + goose.getRandom().nextInt(10) * 20);
        }

        public boolean canUse() {
            if (this.nextCleanTime > this.goose.tickCount || this.goose.getNoActionTime() >= 100 || this.goose.getAnimation() != 0) {
                return false;
            }
            return this.goose.getRandom().nextInt(40) == 0;
        }

        public void start() {
            this.cleanTime = 32;
            this.goose.setAnimation((byte)1);
            this.nextCleanTime = this.goose.tickCount + (200 + this.goose.getRandom().nextInt(10) * 20);
        }

        public void stop() {
            this.goose.setAnimation((byte)0);
        }

        public boolean canContinueToUse() {
            return this.cleanTime >= 0;
        }

        public void tick() {
            --this.cleanTime;
        }
    }

    static class GooseRevengeGoal
    extends HurtByTargetGoal {
        private final GooseEntity goose;

        public GooseRevengeGoal(GooseEntity goose) {
            super((PathfinderMob)goose, new Class[0]);
            this.goose = goose;
        }

        public boolean canContinueToUse() {
            return this.goose.getTarget() != null && super.canContinueToUse();
        }
    }
}

