/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.common.helper;

import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;

public class NbtUuidHelper {
    public static boolean containsUuid(CompoundTag tag, String key) {
        Tag nbtElement = tag.get(key);
        return nbtElement != null && nbtElement.getType() == IntArrayTag.TYPE && ((IntArrayTag)nbtElement).getAsIntArray().length == 4;
    }

    private static UUID toUuid(Tag element) {
        if (element == null) {
            throw new NullPointerException("NbtElement is null");
        }
        if (element.getType() != IntArrayTag.TYPE) {
            String var10002 = IntArrayTag.TYPE.getName();
            throw new IllegalArgumentException("Expected UUID-Tag to be of type " + var10002 + ", but found " + element.getType().getName() + ".");
        }
        int[] is = ((IntArrayTag)element).getAsIntArray();
        if (is.length != 4) {
            throw new IllegalArgumentException("Expected UUID-Array to be of length 4, but found " + is.length + ".");
        }
        return UUIDUtil.uuidFromIntArray((int[])is);
    }

    public static UUID getUuid(CompoundTag tag, String key) {
        return NbtUuidHelper.toUuid(tag.get(key));
    }
}

