/*
 * Decompiled with CFR 0.152.
 */
package net.dfnkt.wayfindr;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import net.dfnkt.wayfindr.ServerWaypointSaveHandler;
import net.dfnkt.wayfindr.WayfindrNetworkServer;
import net.dfnkt.wayfindr.WaypointManager;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\n\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u0015\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001e\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R \u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\f0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0018\u0010&\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lnet/dfnkt/wayfindr/ServerWaypointManager;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "minecraftServer", "", "initialize", "(Lnet/minecraft/server/MinecraftServer;)V", "loadWaypoints", "saveWaypoints", "registerPlayerJoinHandler", "Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "waypoint", "addWaypoint", "(Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;)Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "", "updateWaypoint", "(Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;)Z", "Ljava/util/UUID;", "id", "removeWaypoint", "(Ljava/util/UUID;)Z", "", "getAllWaypoints", "()Ljava/util/List;", "getWaypoint", "(Ljava/util/UUID;)Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "Ljava/util/concurrent/ConcurrentHashMap;", "sharedWaypoints", "Ljava/util/concurrent/ConcurrentHashMap;", "server", "Lnet/minecraft/server/MinecraftServer;", "wayfindr"})
@SourceDebugExtension(value={"SMAP\nServerWaypointManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerWaypointManager.kt\nnet/dfnkt/wayfindr/ServerWaypointManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1863#2,2:164\n*S KotlinDebug\n*F\n+ 1 ServerWaypointManager.kt\nnet/dfnkt/wayfindr/ServerWaypointManager\n*L\n56#1:164,2\n*E\n"})
public final class ServerWaypointManager {
    @NotNull
    public static final ServerWaypointManager INSTANCE = new ServerWaypointManager();
    private static final Logger logger = LoggerFactory.getLogger((String)"wayfindr");
    @NotNull
    private static final Json json = JsonKt.Json$default(null, ServerWaypointManager::json$lambda$0, (int)1, null);
    @NotNull
    private static final ConcurrentHashMap<UUID, WaypointManager.Waypoint> sharedWaypoints = new ConcurrentHashMap();
    @Nullable
    private static MinecraftServer server;

    private ServerWaypointManager() {
    }

    public final void initialize(@NotNull MinecraftServer minecraftServer) {
        Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"minecraftServer");
        server = minecraftServer;
        ServerWaypointSaveHandler.INSTANCE.initialize(minecraftServer);
        WayfindrNetworkServer.INSTANCE.initialize(minecraftServer);
        this.loadWaypoints();
        this.registerPlayerJoinHandler();
        logger.info("Server waypoint manager initialized with " + sharedWaypoints.size() + " waypoints");
    }

    private final void loadWaypoints() {
        List<WaypointManager.Waypoint> loadedWaypoints = ServerWaypointSaveHandler.INSTANCE.loadWaypoints();
        sharedWaypoints.clear();
        Iterable $this$forEach$iv = loadedWaypoints;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WaypointManager.Waypoint waypoint = (WaypointManager.Waypoint)element$iv;
            boolean bl = false;
            ((Map)sharedWaypoints).put(waypoint.getId(), waypoint);
        }
        logger.info("Loaded " + loadedWaypoints.size() + " shared waypoints");
    }

    private final void saveWaypoints() {
        Collection<WaypointManager.Waypoint> collection = sharedWaypoints.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        boolean success = ServerWaypointSaveHandler.INSTANCE.saveWaypoints(collection);
        if (success) {
            logger.info("Saved " + sharedWaypoints.size() + " shared waypoints");
        } else {
            logger.error("Failed to save shared waypoints");
        }
    }

    private final void registerPlayerJoinHandler() {
        ServerPlayConnectionEvents.JOIN.register(ServerWaypointManager::registerPlayerJoinHandler$lambda$2);
    }

    @NotNull
    public final WaypointManager.Waypoint addWaypoint(@NotNull WaypointManager.Waypoint waypoint) {
        Intrinsics.checkNotNullParameter((Object)waypoint, (String)"waypoint");
        waypoint.setShared(true);
        ((Map)sharedWaypoints).put(waypoint.getId(), waypoint);
        this.saveWaypoints();
        logger.info("Added shared waypoint '" + waypoint.getName() + "' to server");
        return waypoint;
    }

    public final boolean updateWaypoint(@NotNull WaypointManager.Waypoint waypoint) {
        Intrinsics.checkNotNullParameter((Object)waypoint, (String)"waypoint");
        if (!sharedWaypoints.containsKey(waypoint.getId())) {
            return false;
        }
        ((Map)sharedWaypoints).put(waypoint.getId(), waypoint);
        this.saveWaypoints();
        logger.info("Updated shared waypoint '" + waypoint.getName() + "' on server");
        return true;
    }

    public final boolean removeWaypoint(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        WaypointManager.Waypoint waypoint = sharedWaypoints.remove(id);
        if (waypoint == null) {
            return false;
        }
        WaypointManager.Waypoint waypoint2 = waypoint;
        this.saveWaypoints();
        logger.info("Removed shared waypoint '" + waypoint2.getName() + "' from server");
        return true;
    }

    @NotNull
    public final List<WaypointManager.Waypoint> getAllWaypoints() {
        Collection<WaypointManager.Waypoint> collection = sharedWaypoints.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    @Nullable
    public final WaypointManager.Waypoint getWaypoint(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return sharedWaypoints.get(id);
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final void registerPlayerJoinHandler$lambda$2(class_3244 handler, PacketSender sender, MinecraftServer server) {
        class_3222 class_32222 = handler.field_14140;
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"player");
        WayfindrNetworkServer.INSTANCE.sendWaypointSync(class_32222);
        logger.info("Player " + handler.field_14140.method_5477().getString() + " joined, sending waypoint sync");
    }
}

