/*
 * Decompiled with CFR 0.152.
 */
package net.dfnkt.wayfindr;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import net.dfnkt.wayfindr.WaypointManager;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u0010\u001a\u00020\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0018\u001a\n \u0017*\u0004\u0018\u00010\u00160\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010 \u00a8\u0006!"}, d2={"Lnet/dfnkt/wayfindr/ServerWaypointSaveHandler;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "minecraftServer", "", "initialize", "(Lnet/minecraft/server/MinecraftServer;)V", "", "Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "loadWaypoints", "()Ljava/util/List;", "", "waypoints", "", "saveWaypoints", "(Ljava/util/Collection;)Z", "server", "Ljava/io/File;", "getSaveFile", "(Lnet/minecraft/server/MinecraftServer;)Ljava/io/File;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "", "SHARED_WAYPOINTS_FILE", "Ljava/lang/String;", "Lnet/minecraft/server/MinecraftServer;", "wayfindr"})
@SourceDebugExtension(value={"SMAP\nServerWaypointSaveHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerWaypointSaveHandler.kt\nnet/dfnkt/wayfindr/ServerWaypointSaveHandler\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,104:1\n222#2:105\n205#2:106\n*S KotlinDebug\n*F\n+ 1 ServerWaypointSaveHandler.kt\nnet/dfnkt/wayfindr/ServerWaypointSaveHandler\n*L\n55#1:105\n82#1:106\n*E\n"})
public final class ServerWaypointSaveHandler {
    @NotNull
    public static final ServerWaypointSaveHandler INSTANCE = new ServerWaypointSaveHandler();
    private static final Logger logger = LoggerFactory.getLogger((String)"wayfindr");
    @NotNull
    private static final Json json = JsonKt.Json$default(null, ServerWaypointSaveHandler::json$lambda$0, (int)1, null);
    @NotNull
    private static final String SHARED_WAYPOINTS_FILE = "wayfindr_shared_waypoints.json";
    @Nullable
    private static MinecraftServer server;

    private ServerWaypointSaveHandler() {
    }

    public final void initialize(@NotNull MinecraftServer minecraftServer) {
        Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"minecraftServer");
        server = minecraftServer;
        logger.info("Server waypoint save handler initialized");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WaypointManager.Waypoint> loadWaypoints() {
        List list;
        MinecraftServer minecraftServer = server;
        if (minecraftServer == null) {
            ServerWaypointSaveHandler $this$loadWaypoints_u24lambda_u241 = this;
            boolean bl = false;
            logger.error("Cannot load waypoints: Server not initialized");
            return CollectionsKt.emptyList();
        }
        MinecraftServer server = minecraftServer;
        File saveFile = this.getSaveFile(server);
        if (!saveFile.exists()) {
            logger.info("No shared waypoints file found, starting with empty list");
            return CollectionsKt.emptyList();
        }
        try {
            void this_$iv;
            String content = Files.readString(saveFile.toPath());
            Json bl = json;
            Intrinsics.checkNotNull((Object)content);
            String string$iv = content;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            List waypoints = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(WaypointManager.Waypoint.Companion.serializer()), string$iv);
            logger.info("Loaded " + waypoints.size() + " shared waypoints from disk");
            list = waypoints;
        }
        catch (Exception e) {
            logger.error("Failed to load shared waypoints", (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean saveWaypoints(@NotNull Collection<WaypointManager.Waypoint> waypoints) {
        boolean bl;
        Intrinsics.checkNotNullParameter(waypoints, (String)"waypoints");
        MinecraftServer minecraftServer = server;
        if (minecraftServer == null) {
            ServerWaypointSaveHandler $this$saveWaypoints_u24lambda_u242 = this;
            boolean bl2 = false;
            logger.error("Cannot save waypoints: Server not initialized");
            return false;
        }
        MinecraftServer server = minecraftServer;
        File saveFile = this.getSaveFile(server);
        File file = saveFile.getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        try {
            void this_$iv;
            Json $this$saveWaypoints_u24lambda_u242 = json;
            List value$iv = CollectionsKt.toList((Iterable)waypoints);
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            String content = this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(WaypointManager.Waypoint.Companion.serializer()), (Object)value$iv);
            Files.writeString(saveFile.toPath(), (CharSequence)content, new OpenOption[0]);
            logger.info("Saved " + waypoints.size() + " shared waypoints to disk");
            bl = true;
        }
        catch (Exception e) {
            logger.error("Failed to save shared waypoints", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    private final File getSaveFile(MinecraftServer server) {
        File worldDirectory = server.method_27050(class_5218.field_24188).toFile();
        return new File(worldDirectory, SHARED_WAYPOINTS_FILE);
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }
}

