/*
 * Decompiled with CFR 0.152.
 */
package net.dfnkt.wayfindr;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.dfnkt.wayfindr.WayfindrRaycast;
import net.dfnkt.wayfindr.WaypointManager;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J/\u0010\r\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lnet/dfnkt/wayfindr/WayfindrCommands;", "", "<init>", "()V", "", "register", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/minecraft/class_2168;", "context", "", "colorInt", "", "usePlayerPosition", "handleAddWaypoint", "(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/Integer;Z)I", "", "colorArg", "parseColor", "(Ljava/lang/String;)I", "wayfindr"})
public final class WayfindrCommands {
    @NotNull
    public static final WayfindrCommands INSTANCE = new WayfindrCommands();

    private WayfindrCommands() {
    }

    public final void register() {
        CommandRegistrationCallback.EVENT.register(WayfindrCommands::register$lambda$7);
    }

    private final int handleAddWaypoint(CommandContext<class_2168> context, Integer colorInt, boolean usePlayerPosition) {
        class_3222 class_32222 = ((class_2168)context.getSource()).method_44023();
        if (class_32222 == null) {
            return 0;
        }
        class_3222 player = class_32222;
        String name = StringArgumentType.getString(context, (String)"name");
        class_243 position = usePlayerPosition ? new class_243(player.method_23317(), player.method_23318(), player.method_23321()) : WayfindrRaycast.getRaycastPosition$default(WayfindrRaycast.INSTANCE, (class_1657)player, 0.0, 2, null);
        Integer n = colorInt;
        int finalColor = n != null ? n : 0xFF0000;
        Intrinsics.checkNotNull((Object)name);
        WaypointManager.Waypoint waypoint = WaypointManager.addWaypoint$default(WaypointManager.INSTANCE, name, position, finalColor, null, false, 24, null);
        String placementMode = usePlayerPosition ? "at your location" : "at crosshair target";
        ((class_2168)context.getSource()).method_9226(() -> WayfindrCommands.handleAddWaypoint$lambda$8(name, placementMode, position), false);
        return 1;
    }

    private final int parseColor(String colorArg) {
        int n;
        String string = colorArg.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        switch (string) {
            case "red": {
                n = 0xFF0000;
                break;
            }
            case "green": {
                n = 65280;
                break;
            }
            case "blue": {
                n = 255;
                break;
            }
            case "yellow": {
                n = 0xFFFF00;
                break;
            }
            case "purple": {
                n = 0x800080;
                break;
            }
            case "orange": {
                n = 16753920;
                break;
            }
            case "white": {
                n = 0xFFFFFF;
                break;
            }
            case "black": {
                n = 0;
                break;
            }
            default: {
                if (StringsKt.startsWith$default((String)colorArg, (String)"#", (boolean)false, (int)2, null)) {
                    try {
                        String string2 = colorArg.substring(1);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        return Integer.parseInt(string2, CharsKt.checkRadix((int)16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                n = 0xFF0000;
            }
        }
        return n;
    }

    private static final int register$lambda$7$lambda$0(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.handleAddWaypoint((CommandContext<class_2168>)context, null, false);
    }

    private static final int register$lambda$7$lambda$1(CommandContext context) {
        String colorArg = StringArgumentType.getString((CommandContext)context, (String)"color");
        Intrinsics.checkNotNull((Object)colorArg);
        int color = INSTANCE.parseColor(colorArg);
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.handleAddWaypoint((CommandContext<class_2168>)context, color, false);
    }

    private static final int register$lambda$7$lambda$2(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.handleAddWaypoint((CommandContext<class_2168>)context, null, true);
    }

    private static final int register$lambda$7$lambda$3(CommandContext context) {
        String colorArg = StringArgumentType.getString((CommandContext)context, (String)"color");
        Intrinsics.checkNotNull((Object)colorArg);
        int color = INSTANCE.parseColor(colorArg);
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.handleAddWaypoint((CommandContext<class_2168>)context, color, true);
    }

    private static final class_2561 register$lambda$7$lambda$6$lambda$4(String $name) {
        return (class_2561)class_2561.method_43470((String)("Removed waypoint '" + $name + "'"));
    }

    private static final class_2561 register$lambda$7$lambda$6$lambda$5(String $name) {
        return (class_2561)class_2561.method_43470((String)("No waypoint found with name '" + $name + "'"));
    }

    private static final int register$lambda$7$lambda$6(CommandContext context) {
        String name = StringArgumentType.getString((CommandContext)context, (String)"name");
        Intrinsics.checkNotNull((Object)name);
        WaypointManager.Waypoint waypoint = WaypointManager.INSTANCE.getWaypointByName(name);
        if (waypoint != null) {
            WaypointManager.INSTANCE.removeWaypoint(waypoint.getId());
            ((class_2168)context.getSource()).method_9226(() -> WayfindrCommands.register$lambda$7$lambda$6$lambda$4(name), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> WayfindrCommands.register$lambda$7$lambda$6$lambda$5(name), false);
        }
        return 1;
    }

    private static final void register$lambda$7(CommandDispatcher dispatcher, class_7157 class_71572, class_2170.class_5364 class_53642) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"waypoint").then(class_2170.method_9247((String)"add").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)((ArgumentType)StringArgumentType.string())).executes(WayfindrCommands::register$lambda$7$lambda$0)).then(class_2170.method_9244((String)"color", (ArgumentType)((ArgumentType)StringArgumentType.word())).executes(WayfindrCommands::register$lambda$7$lambda$1))))).then(class_2170.method_9247((String)"addhere").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)((ArgumentType)StringArgumentType.string())).executes(WayfindrCommands::register$lambda$7$lambda$2)).then(class_2170.method_9244((String)"color", (ArgumentType)((ArgumentType)StringArgumentType.word())).executes(WayfindrCommands::register$lambda$7$lambda$3))))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"name", (ArgumentType)((ArgumentType)StringArgumentType.string())).executes(WayfindrCommands::register$lambda$7$lambda$6))));
    }

    private static final class_2561 handleAddWaypoint$lambda$8(String $name, String $placementMode, class_243 $position) {
        return (class_2561)class_2561.method_43470((String)("Added waypoint '" + $name + "' " + $placementMode + " at " + (int)$position.field_1352 + ", " + (int)$position.field_1351 + ", " + (int)$position.field_1350));
    }
}

