/*
 * Decompiled with CFR 0.152.
 */
package net.dfnkt.wayfindr;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.random.Random;
import net.dfnkt.wayfindr.WayfindrConfig;
import net.dfnkt.wayfindr.WayfindrGui;
import net.dfnkt.wayfindr.WayfindrKeybinds;
import net.dfnkt.wayfindr.WayfindrNavigationRenderer;
import net.dfnkt.wayfindr.WayfindrNetworkClient;
import net.dfnkt.wayfindr.WayfindrRaycast;
import net.dfnkt.wayfindr.WayfindrRenderer;
import net.dfnkt.wayfindr.WaypointManager;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudLayerRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.IdentifiedLayer;
import net.fabricmc.fabric.api.client.rendering.v1.LayeredDrawerWrapper;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u001c\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001c\u0010\u0010\u001a\n \f*\u0004\u0018\u00010\u000f0\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lnet/dfnkt/wayfindr/WayfindrModClient;", "Lnet/fabricmc/api/ClientModInitializer;", "<init>", "()V", "", "onInitializeClient", "registerWorldChangeEvents", "registerPlayerDeathHandler", "", "generateRandomColor", "()I", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Lnet/minecraft/class_2960;", "NAVIGATION_LAYER_ID", "Lnet/minecraft/class_2960;", "wayfindr"})
public final class WayfindrModClient
implements ClientModInitializer {
    @NotNull
    public static final WayfindrModClient INSTANCE = new WayfindrModClient();
    private static final Logger logger = LoggerFactory.getLogger((String)"wayfindr");
    private static final class_2960 NAVIGATION_LAYER_ID = class_2960.method_60655((String)"wayfindr", (String)"navigation_layer");

    private WayfindrModClient() {
    }

    public void onInitializeClient() {
        WayfindrKeybinds.INSTANCE.initialize();
        WayfindrConfig.Companion.load();
        WaypointManager.INSTANCE.initializeWaypoints();
        this.registerWorldChangeEvents();
        this.registerPlayerDeathHandler();
        WayfindrNetworkClient.INSTANCE.initialize();
        WorldRenderEvents.AFTER_TRANSLUCENT.register(WayfindrModClient::onInitializeClient$lambda$0);
        HudLayerRegistrationCallback.EVENT.register(WayfindrModClient::onInitializeClient$lambda$2);
        ClientTickEvents.END_CLIENT_TICK.register(WayfindrModClient::onInitializeClient$lambda$3);
    }

    private final void registerWorldChangeEvents() {
        ClientPlayConnectionEvents.JOIN.register(WayfindrModClient::registerWorldChangeEvents$lambda$4);
        ClientPlayConnectionEvents.DISCONNECT.register(WayfindrModClient::registerWorldChangeEvents$lambda$5);
    }

    private final void registerPlayerDeathHandler() {
        Ref.FloatRef lastHealth = new Ref.FloatRef();
        lastHealth.element = 20.0f;
        Ref.ObjectRef lastPosition = new Ref.ObjectRef();
        class_746 class_7462 = class_310.method_1551().field_1724;
        lastPosition.element = class_7462 != null ? class_7462.method_19538() : null;
        ClientTickEvents.START_CLIENT_TICK.register(arg_0 -> WayfindrModClient.registerPlayerDeathHandler$lambda$7(lastHealth, lastPosition, arg_0));
    }

    private final int generateRandomColor() {
        int red = Random.Default.nextInt(100, 256);
        int green = Random.Default.nextInt(100, 256);
        int blue = Random.Default.nextInt(100, 256);
        return red << 16 | green << 8 | blue;
    }

    private static final void onInitializeClient$lambda$0(WorldRenderContext context) {
        class_4587 class_45872 = context.matrixStack();
        if (class_45872 == null) {
            return;
        }
        class_4587 matrixStack = class_45872;
        class_243 player = context.camera().method_19326();
        WayfindrConfig config = WayfindrConfig.Companion.get();
        for (WaypointManager.Waypoint waypoint : WaypointManager.INSTANCE.getWaypoints()) {
            double distance;
            if (!waypoint.getVisible() || !((distance = player.method_1022(waypoint.getPosition().toVec3d())) <= config.getMaxRenderDistance())) continue;
            class_243 class_2432 = waypoint.getPosition().toVec3d();
            Intrinsics.checkNotNull((Object)player);
            WayfindrRenderer.Companion.renderWaypointMarker(matrixStack, class_2432, player, waypoint.getColor(), waypoint.getName());
        }
    }

    private static final void onInitializeClient$lambda$2$lambda$1(class_332 context, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        if (client.field_1755 == null && !client.method_1493()) {
            Intrinsics.checkNotNull((Object)context);
            WayfindrNavigationRenderer.INSTANCE.render(context);
        }
    }

    private static final void onInitializeClient$lambda$2(LayeredDrawerWrapper layeredDrawer) {
        IdentifiedLayer navigationLayer = IdentifiedLayer.of((class_2960)NAVIGATION_LAYER_ID, WayfindrModClient::onInitializeClient$lambda$2$lambda$1);
        layeredDrawer.addLayer(navigationLayer);
    }

    private static final void onInitializeClient$lambda$3(class_310 mcClient) {
        class_746 player;
        while (WayfindrKeybinds.INSTANCE.getOPEN_WAYPOINT_MENU().method_1436()) {
            mcClient.method_1507((class_437)new WayfindrGui());
        }
        if (WayfindrKeybinds.INSTANCE.getQUICK_ADD_WAYPOINT().method_1436() && (player = mcClient.field_1724) != null) {
            String waypointName = "Quick Waypoint " + (WaypointManager.INSTANCE.getWaypoints().size() + 1);
            class_243 position = WayfindrRaycast.getRaycastPosition$default(WayfindrRaycast.INSTANCE, (class_1657)player, 0.0, 2, null);
            int randomColor = INSTANCE.generateRandomColor();
            WaypointManager.addWaypoint$default(WaypointManager.INSTANCE, waypointName, position, randomColor, null, false, 24, null);
        }
    }

    private static final void registerWorldChangeEvents$lambda$4(class_634 handler, PacketSender sender, class_310 client) {
        logger.info("Joined world, reloading waypoints");
        WaypointManager.INSTANCE.loadWaypointsForCurrentWorld();
    }

    private static final void registerWorldChangeEvents$lambda$5(class_634 handler, class_310 client) {
        logger.info("Disconnected from world");
    }

    private static final void registerPlayerDeathHandler$lambda$7(Ref.FloatRef $lastHealth, Ref.ObjectRef $lastPosition, class_310 client) {
        class_746 player = client.field_1724;
        if (player != null) {
            if ($lastHealth.element > 0.0f && player.method_6032() <= 0.0f) {
                logger.info("Player died, checking if death waypoint should be created");
                if (WayfindrConfig.Companion.get().getCreateDeathWaypoint()) {
                    class_243 class_2432 = (class_243)$lastPosition.element;
                    if (class_2432 != null) {
                        class_243 position = class_2432;
                        boolean bl = false;
                        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("MM-dd HH:mm"));
                        String waypointName = "Death Point " + timestamp;
                        String string = player.method_37908().method_27983().method_29177().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        WaypointManager.Waypoint deathWaypoint = WaypointManager.addWaypoint$default(WaypointManager.INSTANCE, waypointName, position, 0xFF0000, string, false, 16, null);
                        logger.info("Created death waypoint at " + position.field_1352 + ", " + position.field_1351 + ", " + position.field_1350);
                        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c[Wayfindr]\u00a7r Created waypoint at your death location."), false);
                    }
                }
            }
            $lastHealth.element = player.method_6032();
            $lastPosition.element = player.method_19538();
        } else {
            $lastHealth.element = 20.0f;
            $lastPosition.element = null;
        }
    }
}

