/*
 * Decompiled with CFR 0.152.
 */
package net.dfnkt.wayfindr;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.dfnkt.wayfindr.WaypointManager;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000e\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015JO\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJO\u0010#\u001a\u00020\"2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010&\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010(\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b(\u0010'JG\u0010*\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b*\u0010+JO\u0010,\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b,\u0010\u001fJE\u00100\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010-\u001a\u00020\f2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\f0.H\u0002\u00a2\u0006\u0004\b0\u00101J\u001f\u00103\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b3\u00104R\u0014\u00105\u001a\u00020\u001c8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0014\u00107\u001a\u00020\u001c8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b7\u00106R\u0014\u00108\u001a\u00020\u001c8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b8\u00106R\u0014\u00109\u001a\u00020\u001c8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b9\u00106R\u0014\u0010:\u001a\u00020\u001c8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b:\u00106R\u0014\u0010;\u001a\u00020\u001c8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b;\u00106\u00a8\u0006<"}, d2={"Lnet/dfnkt/wayfindr/WayfindrNavigationRenderer;", "", "<init>", "()V", "Lnet/minecraft/class_332;", "context", "", "render", "(Lnet/minecraft/class_332;)V", "Lnet/minecraft/class_243;", "playerPos", "waypointPos", "", "playerYaw", "calculateDirection", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;F)F", "", "calculateDistance", "(Lnet/minecraft/class_243;Lnet/minecraft/class_243;)D", "direction", "renderArrow", "(Lnet/minecraft/class_332;F)V", "x1", "y1", "x2", "y2", "x3", "y3", "", "color", "drawSmoothTriangle", "(Lnet/minecraft/class_332;FFFFFFI)V", "px", "py", "", "isPointInTriangle", "(FFFFFFFF)Z", "factor", "darkenColor", "(IF)I", "lightenColor", "thickness", "drawLine", "(Lnet/minecraft/class_332;FFFFII)V", "drawTriangle", "y", "", "intersections", "addIntersection", "(FFFFFLjava/util/List;)V", "distance", "renderDistance", "(Lnet/minecraft/class_332;D)V", "ARROW_SIZE", "I", "ARROW_PADDING", "ARROW_COLOR", "ARROW_GLOW_COLOR", "DISTANCE_COLOR", "ANTI_ALIASING_SAMPLES", "wayfindr"})
public final class WayfindrNavigationRenderer {
    @NotNull
    public static final WayfindrNavigationRenderer INSTANCE = new WayfindrNavigationRenderer();
    private static final int ARROW_SIZE = 14;
    private static final int ARROW_PADDING = 10;
    private static final int ARROW_COLOR = -1;
    private static final int ARROW_GLOW_COLOR = -1711276033;
    private static final int DISTANCE_COLOR = -1;
    private static final int ANTI_ALIASING_SAMPLES = 8;

    private WayfindrNavigationRenderer() {
    }

    public final void render(@NotNull class_332 context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        class_310 client = class_310.method_1551();
        class_746 class_7462 = client.field_1724;
        if (class_7462 == null) {
            return;
        }
        class_746 player = class_7462;
        WaypointManager.Waypoint waypoint = WaypointManager.INSTANCE.getNavigationTarget();
        if (waypoint == null) {
            return;
        }
        WaypointManager.Waypoint targetWaypoint = waypoint;
        if (!Intrinsics.areEqual((Object)player.method_37908().method_27983().method_29177().toString(), (Object)targetWaypoint.getDimension())) {
            return;
        }
        class_243 playerPos = player.method_19538();
        Intrinsics.checkNotNull((Object)playerPos);
        if (WaypointManager.INSTANCE.isWithinDeadzone(playerPos)) {
            WaypointManager.INSTANCE.clearNavigationTarget();
            player.method_7353((class_2561)class_2561.method_43470((String)("You have reached your waypoint: " + targetWaypoint.getName())), true);
            return;
        }
        float direction = this.calculateDirection(playerPos, targetWaypoint.getPosition(), player.method_36454());
        double distance = this.calculateDistance(playerPos, targetWaypoint.getPosition());
        this.renderArrow(context, direction);
        this.renderDistance(context, distance);
    }

    private final float calculateDirection(class_243 playerPos, class_243 waypointPos, float playerYaw) {
        float relativeAngle;
        double dx = waypointPos.field_1352 - playerPos.field_1352;
        double dz = waypointPos.field_1350 - playerPos.field_1350;
        float angleToWaypoint = (float)Math.toDegrees(Math.atan2(dz, dx));
        for (relativeAngle = angleToWaypoint - playerYaw + (float)90; relativeAngle > 360.0f; relativeAngle -= (float)360) {
        }
        while (relativeAngle < 0.0f) {
            relativeAngle += (float)360;
        }
        return relativeAngle;
    }

    private final double calculateDistance(class_243 playerPos, class_243 waypointPos) {
        double dx = waypointPos.field_1352 - playerPos.field_1352;
        double dy = waypointPos.field_1351 - playerPos.field_1351;
        double dz = waypointPos.field_1350 - playerPos.field_1350;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private final void renderArrow(class_332 context, float direction) {
        class_310 client = class_310.method_1551();
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int centerX = screenWidth / 2;
        int centerY = 24;
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)centerX, (float)centerY, 0.0f);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(direction + 180.0f));
        float arrowSize = 11.2f;
        this.drawSmoothTriangle(context, 0.0f, -arrowSize / (float)2 - (float)2, -arrowSize / (float)2 - (float)2, arrowSize / (float)2 + (float)2, arrowSize / (float)2 + (float)2, arrowSize / (float)2 + (float)2, -1711276033);
        this.drawSmoothTriangle(context, 0.0f, -arrowSize / (float)2, -arrowSize / (float)2, arrowSize / (float)2, arrowSize / (float)2, arrowSize / (float)2, -1);
        matrices.method_22909();
    }

    private final void drawSmoothTriangle(class_332 context, float x1, float y1, float x2, float y2, float x3, float y3, int color) {
        int minX = (int)Math.min(x1, Math.min(x2, x3)) - 1;
        int maxX = (int)Math.max(x1, Math.max(x2, x3)) + 1;
        int minY = (int)Math.min(y1, Math.min(y2, y3)) - 1;
        int maxY = (int)Math.max(y1, Math.max(y2, y3)) + 1;
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int y = minY;
        if (y <= maxY) {
            while (true) {
                int x;
                if ((x = minX) <= maxX) {
                    while (true) {
                        float coverage = 0.0f;
                        float step = 0.125f;
                        for (int sy = 0; sy < 8; ++sy) {
                            for (int sx = 0; sx < 8; ++sx) {
                                float sampleX = (float)x + ((float)sx + 0.5f) * step;
                                float sampleY = (float)y + ((float)sy + 0.5f) * step;
                                if (!this.isPointInTriangle(sampleX, sampleY, x1, y1, x2, y2, x3, y3)) continue;
                                coverage += 0.015625f;
                            }
                        }
                        if (coverage > 0.0f) {
                            int finalAlpha = RangesKt.coerceIn((int)((int)((float)alpha * coverage)), (int)0, (int)255);
                            int finalColor = finalAlpha << 24 | red << 16 | green << 8 | blue;
                            context.method_25294(x, y, x + 1, y + 1, finalColor);
                        }
                        if (x == maxX) break;
                        ++x;
                    }
                }
                if (y == maxY) break;
                ++y;
            }
        }
    }

    private final boolean isPointInTriangle(float px, float py, float x1, float y1, float x2, float y2, float x3, float y3) {
        float denominator = (y2 - y3) * (x1 - x3) + (x3 - x2) * (y1 - y3);
        if (denominator == 0.0f) {
            return false;
        }
        float a = ((y2 - y3) * (px - x3) + (x3 - x2) * (py - y3)) / denominator;
        float b = ((y3 - y1) * (px - x3) + (x1 - x3) * (py - y3)) / denominator;
        float c = 1.0f - a - b;
        return a >= 0.0f && a <= 1.0f && b >= 0.0f && b <= 1.0f && c >= 0.0f && c <= 1.0f;
    }

    private final int darkenColor(int color, float factor) {
        int a = color >> 24 & 0xFF;
        float r = (float)(color >> 16 & 0xFF) * factor;
        float g = (float)(color >> 8 & 0xFF) * factor;
        float b = (float)(color & 0xFF) * factor;
        return a << 24 | ((int)r & 0xFF) << 16 | ((int)g & 0xFF) << 8 | (int)b & 0xFF;
    }

    private final int lightenColor(int color, float factor) {
        int a = color >> 24 & 0xFF;
        float r = Math.min(255.0f, (float)(color >> 16 & 0xFF) * factor);
        float g = Math.min(255.0f, (float)(color >> 8 & 0xFF) * factor);
        float b = Math.min(255.0f, (float)(color & 0xFF) * factor);
        return a << 24 | ((int)r & 0xFF) << 16 | ((int)g & 0xFF) << 8 | (int)b & 0xFF;
    }

    private final void drawLine(class_332 context, float x1, float y1, float x2, float y2, int color, int thickness) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float length = (float)Math.sqrt(dx * dx + dy * dy);
        if (length < 1.0E-4f) {
            return;
        }
        float dirX = dx / length;
        float dirY = dy / length;
        float perpX = -dirY;
        float perpY = dirX;
        float halfThickness = (float)thickness / 2.0f;
        this.drawTriangle(context, x1 + perpX * halfThickness, y1 + perpY * halfThickness, x1 - perpX * halfThickness, y1 - perpY * halfThickness, x2 + perpX * halfThickness, y2 + perpY * halfThickness, color);
        this.drawTriangle(context, x2 + perpX * halfThickness, y2 + perpY * halfThickness, x1 - perpX * halfThickness, y1 - perpY * halfThickness, x2 - perpX * halfThickness, y2 - perpY * halfThickness, color);
    }

    private final void drawTriangle(class_332 context, float x1, float y1, float x2, float y2, float x3, float y3, int color) {
        int maxY;
        int minY = (int)Math.min(y1, Math.min(y2, y3));
        int y = minY;
        if (y <= (maxY = (int)Math.max(y1, Math.max(y2, y3)))) {
            while (true) {
                float yf = y;
                List intersections = new ArrayList();
                this.addIntersection(x1, y1, x2, y2, yf, intersections);
                this.addIntersection(x2, y2, x3, y3, yf, intersections);
                this.addIntersection(x3, y3, x1, y1, yf, intersections);
                if (intersections.size() >= 2) {
                    CollectionsKt.sort((List)intersections);
                    context.method_25294((int)((Number)intersections.get(0)).floatValue(), y, (int)((Number)intersections.get(1)).floatValue() + 1, y + 1, color);
                }
                if (y == maxY) break;
                ++y;
            }
        }
    }

    private final void addIntersection(float x1, float y1, float x2, float y2, float y, List<Float> intersections) {
        if ((y1 <= y && y2 >= y || y1 >= y && y2 <= y) && !(y1 == y2)) {
            float x = x1 + (x2 - x1) * (y - y1) / (y2 - y1);
            intersections.add(Float.valueOf(x));
        }
    }

    private final void renderDistance(class_332 context, double distance) {
        class_310 client = class_310.method_1551();
        int screenWidth = client.method_22683().method_4486();
        String distanceText = (int)distance + " blocks";
        int textWidth = client.field_1772.method_1727(distanceText);
        int textX = (screenWidth - textWidth) / 2;
        int textY = 34;
        context.method_51433(client.field_1772, distanceText, textX, textY, -1, true);
    }
}

