/*
 * Decompiled with CFR 0.152.
 */
package net.dfnkt.wayfindr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import net.dfnkt.wayfindr.WayfindrNetworking;
import net.dfnkt.wayfindr.WaypointManager;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lnet/dfnkt/wayfindr/WayfindrNetworkClient;", "", "<init>", "()V", "", "initialize", "Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "waypoint", "", "sendWaypointToServer", "(Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;)Z", "sendWaypointUpdateToServer", "Ljava/util/UUID;", "waypointId", "sendWaypointDeleteToServer", "(Ljava/util/UUID;)Z", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "wayfindr"})
@SourceDebugExtension(value={"SMAP\nWayfindrNetworkClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WayfindrNetworkClient.kt\nnet/dfnkt/wayfindr/WayfindrNetworkClient\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n205#2:188\n205#2:189\n222#2:190\n222#2:201\n222#2:202\n774#3:191\n865#3,2:192\n1557#3:194\n1628#3,3:195\n774#3:198\n865#3,2:199\n*S KotlinDebug\n*F\n+ 1 WayfindrNetworkClient.kt\nnet/dfnkt/wayfindr/WayfindrNetworkClient\n*L\n137#1:188\n157#1:189\n28#1:190\n60#1:201\n87#1:202\n32#1:191\n32#1:192,2\n35#1:194\n35#1:195,3\n38#1:198\n38#1:199,2\n*E\n"})
public final class WayfindrNetworkClient {
    @NotNull
    public static final WayfindrNetworkClient INSTANCE = new WayfindrNetworkClient();
    private static final Logger logger = LoggerFactory.getLogger((String)"wayfindr");
    @NotNull
    private static final Json json = JsonKt.Json$default(null, WayfindrNetworkClient::json$lambda$0, (int)1, null);

    private WayfindrNetworkClient() {
    }

    public final void initialize() {
        logger.info("Initializing client-side network handlers for waypoint synchronization");
        ClientPlayNetworking.registerGlobalReceiver(WayfindrNetworking.WaypointSyncPayload.Companion.getID(), WayfindrNetworkClient::initialize$lambda$5);
        ClientPlayNetworking.registerGlobalReceiver(WayfindrNetworking.WaypointAddPayload.Companion.getID(), WayfindrNetworkClient::initialize$lambda$7);
        ClientPlayNetworking.registerGlobalReceiver(WayfindrNetworking.WaypointUpdatePayload.Companion.getID(), WayfindrNetworkClient::initialize$lambda$9);
        ClientPlayNetworking.registerGlobalReceiver(WayfindrNetworking.WaypointDeletePayload.Companion.getID(), WayfindrNetworkClient::initialize$lambda$11);
        logger.info("Registered waypoint network handlers");
    }

    public final boolean sendWaypointToServer(@NotNull WaypointManager.Waypoint waypoint) {
        Intrinsics.checkNotNullParameter((Object)waypoint, (String)"waypoint");
        try {
            logger.info("Sending waypoint to server: " + waypoint.getName() + " (ID: " + waypoint.getId() + ")");
            Json this_$iv = json;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            String jsonData = this_$iv.encodeToString((SerializationStrategy)WaypointManager.Waypoint.Companion.serializer(), (Object)waypoint);
            WayfindrNetworking.WaypointAddPayload payload = new WayfindrNetworking.WaypointAddPayload(jsonData);
            ClientPlayNetworking.send((class_8710)payload);
            logger.info("Sent waypoint to server: " + waypoint.getName());
            return true;
        }
        catch (Exception e) {
            logger.error("Error sending waypoint to server", (Throwable)e);
            return false;
        }
    }

    public final boolean sendWaypointUpdateToServer(@NotNull WaypointManager.Waypoint waypoint) {
        Intrinsics.checkNotNullParameter((Object)waypoint, (String)"waypoint");
        try {
            logger.info("Sending waypoint update to server: " + waypoint.getName() + " (ID: " + waypoint.getId() + ")");
            Json this_$iv = json;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            String jsonData = this_$iv.encodeToString((SerializationStrategy)WaypointManager.Waypoint.Companion.serializer(), (Object)waypoint);
            WayfindrNetworking.WaypointUpdatePayload payload = new WayfindrNetworking.WaypointUpdatePayload(jsonData);
            ClientPlayNetworking.send((class_8710)payload);
            logger.info("Sent waypoint update to server: " + waypoint.getName());
            return true;
        }
        catch (Exception e) {
            logger.error("Error sending waypoint update to server", (Throwable)e);
            return false;
        }
    }

    public final boolean sendWaypointDeleteToServer(@NotNull UUID waypointId) {
        Intrinsics.checkNotNullParameter((Object)waypointId, (String)"waypointId");
        try {
            logger.info("Sending waypoint delete to server for ID: " + waypointId);
            String string = waypointId.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            WayfindrNetworking.WaypointDeletePayload payload = new WayfindrNetworking.WaypointDeletePayload(string);
            ClientPlayNetworking.send((class_8710)payload);
            logger.info("Sent waypoint delete to server for ID: " + waypointId);
            return true;
        }
        catch (Exception e) {
            logger.error("Error sending waypoint delete to server", (Throwable)e);
            return false;
        }
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void initialize$lambda$5$lambda$4(String $jsonData) {
        try {
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            void $this$filterTo$iv$iv2;
            logger.info("Received waypoint sync data: " + $jsonData);
            Json this_$iv = json;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            List serverWaypoints = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(WaypointManager.Waypoint.Companion.serializer()), $jsonData);
            logger.info("Received waypoint sync with " + serverWaypoints.size() + " waypoints");
            Iterable $this$filter$iv = WaypointManager.INSTANCE.getWaypoints();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                WaypointManager.Waypoint it = (WaypointManager.Waypoint)element$iv$iv;
                boolean bl = false;
                if (!(!it.isShared())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List localWaypoints = (List)destination$iv$iv;
            Iterable $this$map$iv = WaypointManager.INSTANCE.getWaypoints();
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                WaypointManager.Waypoint bl = (WaypointManager.Waypoint)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getId());
            }
            Set existingWaypointIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            Iterable $this$filter$iv2 = serverWaypoints;
            boolean $i$f$filter2 = false;
            destination$iv$iv2 = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                WaypointManager.Waypoint it = (WaypointManager.Waypoint)element$iv$iv;
                boolean bl = false;
                if (!(!existingWaypointIds.contains(it.getId()))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List newServerWaypoints = (List)destination$iv$iv3;
            List combinedWaypoints = CollectionsKt.plus((Collection)localWaypoints, (Iterable)newServerWaypoints);
            WaypointManager.INSTANCE.replaceAllWaypoints(combinedWaypoints);
            logger.info("Synchronized " + newServerWaypoints.size() + " new shared waypoints from server while preserving " + localWaypoints.size() + " local waypoints");
        }
        catch (Exception e) {
            logger.error("Error processing waypoint sync", (Throwable)e);
        }
    }

    private static final void initialize$lambda$5(WayfindrNetworking.WaypointSyncPayload payload, ClientPlayNetworking.Context context) {
        String jsonData = payload.getData();
        context.client().execute(() -> WayfindrNetworkClient.initialize$lambda$5$lambda$4(jsonData));
    }

    private static final void initialize$lambda$7$lambda$6(String $jsonData) {
        try {
            logger.info("Received waypoint add data: " + $jsonData);
            Json this_$iv = json;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            WaypointManager.Waypoint waypoint = (WaypointManager.Waypoint)this_$iv.decodeFromString((DeserializationStrategy)WaypointManager.Waypoint.Companion.serializer(), $jsonData);
            logger.info("Adding waypoint from server: " + waypoint.getName() + " (ID: " + waypoint.getId() + ", Owner: " + waypoint.getOwner() + ")");
            WaypointManager.Waypoint existingWaypoint = WaypointManager.INSTANCE.getWaypoint(waypoint.getId());
            if (existingWaypoint != null) {
                logger.info("Waypoint with ID " + waypoint.getId() + " already exists, updating instead of adding");
                WaypointManager.INSTANCE.updateWaypoint(waypoint);
            } else {
                WaypointManager.INSTANCE.addWaypoint(waypoint);
                logger.info("Added waypoint from server: " + waypoint.getName());
            }
        }
        catch (Exception e) {
            logger.error("Error processing waypoint add", (Throwable)e);
        }
    }

    private static final void initialize$lambda$7(WayfindrNetworking.WaypointAddPayload payload, ClientPlayNetworking.Context context) {
        String jsonData = payload.getData();
        context.client().execute(() -> WayfindrNetworkClient.initialize$lambda$7$lambda$6(jsonData));
    }

    private static final void initialize$lambda$9$lambda$8(String $jsonData) {
        try {
            logger.info("Received waypoint update data: " + $jsonData);
            Json this_$iv = json;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            WaypointManager.Waypoint updatedWaypoint = (WaypointManager.Waypoint)this_$iv.decodeFromString((DeserializationStrategy)WaypointManager.Waypoint.Companion.serializer(), $jsonData);
            boolean success = WaypointManager.INSTANCE.updateWaypoint(updatedWaypoint);
            if (success) {
                logger.info("Updated waypoint from server: " + updatedWaypoint.getName() + " (ID: " + updatedWaypoint.getId() + ", Owner: " + updatedWaypoint.getOwner() + ")");
            } else {
                logger.warn("Received update for unknown waypoint ID: " + updatedWaypoint.getId());
            }
        }
        catch (Exception e) {
            logger.error("Error processing waypoint update", (Throwable)e);
        }
    }

    private static final void initialize$lambda$9(WayfindrNetworking.WaypointUpdatePayload payload, ClientPlayNetworking.Context context) {
        String jsonData = payload.getData();
        context.client().execute(() -> WayfindrNetworkClient.initialize$lambda$9$lambda$8(jsonData));
    }

    private static final void initialize$lambda$11$lambda$10(UUID $waypointId) {
        try {
            logger.info("Received waypoint delete for ID: " + $waypointId);
            Intrinsics.checkNotNull((Object)$waypointId);
            boolean success = WaypointManager.INSTANCE.removeWaypoint($waypointId);
            if (success) {
                logger.info("Removed waypoint with ID: " + $waypointId);
            } else {
                logger.warn("Received delete for unknown waypoint ID: " + $waypointId);
            }
        }
        catch (Exception e) {
            logger.error("Error processing waypoint delete", (Throwable)e);
        }
    }

    private static final void initialize$lambda$11(WayfindrNetworking.WaypointDeletePayload payload, ClientPlayNetworking.Context context) {
        UUID waypointId = UUID.fromString(payload.getWaypointId());
        context.client().execute(() -> WayfindrNetworkClient.initialize$lambda$11$lambda$10(waypointId));
    }
}

