/*
 * Decompiled with CFR 0.152.
 */
package net.dfnkt.wayfindr;

import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import net.dfnkt.wayfindr.ServerWaypointManager;
import net.dfnkt.wayfindr.WayfindrNetworking;
import net.dfnkt.wayfindr.WaypointManager;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u0015\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0015\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0019\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lnet/dfnkt/wayfindr/WayfindrNetworkServer;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "minecraftServer", "", "initialize", "(Lnet/minecraft/server/MinecraftServer;)V", "registerNetworkHandlers", "Lnet/minecraft/class_3222;", "player", "sendWaypointSync", "(Lnet/minecraft/class_3222;)V", "Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "waypoint", "broadcastWaypointAdd", "(Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;)V", "broadcastWaypointUpdate", "Ljava/util/UUID;", "waypointId", "broadcastWaypointDelete", "(Ljava/util/UUID;)V", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "server", "Lnet/minecraft/server/MinecraftServer;", "wayfindr"})
@SourceDebugExtension(value={"SMAP\nWayfindrNetworkServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WayfindrNetworkServer.kt\nnet/dfnkt/wayfindr/WayfindrNetworkServer\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,225:1\n205#2:226\n205#2:227\n205#2:228\n222#2:229\n222#2:230\n*S KotlinDebug\n*F\n+ 1 WayfindrNetworkServer.kt\nnet/dfnkt/wayfindr/WayfindrNetworkServer\n*L\n158#1:226\n173#1:227\n193#1:228\n47#1:229\n78#1:230\n*E\n"})
public final class WayfindrNetworkServer {
    @NotNull
    public static final WayfindrNetworkServer INSTANCE = new WayfindrNetworkServer();
    private static final Logger logger = LoggerFactory.getLogger((String)"wayfindr");
    @NotNull
    private static final Json json = JsonKt.Json$default(null, WayfindrNetworkServer::json$lambda$0, (int)1, null);
    @Nullable
    private static MinecraftServer server;

    private WayfindrNetworkServer() {
    }

    public final void initialize(@NotNull MinecraftServer minecraftServer) {
        Intrinsics.checkNotNullParameter((Object)minecraftServer, (String)"minecraftServer");
        server = minecraftServer;
        this.registerNetworkHandlers();
        logger.info("Server-side waypoint network handlers initialized");
    }

    private final void registerNetworkHandlers() {
        logger.info("Registering server-side network handlers for waypoint synchronization");
        ServerPlayNetworking.registerGlobalReceiver(WayfindrNetworking.WaypointAddPayload.Companion.getID(), WayfindrNetworkServer::registerNetworkHandlers$lambda$2);
        ServerPlayNetworking.registerGlobalReceiver(WayfindrNetworking.WaypointUpdatePayload.Companion.getID(), WayfindrNetworkServer::registerNetworkHandlers$lambda$4);
        ServerPlayNetworking.registerGlobalReceiver(WayfindrNetworking.WaypointDeletePayload.Companion.getID(), WayfindrNetworkServer::registerNetworkHandlers$lambda$6);
        logger.info("Server-side network handlers registered successfully");
    }

    public final void sendWaypointSync(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List<WaypointManager.Waypoint> waypoints = ServerWaypointManager.INSTANCE.getAllWaypoints();
        logger.info("Preparing to send waypoint sync to " + player.method_5477().getString() + " with " + waypoints.size() + " waypoints");
        Json this_$iv = json;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        String jsonData = this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(WaypointManager.Waypoint.Companion.serializer()), waypoints);
        logger.debug("Waypoint sync data: " + jsonData);
        WayfindrNetworking.WaypointSyncPayload payload = new WayfindrNetworking.WaypointSyncPayload(jsonData);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        logger.info("Sent waypoint sync to player " + player.method_5477().getString() + " with " + waypoints.size() + " waypoints");
    }

    public final void broadcastWaypointAdd(@NotNull WaypointManager.Waypoint waypoint) {
        Intrinsics.checkNotNullParameter((Object)waypoint, (String)"waypoint");
        MinecraftServer minecraftServer = server;
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        Json this_$iv = json;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        String jsonData = this_$iv.encodeToString((SerializationStrategy)WaypointManager.Waypoint.Companion.serializer(), (Object)waypoint);
        logger.debug("Broadcasting waypoint add data: " + jsonData);
        WayfindrNetworking.WaypointAddPayload payload = new WayfindrNetworking.WaypointAddPayload(jsonData);
        int playerCount = 0;
        for (class_3222 player : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
            ++playerCount;
        }
        logger.info("Broadcast waypoint add to " + playerCount + " players: " + waypoint.getName());
    }

    public final void broadcastWaypointUpdate(@NotNull WaypointManager.Waypoint waypoint) {
        Intrinsics.checkNotNullParameter((Object)waypoint, (String)"waypoint");
        MinecraftServer minecraftServer = server;
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        Json this_$iv = json;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        String jsonData = this_$iv.encodeToString((SerializationStrategy)WaypointManager.Waypoint.Companion.serializer(), (Object)waypoint);
        logger.debug("Broadcasting waypoint update data: " + jsonData);
        WayfindrNetworking.WaypointUpdatePayload payload = new WayfindrNetworking.WaypointUpdatePayload(jsonData);
        int playerCount = 0;
        for (class_3222 player : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
            ++playerCount;
        }
        logger.info("Broadcast waypoint update to " + playerCount + " players: " + waypoint.getName());
    }

    public final void broadcastWaypointDelete(@NotNull UUID waypointId) {
        Intrinsics.checkNotNullParameter((Object)waypointId, (String)"waypointId");
        MinecraftServer minecraftServer = server;
        if (minecraftServer == null) {
            return;
        }
        MinecraftServer server = minecraftServer;
        logger.debug("Broadcasting waypoint delete for ID: " + waypointId);
        String string = waypointId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        WayfindrNetworking.WaypointDeletePayload payload = new WayfindrNetworking.WaypointDeletePayload(string);
        int playerCount = 0;
        for (class_3222 player : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
            ++playerCount;
        }
        logger.info("Broadcast waypoint delete to " + playerCount + " players for ID: " + waypointId);
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final void registerNetworkHandlers$lambda$2$lambda$1(String $jsonData, ServerPlayNetworking.Context $context) {
        try {
            Json this_$iv = json;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            WaypointManager.Waypoint receivedWaypoint = (WaypointManager.Waypoint)this_$iv.decodeFromString((DeserializationStrategy)WaypointManager.Waypoint.Companion.serializer(), $jsonData);
            logger.info("Decoded waypoint: " + receivedWaypoint.getName() + " (ID: " + receivedWaypoint.getId() + ")");
            UUID uUID = $context.player().method_5667();
            WaypointManager.Waypoint waypoint = WaypointManager.Waypoint.copy$default(receivedWaypoint, null, null, 0, null, false, true, uUID, null, 159, null);
            logger.info("Adding waypoint to ServerWaypointManager: " + waypoint.getName() + " (ID: " + waypoint.getId() + ", Owner: " + waypoint.getOwner() + ")");
            ServerWaypointManager.INSTANCE.addWaypoint(waypoint);
            logger.info("Broadcasting waypoint add to all players: " + waypoint.getName());
            INSTANCE.broadcastWaypointAdd(waypoint);
            logger.info("Player " + $context.player().method_5477().getString() + " added shared waypoint: " + waypoint.getName());
        }
        catch (Exception e) {
            logger.error("Error processing waypoint add request from " + $context.player().method_5477().getString(), (Throwable)e);
        }
    }

    private static final void registerNetworkHandlers$lambda$2(WayfindrNetworking.WaypointAddPayload payload, ServerPlayNetworking.Context context) {
        String jsonData = payload.getData();
        logger.info("Received waypoint add request from " + context.player().method_5477().getString() + ": " + jsonData);
        context.server().execute(() -> WayfindrNetworkServer.registerNetworkHandlers$lambda$2$lambda$1(jsonData, context));
    }

    private static final void registerNetworkHandlers$lambda$4$lambda$3(String $jsonData, ServerPlayNetworking.Context $context) {
        try {
            Json this_$iv = json;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            WaypointManager.Waypoint waypoint = (WaypointManager.Waypoint)this_$iv.decodeFromString((DeserializationStrategy)WaypointManager.Waypoint.Companion.serializer(), $jsonData);
            logger.info("Decoded waypoint update: " + waypoint.getName() + " (ID: " + waypoint.getId() + ")");
            WaypointManager.Waypoint existingWaypoint = ServerWaypointManager.INSTANCE.getWaypoint(waypoint.getId());
            if (existingWaypoint != null) {
                logger.info("Found existing waypoint: " + existingWaypoint.getName() + " (Owner: " + existingWaypoint.getOwner() + ")");
                if (Intrinsics.areEqual((Object)existingWaypoint.getOwner(), (Object)$context.player().method_5667()) || $context.player().method_64475(2)) {
                    if (ServerWaypointManager.INSTANCE.updateWaypoint(waypoint)) {
                        logger.info("Broadcasting waypoint update to all players: " + waypoint.getName());
                        INSTANCE.broadcastWaypointUpdate(waypoint);
                        logger.info("Player " + $context.player().method_5477().getString() + " updated shared waypoint: " + waypoint.getName());
                    } else {
                        logger.warn("Failed to update waypoint in ServerWaypointManager: " + waypoint.getName());
                    }
                } else {
                    logger.warn("Player " + $context.player().method_5477().getString() + " attempted to update waypoint without permission");
                }
            } else {
                logger.warn("Waypoint not found for update: " + waypoint.getId());
            }
        }
        catch (Exception e) {
            logger.error("Error processing waypoint update request from " + $context.player().method_5477().getString(), (Throwable)e);
        }
    }

    private static final void registerNetworkHandlers$lambda$4(WayfindrNetworking.WaypointUpdatePayload payload, ServerPlayNetworking.Context context) {
        String jsonData = payload.getData();
        logger.info("Received waypoint update request from " + context.player().method_5477().getString() + ": " + jsonData);
        context.server().execute(() -> WayfindrNetworkServer.registerNetworkHandlers$lambda$4$lambda$3(jsonData, context));
    }

    private static final void registerNetworkHandlers$lambda$6$lambda$5(UUID $waypointId, ServerPlayNetworking.Context $context) {
        try {
            Intrinsics.checkNotNull((Object)$waypointId);
            WaypointManager.Waypoint waypoint = ServerWaypointManager.INSTANCE.getWaypoint($waypointId);
            if (waypoint != null) {
                logger.info("Found waypoint to delete: " + waypoint.getName() + " (Owner: " + waypoint.getOwner() + ")");
                if (Intrinsics.areEqual((Object)waypoint.getOwner(), (Object)$context.player().method_5667()) || $context.player().method_64475(2)) {
                    if (ServerWaypointManager.INSTANCE.removeWaypoint($waypointId)) {
                        logger.info("Broadcasting waypoint delete to all players: " + waypoint.getName());
                        INSTANCE.broadcastWaypointDelete($waypointId);
                        logger.info("Player " + $context.player().method_5477().getString() + " deleted shared waypoint: " + waypoint.getName());
                    } else {
                        logger.warn("Failed to delete waypoint in ServerWaypointManager: " + waypoint.getName());
                    }
                } else {
                    logger.warn("Player " + $context.player().method_5477().getString() + " attempted to delete waypoint without permission");
                }
            } else {
                logger.warn("Waypoint not found for deletion: " + $waypointId);
            }
        }
        catch (Exception e) {
            logger.error("Error processing waypoint delete request from " + $context.player().method_5477().getString(), (Throwable)e);
        }
    }

    private static final void registerNetworkHandlers$lambda$6(WayfindrNetworking.WaypointDeletePayload payload, ServerPlayNetworking.Context context) {
        UUID waypointId = UUID.fromString(payload.getWaypointId());
        logger.info("Received waypoint delete request from " + context.player().method_5477().getString() + " for ID: " + waypointId);
        context.server().execute(() -> WayfindrNetworkServer.registerNetworkHandlers$lambda$6$lambda$5(waypointId, context));
    }
}

