/*
 * Decompiled with CFR 0.152.
 */
package net.dfnkt.wayfindr;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import net.dfnkt.wayfindr.WaypointManager;
import net.minecraft.class_310;
import net.minecraft.class_642;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001+B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001b\u0010\u0019\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001b\u0010\u0003J\u0015\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001d\u0010\u0017R\u001c\u0010 \u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010)\u00a8\u0006,"}, d2={"Lnet/dfnkt/wayfindr/WayfindrSaveFileHandler;", "", "<init>", "()V", "", "ensureDirectoriesExist", "()Z", "", "getCurrentWorldName", "()Ljava/lang/String;", "Ljava/io/File;", "getWorldWaypointFile", "()Ljava/io/File;", "name", "sanitizeFileName", "(Ljava/lang/String;)Ljava/lang/String;", "", "Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "loadWaypoints", "()Ljava/util/List;", "waypointJson", "", "saveWaypoint", "(Ljava/lang/String;)V", "waypoints", "saveAllWaypoints", "(Ljava/util/List;)V", "clearCache", "worldName", "invalidateCache", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "Lnet/dfnkt/wayfindr/WayfindrSaveFileHandler$WaypointCache;", "waypointCache", "Lnet/dfnkt/wayfindr/WayfindrSaveFileHandler$WaypointCache;", "modDir", "Ljava/io/File;", "worldsDir", "WaypointCache", "wayfindr"})
@SourceDebugExtension(value={"SMAP\nWayfindrSaveFileHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WayfindrSaveFileHandler.kt\nnet/dfnkt/wayfindr/WayfindrSaveFileHandler\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,274:1\n222#2:275\n222#2:276\n222#2:277\n205#2:286\n205#2:287\n360#3,7:278\n1#4:285\n*S KotlinDebug\n*F\n+ 1 WayfindrSaveFileHandler.kt\nnet/dfnkt/wayfindr/WayfindrSaveFileHandler\n*L\n155#1:275\n193#1:276\n198#1:277\n219#1:286\n248#1:287\n207#1:278,7\n*E\n"})
public final class WayfindrSaveFileHandler {
    @NotNull
    public static final WayfindrSaveFileHandler INSTANCE = new WayfindrSaveFileHandler();
    private static final Logger logger = LoggerFactory.getLogger((String)"wayfindr");
    @NotNull
    private static final Json json = JsonKt.Json$default(null, WayfindrSaveFileHandler::json$lambda$0, (int)1, null);
    @NotNull
    private static final WaypointCache waypointCache = new WaypointCache();
    @NotNull
    private static final File modDir = new File(System.getProperty("user.dir") + "/wayfindr");
    @NotNull
    private static final File worldsDir = new File(modDir, "worlds");

    private WayfindrSaveFileHandler() {
    }

    private final boolean ensureDirectoriesExist() {
        if (!modDir.exists() && !modDir.mkdirs()) {
            logger.error("Failed to create directory: " + modDir.getAbsolutePath());
            return false;
        }
        if (!worldsDir.exists() && !worldsDir.mkdirs()) {
            logger.error("Failed to create worlds directory: " + worldsDir.getAbsolutePath());
            return false;
        }
        return true;
    }

    @NotNull
    public final String getCurrentWorldName() {
        Object object;
        class_310 client = class_310.method_1551();
        if (client.method_1576() != null) {
            object = client.method_1576();
            if (object == null || (object = object.method_27728()) == null || (object = object.method_150()) == null) {
                object = "default";
            }
        } else if (client.method_1562() != null) {
            class_642 serverInfo = client.method_1558();
            object = serverInfo;
            if (object == null || (object = object.field_3761) == null) {
                object = "default";
            }
        } else {
            object = "default";
        }
        return object;
    }

    @NotNull
    public final File getWorldWaypointFile() {
        String worldName = this.getCurrentWorldName();
        File worldDir = new File(worldsDir, this.sanitizeFileName(worldName));
        if (!worldDir.exists() && !worldDir.mkdirs()) {
            logger.error("Failed to create world directory: " + worldDir.getAbsolutePath());
        }
        return new File(worldDir, "waypoints.json");
    }

    private final String sanitizeFileName(String name) {
        CharSequence charSequence = name;
        Regex regex = new Regex("[\\\\/:*?\"<>|]");
        String string = "_";
        return regex.replace(charSequence, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WaypointManager.Waypoint> loadWaypoints() {
        List list;
        try {
            List list2;
            File waypointFile = this.getWorldWaypointFile();
            String string = waypointFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            List<WaypointManager.Waypoint> list3 = waypointCache.get(string);
            if (list3 != null) {
                List<WaypointManager.Waypoint> it = list3;
                boolean bl = false;
                logger.debug("Cache hit: loaded waypoints from cache for " + INSTANCE.getCurrentWorldName());
                return it;
            }
            if (waypointFile.exists()) {
                String jsonContent = FilesKt.readText$default((File)waypointFile, null, (int)1, null);
                if (!StringsKt.isBlank((CharSequence)jsonContent)) {
                    void var3_8;
                    Json this_$iv = json;
                    boolean $i$f$decodeFromString = false;
                    this_$iv.getSerializersModule();
                    List waypoints = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(WaypointManager.Waypoint.Companion.serializer()), jsonContent);
                    String string2 = waypointFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
                    waypointCache.put(string2, waypoints);
                    logger.debug("Cache miss: loaded waypoints from disk for " + this.getCurrentWorldName());
                    list2 = var3_8;
                } else {
                    logger.info("Waypoint file is empty");
                    list2 = CollectionsKt.emptyList();
                }
            } else {
                logger.info("No waypoint file found at " + waypointFile.getAbsolutePath());
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        catch (Exception e) {
            logger.error("Error loading waypoints", (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void saveWaypoint(@NotNull String waypointJson) {
        Intrinsics.checkNotNullParameter((Object)waypointJson, (String)"waypointJson");
        try {
            List list;
            int existingIndex;
            List waypoints;
            WaypointManager.Waypoint newWaypoint;
            File waypointFile;
            block12: {
                int n;
                if (!this.ensureDirectoriesExist()) {
                    return;
                }
                waypointFile = this.getWorldWaypointFile();
                Json this_$iv = json;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                newWaypoint = (WaypointManager.Waypoint)this_$iv.decodeFromString((DeserializationStrategy)WaypointManager.Waypoint.Companion.serializer(), waypointJson);
                String string = waypointFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                List list2 = waypointCache.get(string);
                if (list2 == null) {
                    if (waypointFile.exists()) {
                        List this_$iv2;
                        try {
                            Json json = WayfindrSaveFileHandler.json;
                            String string$iv = FilesKt.readText$default((File)waypointFile, null, (int)1, null);
                            boolean $i$f$decodeFromString2 = false;
                            this_$iv2.getSerializersModule();
                            this_$iv2 = (List)this_$iv2.decodeFromString((DeserializationStrategy)new ArrayListSerializer(WaypointManager.Waypoint.Companion.serializer()), string$iv);
                        }
                        catch (Exception e) {
                            logger.error("Error reading existing waypoints, creating new file", (Throwable)e);
                            this_$iv2 = CollectionsKt.emptyList();
                        }
                        list2 = this_$iv2;
                    } else {
                        list2 = CollectionsKt.emptyList();
                    }
                }
                List $this$indexOfFirst$iv = waypoints = list2;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    WaypointManager.Waypoint it = (WaypointManager.Waypoint)item$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getId(), (Object)newWaypoint.getId())) {
                        n = index$iv;
                        break block12;
                    }
                    ++index$iv;
                }
                n = existingIndex = -1;
            }
            if (existingIndex >= 0) {
                List $i$f$indexOfFirst;
                logger.warn("Duplicate waypoint ID detected on save; replacing existing entry: " + newWaypoint.getId());
                List it = $i$f$indexOfFirst = CollectionsKt.toMutableList((Collection)waypoints);
                boolean bl = false;
                it.set(existingIndex, newWaypoint);
                list = $i$f$indexOfFirst;
            } else {
                list = CollectionsKt.plus((Collection)waypoints, (Object)newWaypoint);
            }
            List updatedWaypoints = list;
            String string = waypointFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            waypointCache.put(string, updatedWaypoints);
            Json this_$iv = json;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            FilesKt.writeText$default((File)waypointFile, (String)this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(WaypointManager.Waypoint.Companion.serializer()), (Object)updatedWaypoints), null, (int)2, null);
            logger.info("Saved waypoint to " + waypointFile.getAbsolutePath());
        }
        catch (Exception e) {
            logger.error("Failed to save waypoint", (Throwable)e);
        }
    }

    public final void saveAllWaypoints(@NotNull List<WaypointManager.Waypoint> waypoints) {
        Intrinsics.checkNotNullParameter(waypoints, (String)"waypoints");
        try {
            if (!this.ensureDirectoriesExist()) {
                return;
            }
            File waypointFile = this.getWorldWaypointFile();
            String string = waypointFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            waypointCache.put(string, waypoints);
            Json this_$iv = json;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            FilesKt.writeText$default((File)waypointFile, (String)this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(WaypointManager.Waypoint.Companion.serializer()), waypoints), null, (int)2, null);
            logger.info("Saved " + waypoints.size() + " waypoints to " + waypointFile.getAbsolutePath());
        }
        catch (Exception e) {
            logger.error("Failed to save waypoints", (Throwable)e);
        }
    }

    public final void clearCache() {
        waypointCache.clear();
        logger.debug("Waypoint cache cleared");
    }

    public final void invalidateCache(@NotNull String worldName) {
        Intrinsics.checkNotNullParameter((Object)worldName, (String)"worldName");
        File worldDir = new File(worldsDir, this.sanitizeFileName(worldName));
        File waypointFile = new File(worldDir, "waypoints.json");
        String string = waypointFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        waypointCache.invalidate(string);
        logger.debug("Cache invalidated for world: " + worldName);
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u0015\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R0\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00160\u0015j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0016`\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lnet/dfnkt/wayfindr/WayfindrSaveFileHandler$WaypointCache;", "", "<init>", "()V", "", "key", "", "Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "get", "(Ljava/lang/String;)Ljava/util/List;", "waypoints", "", "put", "(Ljava/lang/String;Ljava/util/List;)V", "clear", "invalidate", "(Ljava/lang/String;)V", "", "maxCacheSize", "I", "cacheExpirationMs", "Ljava/util/LinkedHashMap;", "Lnet/dfnkt/wayfindr/WayfindrSaveFileHandler$WaypointCache$CacheEntry;", "Lkotlin/collections/LinkedHashMap;", "cache", "Ljava/util/LinkedHashMap;", "CacheEntry", "wayfindr"})
    private static final class WaypointCache {
        private final int maxCacheSize;
        private final int cacheExpirationMs;
        @NotNull
        private final LinkedHashMap<String, CacheEntry> cache = new LinkedHashMap(16, 0.75f, true);

        public WaypointCache() {
            this.maxCacheSize = 10;
            this.cacheExpirationMs = 600000;
        }

        @Nullable
        public final List<WaypointManager.Waypoint> get(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            CacheEntry cacheEntry = this.cache.get(key);
            if (cacheEntry == null) {
                return null;
            }
            CacheEntry entry = cacheEntry;
            if (System.currentTimeMillis() - entry.getTimestamp() > (long)this.cacheExpirationMs) {
                this.cache.remove(key);
                return null;
            }
            return entry.getWaypoints();
        }

        public final void put(@NotNull String key, @NotNull List<WaypointManager.Waypoint> waypoints) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(waypoints, (String)"waypoints");
            ((Map)this.cache).put(key, new CacheEntry(waypoints, 0L, 2, null));
            while (this.cache.size() > this.maxCacheSize) {
                Set<String> set = this.cache.keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
                Object object = CollectionsKt.first((Iterable)set);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                String oldestKey = (String)object;
                this.cache.remove(oldestKey);
                logger.debug("Cache eviction: removed waypoints for " + oldestKey);
            }
        }

        public final void clear() {
            this.cache.clear();
        }

        public final void invalidate(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.cache.remove(key);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ*\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0019\u001a\u0004\b\u001a\u0010\nR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001b\u001a\u0004\b\u001c\u0010\f\u00a8\u0006\u001d"}, d2={"Lnet/dfnkt/wayfindr/WayfindrSaveFileHandler$WaypointCache$CacheEntry;", "", "", "Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "waypoints", "", "timestamp", "<init>", "(Ljava/util/List;J)V", "component1", "()Ljava/util/List;", "component2", "()J", "copy", "(Ljava/util/List;J)Lnet/dfnkt/wayfindr/WayfindrSaveFileHandler$WaypointCache$CacheEntry;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getWaypoints", "J", "getTimestamp", "wayfindr"})
        private static final class CacheEntry {
            @NotNull
            private final List<WaypointManager.Waypoint> waypoints;
            private final long timestamp;

            public CacheEntry(@NotNull List<WaypointManager.Waypoint> waypoints, long timestamp) {
                Intrinsics.checkNotNullParameter(waypoints, (String)"waypoints");
                this.waypoints = waypoints;
                this.timestamp = timestamp;
            }

            public /* synthetic */ CacheEntry(List list, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    l = System.currentTimeMillis();
                }
                this(list, l);
            }

            @NotNull
            public final List<WaypointManager.Waypoint> getWaypoints() {
                return this.waypoints;
            }

            public final long getTimestamp() {
                return this.timestamp;
            }

            @NotNull
            public final List<WaypointManager.Waypoint> component1() {
                return this.waypoints;
            }

            public final long component2() {
                return this.timestamp;
            }

            @NotNull
            public final CacheEntry copy(@NotNull List<WaypointManager.Waypoint> waypoints, long timestamp) {
                Intrinsics.checkNotNullParameter(waypoints, (String)"waypoints");
                return new CacheEntry(waypoints, timestamp);
            }

            public static /* synthetic */ CacheEntry copy$default(CacheEntry cacheEntry, List list, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    list = cacheEntry.waypoints;
                }
                if ((n & 2) != 0) {
                    l = cacheEntry.timestamp;
                }
                return cacheEntry.copy(list, l);
            }

            @NotNull
            public String toString() {
                return "CacheEntry(waypoints=" + this.waypoints + ", timestamp=" + this.timestamp + ")";
            }

            public int hashCode() {
                int result = ((Object)this.waypoints).hashCode();
                result = result * 31 + Long.hashCode(this.timestamp);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CacheEntry)) {
                    return false;
                }
                CacheEntry cacheEntry = (CacheEntry)other;
                if (!Intrinsics.areEqual(this.waypoints, cacheEntry.waypoints)) {
                    return false;
                }
                return this.timestamp == cacheEntry.timestamp;
            }
        }
    }
}

