/*
 * Decompiled with CFR 0.152.
 */
package net.dfnkt.wayfindr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.modules.SerializersModuleBuilder;
import net.dfnkt.wayfindr.UUIDSerializer;
import net.dfnkt.wayfindr.WayfindrNetworkClient;
import net.dfnkt.wayfindr.WayfindrSaveFileHandler;
import net.dfnkt.wayfindr.WaypointManager$SerializableVec3d$;
import net.dfnkt.wayfindr.WaypointManager$Waypoint$;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_243;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002TUB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J;\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0014J\u0015\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b \u0010!J\u0015\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\"\u0010\u0018J\r\u0010#\u001a\u00020\u0004\u00a2\u0006\u0004\b#\u0010\u0003J\u000f\u0010$\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010&\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b&\u0010\u0018J\u0015\u0010'\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b'\u0010(J\r\u0010)\u001a\u00020\u000b\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010,\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\t\u00a2\u0006\u0004\b,\u0010-J\r\u0010.\u001a\u00020\u0007\u00a2\u0006\u0004\b.\u0010/J\u001b\u00101\u001a\u00020\u00042\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00100\u001b\u00a2\u0006\u0004\b1\u00102J\u0015\u00103\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b3\u0010\u0018J\u001d\u00104\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b4\u00105J\u001d\u00107\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u0007\u00a2\u0006\u0004\b7\u00108R\u001c\u0010;\u001a\n :*\u0004\u0018\u000109098\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0014\u0010>\u001a\u00020=8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0014\u0010A\u001a\u00020@8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0014\u0010D\u001a\u00020C8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010ER\u0014\u0010G\u001a\u00020F8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bG\u0010HR0\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00100I2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00100I8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bK\u0010L\u001a\u0004\bM\u0010\u001dR\u0018\u0010N\u001a\u0004\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u0010OR\u0016\u0010P\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u0016\u0010R\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010S\u00a8\u0006V"}, d2={"Lnet/dfnkt/wayfindr/WaypointManager;", "", "<init>", "()V", "", "initializeWaypoints", "loadWaypointsForCurrentWorld", "", "name", "Lnet/minecraft/class_243;", "position", "", "color", "dimension", "", "visible", "Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "addWaypoint", "(Ljava/lang/String;Lnet/minecraft/class_243;ILjava/lang/String;Z)Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "waypoint", "(Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;)Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "Ljava/util/UUID;", "id", "removeWaypoint", "(Ljava/util/UUID;)Z", "updateWaypoint", "(Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;)Z", "", "getAllWaypoints", "()Ljava/util/List;", "getWaypoint", "(Ljava/util/UUID;)Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "getWaypointByName", "(Ljava/lang/String;)Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "setNavigationTarget", "clearNavigationTarget", "getNavigationTarget", "()Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "isNavigationTarget", "setWaypointListScrollPosition", "(I)V", "getWaypointListScrollPosition", "()I", "playerPos", "isWithinDeadzone", "(Lnet/minecraft/class_243;)Z", "getCurrentWorldName", "()Ljava/lang/String;", "newWaypoints", "replaceAllWaypoints", "(Ljava/util/List;)V", "toggleWaypointVisibility", "changeWaypointColor", "(Ljava/util/UUID;I)Z", "newName", "renameWaypoint", "(Ljava/util/UUID;Ljava/lang/String;)Z", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Lkotlinx/serialization/modules/SerializersModule;", "waypointSerializers", "Lkotlinx/serialization/modules/SerializersModule;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "Lnet/dfnkt/wayfindr/WayfindrSaveFileHandler;", "saveHandler", "Lnet/dfnkt/wayfindr/WayfindrSaveFileHandler;", "", "DEADZONE_THRESHOLD", "D", "", "value", "waypoints", "Ljava/util/List;", "getWaypoints", "navigationTarget", "Ljava/util/UUID;", "waypointListScrollPosition", "I", "currentWorldName", "Ljava/lang/String;", "Waypoint", "SerializableVec3d", "wayfindr"})
@SourceDebugExtension(value={"SMAP\nWayfindrWaypointManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WayfindrWaypointManager.kt\nnet/dfnkt/wayfindr/WaypointManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 SerializersModuleBuilders.kt\nkotlinx/serialization/modules/SerializersModuleBuildersKt\n*L\n1#1,399:1\n360#2,7:400\n360#2,7:408\n205#3:407\n1#4:415\n31#5,3:416\n*S KotlinDebug\n*F\n+ 1 WayfindrWaypointManager.kt\nnet/dfnkt/wayfindr/WaypointManager\n*L\n130#1:400,7\n168#1:408,7\n137#1:407\n21#1:416,3\n*E\n"})
public final class WaypointManager {
    @NotNull
    public static final WaypointManager INSTANCE;
    private static final Logger logger;
    @NotNull
    private static final SerializersModule waypointSerializers;
    @NotNull
    private static final Json json;
    @NotNull
    private static final WayfindrSaveFileHandler saveHandler;
    public static final double DEADZONE_THRESHOLD = 3.0;
    @NotNull
    private static List<Waypoint> waypoints;
    @Nullable
    private static UUID navigationTarget;
    private static int waypointListScrollPosition;
    @NotNull
    private static String currentWorldName;

    private WaypointManager() {
    }

    @NotNull
    public final List<Waypoint> getWaypoints() {
        return waypoints;
    }

    public final void initializeWaypoints() {
        ClientLifecycleEvents.CLIENT_STARTED.register(WaypointManager::initializeWaypoints$lambda$2);
        this.loadWaypointsForCurrentWorld();
    }

    public final void loadWaypointsForCurrentWorld() {
        String newWorldName = saveHandler.getCurrentWorldName();
        if (!Intrinsics.areEqual((Object)currentWorldName, (Object)newWorldName)) {
            logger.info("World changed from '" + currentWorldName + "' to '" + newWorldName + "', reloading waypoints");
            currentWorldName = newWorldName;
            navigationTarget = null;
        }
        List<Waypoint> loaded = saveHandler.loadWaypoints();
        LinkedHashMap map = new LinkedHashMap();
        for (Waypoint wp : loaded) {
            ((Map)map).put(wp.getId(), wp);
        }
        Collection collection = map.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        List deduped = CollectionsKt.toList((Iterable)collection);
        waypoints = CollectionsKt.toMutableList((Collection)deduped);
        if (deduped.size() != loaded.size()) {
            logger.warn("Detected " + (loaded.size() - deduped.size()) + " duplicate waypoint(s) by ID in '" + currentWorldName + "'; cleaned and resaved");
            saveHandler.saveAllWaypoints(waypoints);
        }
        logger.info("Loaded " + waypoints.size() + " waypoints for world '" + currentWorldName + "'");
    }

    @NotNull
    public final Waypoint addWaypoint(@NotNull String name, @NotNull class_243 position, int color, @NotNull String dimension, boolean visible) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Waypoint waypoint = new Waypoint(name, new SerializableVec3d(position.field_1352, position.field_1351, position.field_1350), color, dimension, visible, false, null, null, 224, null);
        return this.addWaypoint(waypoint);
    }

    public static /* synthetic */ Waypoint addWaypoint$default(WaypointManager waypointManager, String string, class_243 class_2432, int n, String string2, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0xFF0000;
        }
        if ((n2 & 8) != 0) {
            string2 = "minecraft:overworld";
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        return waypointManager.addWaypoint(string, class_2432, n, string2, bl);
    }

    @NotNull
    public final Waypoint addWaypoint(@NotNull Waypoint waypoint) {
        int existingIndex;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)waypoint, (String)"waypoint");
            List<Waypoint> $this$indexOfFirst$iv = waypoints;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Waypoint> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Waypoint item$iv;
                Waypoint it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)waypoint.getId())) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = existingIndex = -1;
        }
        if (existingIndex >= 0) {
            waypoints.set(existingIndex, waypoint);
            saveHandler.saveAllWaypoints(waypoints);
        } else {
            waypoints.add(waypoint);
            Json this_$iv = json;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            saveHandler.saveWaypoint(this_$iv.encodeToString((SerializationStrategy)Waypoint.Companion.serializer(), (Object)waypoint));
        }
        return waypoint;
    }

    public final boolean removeWaypoint(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Waypoint waypoint = this.getWaypoint(id);
        if (waypoint == null) {
            return false;
        }
        Waypoint waypoint2 = waypoint;
        waypoints.remove(waypoint2);
        if (Intrinsics.areEqual((Object)navigationTarget, (Object)id)) {
            navigationTarget = null;
        }
        saveHandler.saveAllWaypoints(waypoints);
        return true;
    }

    public final boolean updateWaypoint(@NotNull Waypoint waypoint) {
        int index;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter((Object)waypoint, (String)"waypoint");
            List<Waypoint> $this$indexOfFirst$iv = waypoints;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<Waypoint> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Waypoint item$iv;
                Waypoint it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getId(), (Object)waypoint.getId())) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index < 0) {
            return false;
        }
        waypoints.set(index, waypoint);
        saveHandler.saveAllWaypoints(waypoints);
        return true;
    }

    @NotNull
    public final List<Waypoint> getAllWaypoints() {
        return CollectionsKt.toList((Iterable)waypoints);
    }

    @Nullable
    public final Waypoint getWaypoint(@NotNull UUID id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = waypoints;
            for (Object t : iterable) {
                Waypoint it = (Waypoint)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Waypoint getWaypointByName(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable iterable = waypoints;
            for (Object t : iterable) {
                Waypoint it = (Waypoint)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean setNavigationTarget(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.getWaypoint(id) == null) {
            return false;
        }
        navigationTarget = id;
        return true;
    }

    public final void clearNavigationTarget() {
        navigationTarget = null;
    }

    @Nullable
    public final Waypoint getNavigationTarget() {
        Waypoint waypoint;
        UUID uUID = navigationTarget;
        if (uUID != null) {
            UUID it = uUID;
            boolean bl = false;
            waypoint = INSTANCE.getWaypoint(it);
        } else {
            waypoint = null;
        }
        return waypoint;
    }

    public final boolean isNavigationTarget(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Intrinsics.areEqual((Object)navigationTarget, (Object)id);
    }

    public final void setWaypointListScrollPosition(int position) {
        waypointListScrollPosition = position;
    }

    public final int getWaypointListScrollPosition() {
        return waypointListScrollPosition;
    }

    public final boolean isWithinDeadzone(@NotNull class_243 playerPos) {
        Intrinsics.checkNotNullParameter((Object)playerPos, (String)"playerPos");
        Waypoint waypoint = this.getNavigationTarget();
        if (waypoint == null) {
            return false;
        }
        Waypoint target = waypoint;
        class_243 waypointPos = target.getPosition();
        boolean withinX = Math.abs(playerPos.field_1352 - waypointPos.field_1352) <= 3.0;
        boolean withinY = Math.abs(playerPos.field_1351 - waypointPos.field_1351) <= 3.0;
        boolean withinZ = Math.abs(playerPos.field_1350 - waypointPos.field_1350) <= 3.0;
        return withinX && withinY && withinZ;
    }

    @NotNull
    public final String getCurrentWorldName() {
        return currentWorldName;
    }

    public final void replaceAllWaypoints(@NotNull List<Waypoint> newWaypoints) {
        Intrinsics.checkNotNullParameter(newWaypoints, (String)"newWaypoints");
        waypoints = CollectionsKt.toMutableList((Collection)newWaypoints);
        saveHandler.saveAllWaypoints(waypoints);
    }

    public final boolean toggleWaypointVisibility(@NotNull UUID id) {
        Waypoint waypoint;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Waypoint waypoint2 = this.getWaypoint(id);
        if (waypoint2 == null) {
            return false;
        }
        waypoint.setVisible(!(waypoint = waypoint2).getVisible());
        saveHandler.saveAllWaypoints(waypoints);
        return true;
    }

    public final boolean changeWaypointColor(@NotNull UUID id, int color) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Waypoint waypoint = this.getWaypoint(id);
        if (waypoint == null) {
            return false;
        }
        Waypoint waypoint2 = waypoint;
        waypoint2.setColor(color);
        saveHandler.saveAllWaypoints(waypoints);
        return true;
    }

    public final boolean renameWaypoint(@NotNull UUID id, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Waypoint waypoint = this.getWaypoint(id);
        if (waypoint == null) {
            return false;
        }
        Waypoint waypoint2 = waypoint;
        waypoint2.setName(newName);
        saveHandler.saveAllWaypoints(waypoints);
        if (waypoint2.isShared()) {
            WayfindrNetworkClient.INSTANCE.sendWaypointUpdateToServer(waypoint2);
        }
        return true;
    }

    private static final Unit json$lambda$1(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrint(true);
        $this$Json.setSerializersModule(waypointSerializers);
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    private static final void initializeWaypoints$lambda$2(class_310 client) {
        INSTANCE.loadWaypointsForCurrentWorld();
    }

    static {
        SerializersModuleBuilder builder$iv;
        INSTANCE = new WaypointManager();
        logger = LoggerFactory.getLogger((String)"wayfindr");
        boolean $i$f$SerializersModule = false;
        SerializersModuleBuilder $this$waypointSerializers_u24lambda_u240 = builder$iv = new SerializersModuleBuilder();
        boolean bl = false;
        $this$waypointSerializers_u24lambda_u240.contextual(Reflection.getOrCreateKotlinClass(UUID.class), (KSerializer)UUIDSerializer.INSTANCE);
        waypointSerializers = builder$iv.build();
        json = JsonKt.Json$default(null, WaypointManager::json$lambda$1, (int)1, null);
        saveHandler = WayfindrSaveFileHandler.INSTANCE;
        waypoints = new ArrayList();
        currentWorldName = "default";
    }

    @Serializable
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0087\b\u0018\u0000 ,2\u00020\u0001:\u0002-,B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007B3\b\u0010\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0006\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0011J.\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0018\u001a\u00020\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ'\u0010'\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u00002\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"H\u0001\u00a2\u0006\u0004\b%\u0010&R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010(\u001a\u0004\b)\u0010\u0011R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010(\u001a\u0004\b*\u0010\u0011R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010(\u001a\u0004\b+\u0010\u0011\u00a8\u0006."}, d2={"Lnet/dfnkt/wayfindr/WaypointManager$SerializableVec3d;", "", "", "x", "y", "z", "<init>", "(DDD)V", "", "seen0", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "(IDDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "Lnet/minecraft/class_243;", "toVec3d", "()Lnet/minecraft/class_243;", "component1", "()D", "component2", "component3", "copy", "(DDD)Lnet/dfnkt/wayfindr/WaypointManager$SerializableVec3d;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self$wayfindr", "(Lnet/dfnkt/wayfindr/WaypointManager$SerializableVec3d;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "write$Self", "D", "getX", "getY", "getZ", "Companion", ".serializer", "wayfindr"})
    public static final class SerializableVec3d {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final double x;
        private final double y;
        private final double z;

        public SerializableVec3d(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public final double getZ() {
            return this.z;
        }

        @NotNull
        public final class_243 toVec3d() {
            return new class_243(this.x, this.y, this.z);
        }

        public final double component1() {
            return this.x;
        }

        public final double component2() {
            return this.y;
        }

        public final double component3() {
            return this.z;
        }

        @NotNull
        public final SerializableVec3d copy(double x, double y, double z) {
            return new SerializableVec3d(x, y, z);
        }

        public static /* synthetic */ SerializableVec3d copy$default(SerializableVec3d serializableVec3d, double d, double d2, double d3, int n, Object object) {
            if ((n & 1) != 0) {
                d = serializableVec3d.x;
            }
            if ((n & 2) != 0) {
                d2 = serializableVec3d.y;
            }
            if ((n & 4) != 0) {
                d3 = serializableVec3d.z;
            }
            return serializableVec3d.copy(d, d2, d3);
        }

        @NotNull
        public String toString() {
            return "SerializableVec3d(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.x);
            result = result * 31 + Double.hashCode(this.y);
            result = result * 31 + Double.hashCode(this.z);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializableVec3d)) {
                return false;
            }
            SerializableVec3d serializableVec3d = (SerializableVec3d)other;
            if (Double.compare(this.x, serializableVec3d.x) != 0) {
                return false;
            }
            if (Double.compare(this.y, serializableVec3d.y) != 0) {
                return false;
            }
            return Double.compare(this.z, serializableVec3d.z) == 0;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$wayfindr(SerializableVec3d self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeDoubleElement(serialDesc, 0, self.x);
            output.encodeDoubleElement(serialDesc, 1, self.y);
            output.encodeDoubleElement(serialDesc, 2, self.z);
        }

        public /* synthetic */ SerializableVec3d(int seen0, double x, double y, double z, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)SerializableVec3d$$serializer.INSTANCE.getDescriptor());
            }
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/dfnkt/wayfindr/WaypointManager$SerializableVec3d$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lnet/dfnkt/wayfindr/WaypointManager$SerializableVec3d;", "serializer", "()Lkotlinx/serialization/KSerializer;", "wayfindr"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<SerializableVec3d> serializer() {
                return (KSerializer)SerializableVec3d$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Serializable
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u001f\b\u0087\b\u0018\u0000 N2\u00020\u0001:\u0002ONBO\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010Be\b\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0006\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u000f\u0010\u0014J\r\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u0019J\u0010\u0010\u001f\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010!\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b!\u0010 J\u0012\u0010\"\u001a\u0004\u0018\u00010\fH\u00c6\u0003\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010$\u001a\u00020\fH\u00c6\u0003\u00a2\u0006\u0004\b$\u0010#Jb\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u000e\u001a\u00020\fH\u00c6\u0001\u00a2\u0006\u0004\b%\u0010&J\u001a\u0010(\u001a\u00020\t2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b(\u0010)J\u0010\u0010*\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b*\u0010\u001dJ\u0010\u0010+\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b+\u0010\u0019J'\u00104\u001a\u0002012\u0006\u0010,\u001a\u00020\u00002\u0006\u0010.\u001a\u00020-2\u0006\u00100\u001a\u00020/H\u0001\u00a2\u0006\u0004\b2\u00103R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u00105\u001a\u0004\b6\u0010\u0019\"\u0004\b7\u00108R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u00109\u001a\u0004\b\u0016\u0010\u001bR\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010:\u001a\u0004\b;\u0010\u001d\"\u0004\b<\u0010=R\"\u0010\b\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u00105\u001a\u0004\b>\u0010\u0019\"\u0004\b?\u00108R\"\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\n\u0010@\u001a\u0004\bA\u0010 \"\u0004\bB\u0010CR\"\u0010\u000b\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010@\u001a\u0004\b\u000b\u0010 \"\u0004\bD\u0010CR*\u0010\r\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0018\n\u0004\b\r\u0010E\u0012\u0004\bI\u0010J\u001a\u0004\bF\u0010#\"\u0004\bG\u0010HR(\u0010\u000e\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0018\n\u0004\b\u000e\u0010E\u0012\u0004\bM\u0010J\u001a\u0004\bK\u0010#\"\u0004\bL\u0010H\u00a8\u0006P"}, d2={"Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "", "", "name", "Lnet/dfnkt/wayfindr/WaypointManager$SerializableVec3d;", "position", "", "color", "dimension", "", "visible", "isShared", "Ljava/util/UUID;", "owner", "id", "<init>", "(Ljava/lang/String;Lnet/dfnkt/wayfindr/WaypointManager$SerializableVec3d;ILjava/lang/String;ZZLjava/util/UUID;Ljava/util/UUID;)V", "seen0", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "(ILjava/lang/String;Lnet/dfnkt/wayfindr/WaypointManager$SerializableVec3d;ILjava/lang/String;ZZLjava/util/UUID;Ljava/util/UUID;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "Lnet/minecraft/class_243;", "getPosition", "()Lnet/minecraft/class_243;", "component1", "()Ljava/lang/String;", "component2", "()Lnet/dfnkt/wayfindr/WaypointManager$SerializableVec3d;", "component3", "()I", "component4", "component5", "()Z", "component6", "component7", "()Ljava/util/UUID;", "component8", "copy", "(Ljava/lang/String;Lnet/dfnkt/wayfindr/WaypointManager$SerializableVec3d;ILjava/lang/String;ZZLjava/util/UUID;Ljava/util/UUID;)Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self$wayfindr", "(Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "write$Self", "Ljava/lang/String;", "getName", "setName", "(Ljava/lang/String;)V", "Lnet/dfnkt/wayfindr/WaypointManager$SerializableVec3d;", "I", "getColor", "setColor", "(I)V", "getDimension", "setDimension", "Z", "getVisible", "setVisible", "(Z)V", "setShared", "Ljava/util/UUID;", "getOwner", "setOwner", "(Ljava/util/UUID;)V", "getOwner$annotations", "()V", "getId", "setId", "getId$annotations", "Companion", ".serializer", "wayfindr"})
    public static final class Waypoint {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private String name;
        @NotNull
        private final SerializableVec3d position;
        private int color;
        @NotNull
        private String dimension;
        private boolean visible;
        private boolean isShared;
        @Nullable
        private UUID owner;
        @NotNull
        private UUID id;

        public Waypoint(@NotNull String name, @NotNull SerializableVec3d position, int color, @NotNull String dimension, boolean visible, boolean isShared, @Nullable UUID owner, @NotNull UUID id) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.name = name;
            this.position = position;
            this.color = color;
            this.dimension = dimension;
            this.visible = visible;
            this.isShared = isShared;
            this.owner = owner;
            this.id = id;
        }

        public /* synthetic */ Waypoint(String string, SerializableVec3d serializableVec3d, int n, String string2, boolean bl, boolean bl2, UUID uUID, UUID uUID2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x20) != 0) {
                bl2 = false;
            }
            if ((n2 & 0x40) != 0) {
                uUID = null;
            }
            if ((n2 & 0x80) != 0) {
                uUID2 = UUID.randomUUID();
            }
            this(string, serializableVec3d, n, string2, bl, bl2, uUID, uUID2);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @NotNull
        public final SerializableVec3d getPosition() {
            return this.position;
        }

        public final int getColor() {
            return this.color;
        }

        public final void setColor(int n) {
            this.color = n;
        }

        @NotNull
        public final String getDimension() {
            return this.dimension;
        }

        public final void setDimension(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.dimension = string;
        }

        public final boolean getVisible() {
            return this.visible;
        }

        public final void setVisible(boolean bl) {
            this.visible = bl;
        }

        public final boolean isShared() {
            return this.isShared;
        }

        public final void setShared(boolean bl) {
            this.isShared = bl;
        }

        @Nullable
        public final UUID getOwner() {
            return this.owner;
        }

        public final void setOwner(@Nullable UUID uUID) {
            this.owner = uUID;
        }

        @Serializable(with=UUIDSerializer.class)
        public static /* synthetic */ void getOwner$annotations() {
        }

        @NotNull
        public final UUID getId() {
            return this.id;
        }

        public final void setId(@NotNull UUID uUID) {
            Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
            this.id = uUID;
        }

        @Serializable(with=UUIDSerializer.class)
        public static /* synthetic */ void getId$annotations() {
        }

        @NotNull
        public final class_243 getPosition() {
            return this.position.toVec3d();
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final SerializableVec3d component2() {
            return this.position;
        }

        public final int component3() {
            return this.color;
        }

        @NotNull
        public final String component4() {
            return this.dimension;
        }

        public final boolean component5() {
            return this.visible;
        }

        public final boolean component6() {
            return this.isShared;
        }

        @Nullable
        public final UUID component7() {
            return this.owner;
        }

        @NotNull
        public final UUID component8() {
            return this.id;
        }

        @NotNull
        public final Waypoint copy(@NotNull String name, @NotNull SerializableVec3d position, int color, @NotNull String dimension, boolean visible, boolean isShared, @Nullable UUID owner, @NotNull UUID id) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new Waypoint(name, position, color, dimension, visible, isShared, owner, id);
        }

        public static /* synthetic */ Waypoint copy$default(Waypoint waypoint, String string, SerializableVec3d serializableVec3d, int n, String string2, boolean bl, boolean bl2, UUID uUID, UUID uUID2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = waypoint.name;
            }
            if ((n2 & 2) != 0) {
                serializableVec3d = waypoint.position;
            }
            if ((n2 & 4) != 0) {
                n = waypoint.color;
            }
            if ((n2 & 8) != 0) {
                string2 = waypoint.dimension;
            }
            if ((n2 & 0x10) != 0) {
                bl = waypoint.visible;
            }
            if ((n2 & 0x20) != 0) {
                bl2 = waypoint.isShared;
            }
            if ((n2 & 0x40) != 0) {
                uUID = waypoint.owner;
            }
            if ((n2 & 0x80) != 0) {
                uUID2 = waypoint.id;
            }
            return waypoint.copy(string, serializableVec3d, n, string2, bl, bl2, uUID, uUID2);
        }

        @NotNull
        public String toString() {
            return "Waypoint(name=" + this.name + ", position=" + this.position + ", color=" + this.color + ", dimension=" + this.dimension + ", visible=" + this.visible + ", isShared=" + this.isShared + ", owner=" + this.owner + ", id=" + this.id + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.position.hashCode();
            result = result * 31 + Integer.hashCode(this.color);
            result = result * 31 + this.dimension.hashCode();
            result = result * 31 + Boolean.hashCode(this.visible);
            result = result * 31 + Boolean.hashCode(this.isShared);
            result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
            result = result * 31 + this.id.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Waypoint)) {
                return false;
            }
            Waypoint waypoint = (Waypoint)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)waypoint.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.position, (Object)waypoint.position)) {
                return false;
            }
            if (this.color != waypoint.color) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dimension, (Object)waypoint.dimension)) {
                return false;
            }
            if (this.visible != waypoint.visible) {
                return false;
            }
            if (this.isShared != waypoint.isShared) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.owner, (Object)waypoint.owner)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.id, (Object)waypoint.id);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$wayfindr(Waypoint self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.name);
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)SerializableVec3d$$serializer.INSTANCE, (Object)self.position);
            output.encodeIntElement(serialDesc, 2, self.color);
            output.encodeStringElement(serialDesc, 3, self.dimension);
            output.encodeBooleanElement(serialDesc, 4, self.visible);
            if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.isShared) {
                output.encodeBooleanElement(serialDesc, 5, self.isShared);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 6) ? true : self.owner != null) {
                output.encodeNullableSerializableElement(serialDesc, 6, (SerializationStrategy)UUIDSerializer.INSTANCE, (Object)self.owner);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 7) ? true : !Intrinsics.areEqual((Object)self.id, (Object)UUID.randomUUID())) {
                output.encodeSerializableElement(serialDesc, 7, (SerializationStrategy)UUIDSerializer.INSTANCE, (Object)self.id);
            }
        }

        public /* synthetic */ Waypoint(int seen0, String name, SerializableVec3d position, int color, String dimension, boolean visible, boolean isShared, UUID owner, UUID id, SerializationConstructorMarker serializationConstructorMarker) {
            if (31 != (0x1F & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)31, (SerialDescriptor)Waypoint$$serializer.INSTANCE.getDescriptor());
            }
            this.name = name;
            this.position = position;
            this.color = color;
            this.dimension = dimension;
            this.visible = visible;
            this.isShared = (seen0 & 0x20) == 0 ? false : isShared;
            this.owner = (seen0 & 0x40) == 0 ? null : owner;
            this.id = (seen0 & 0x80) == 0 ? UUID.randomUUID() : id;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/dfnkt/wayfindr/WaypointManager$Waypoint$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lnet/dfnkt/wayfindr/WaypointManager$Waypoint;", "serializer", "()Lkotlinx/serialization/KSerializer;", "wayfindr"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Waypoint> serializer() {
                return (KSerializer)Waypoint$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

