/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadencounters.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.oxcodsnet.roadarchitect.api.storage.PersistentStore;
import org.slf4j.Logger;

public final class TriggerStorage {
    private static final String LIST = "markers";
    private static final String ID = "id";
    private static final String POS = "pos";
    private static final String TYPE = "type";
    private static final String RADIUS = "radius";
    private static final String DATA = "data";
    private static final String NEXT_READY = "next_ready";
    private final ResourceLocation storeKey;
    private final Function<ServerLevel, PersistentStore> store;
    private final Logger logger;
    private final Map<ServerLevel, State> states = new WeakHashMap<ServerLevel, State>();

    public TriggerStorage(ResourceLocation storeKey, Function<ServerLevel, PersistentStore> store, Logger logger) {
        this.storeKey = storeKey;
        this.store = store;
        this.logger = logger;
    }

    public static TriggerStorage create(Function<ServerLevel, PersistentStore> store, Logger logger, ResourceLocation addonId) {
        return new TriggerStorage(ResourceLocation.fromNamespaceAndPath((String)addonId.getNamespace(), (String)(addonId.getPath() + "_triggers")), store, logger);
    }

    private State state(ServerLevel world) {
        return this.states.computeIfAbsent(world, this::load);
    }

    private State load(ServerLevel world) {
        State s = new State();
        Optional opt = this.store.apply(world).get(this.storeKey);
        if (opt.isEmpty()) {
            return s;
        }
        CompoundTag tag = (CompoundTag)opt.get();
        ListTag list = tag.getList(LIST, 10);
        for (int i = 0; i < list.size(); ++i) {
            long nextReady;
            CompoundTag e = list.getCompound(i);
            UUID id = e.getUUID(ID);
            BlockPos pos = BlockPos.of((long)e.getLong(POS));
            ResourceLocation type = ResourceLocation.tryParse((String)e.getString(TYPE));
            int radius = e.getInt(RADIUS);
            CompoundTag data = e.getCompound(DATA);
            long l = nextReady = e.contains(NEXT_READY) ? e.getLong(NEXT_READY) : 0L;
            if (type == null) continue;
            TriggerStorage.index(s, new Marker(id, pos, type, radius, data.copy(), nextReady));
        }
        return s;
    }

    private void save(ServerLevel world, State s) {
        ListTag list = new ListTag();
        for (Marker m : s.byId.values()) {
            CompoundTag e = new CompoundTag();
            e.putUUID(ID, m.id());
            e.putLong(POS, m.pos().asLong());
            e.putString(TYPE, m.type().toString());
            e.putInt(RADIUS, m.radius());
            e.put(DATA, (Tag)m.data().copy());
            if (m.nextReadyTick() > 0L) {
                e.putLong(NEXT_READY, m.nextReadyTick());
            }
            list.add((Object)e);
        }
        CompoundTag root = new CompoundTag();
        root.put(LIST, (Tag)list);
        this.store.apply(world).put(this.storeKey, root);
    }

    private static void index(State s, Marker m) {
        s.byId.put(m.id(), m);
        s.byChunk.computeIfAbsent(new ChunkPos(m.pos()), c -> ConcurrentHashMap.newKeySet()).add(m.id());
    }

    public void addMarker(ServerLevel world, BlockPos pos, ResourceLocation type, int radius, CompoundTag data) {
        State s = this.state(world);
        UUID id = UUID.randomUUID();
        TriggerStorage.index(s, new Marker(id, pos.immutable(), type, radius, data == null ? new CompoundTag() : data.copy(), 0L));
        this.save(world, s);
        this.logger.debug("Added marker {} at {} (r={})", new Object[]{type, pos, radius});
    }

    public List<Marker> findMarkersNear(ServerLevel world, BlockPos pos, int maxSearchRadiusBlocks) {
        State s = this.state(world);
        if (s.byId.isEmpty()) {
            return List.of();
        }
        int cx = pos.getX() >> 4;
        int cz = pos.getZ() >> 4;
        int rChunks = Math.max(1, Math.min(8, maxSearchRadiusBlocks + 15 >> 4));
        long now = world.getGameTime();
        ArrayList<Marker> out = new ArrayList<Marker>();
        for (int dx = -rChunks; dx <= rChunks; ++dx) {
            for (int dz = -rChunks; dz <= rChunks; ++dz) {
                Set<UUID> ids = s.byChunk.get(new ChunkPos(cx + dx, cz + dz));
                if (ids == null || ids.isEmpty()) continue;
                for (UUID id : ids) {
                    int rz;
                    int rx;
                    Marker m = s.byId.get(id);
                    if (m == null || m.nextReadyTick() > now || (long)(rx = m.pos().getX() - pos.getX()) * (long)rx + (long)(rz = m.pos().getZ() - pos.getZ()) * (long)rz > (long)m.radius() * (long)m.radius()) continue;
                    out.add(m);
                }
            }
        }
        return out;
    }

    public void markTriggered(ServerLevel world, Collection<UUID> ids, long cooldownTicks) {
        if (ids.isEmpty()) {
            return;
        }
        State s = this.state(world);
        long until = world.getGameTime() + Math.max(0L, cooldownTicks);
        for (UUID id : ids) {
            Marker m = s.byId.get(id);
            if (m == null) continue;
            s.byId.put(id, new Marker(m.id(), m.pos(), m.type(), m.radius(), m.data(), until));
        }
        this.save(world, s);
    }

    private static final class State {
        final Map<UUID, Marker> byId = new ConcurrentHashMap<UUID, Marker>();
        final Map<ChunkPos, Set<UUID>> byChunk = new ConcurrentHashMap<ChunkPos, Set<UUID>>();

        private State() {
        }
    }

    public record Marker(UUID id, BlockPos pos, ResourceLocation type, int radius, CompoundTag data, long nextReadyTick) {
    }
}

