/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadencounters;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_3732;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.oxcodsnet.roadarchitect.api.addon.AddonContext;
import net.oxcodsnet.roadarchitect.api.addon.RoadAddon;
import net.oxcodsnet.roadarchitect.util.CacheManager;
import net.oxcodsnet.roadencounters.config.REConfig;
import net.oxcodsnet.roadencounters.config.REConfigHolder;
import net.oxcodsnet.roadencounters.storage.TriggerStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AmbushAddon
implements RoadAddon {
    public static final String MOD_ID = "roadarchitect_roadencounters";
    public static final class_2960 ADDON_ID = class_2960.method_60655((String)"roadarchitect_roadencounters", (String)"ambush_addon");
    public static final class_2960 AMBUSH_TRIGGER = class_2960.method_60655((String)"roadarchitect_roadencounters", (String)"ambush");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"roadarchitect_roadencounters/AmbushAddon");
    private TriggerStorage storage;
    private REConfig config;

    public class_2960 id() {
        return ADDON_ID;
    }

    public void onRegister() {
    }

    public void onRegister(AddonContext ctx) {
        this.storage = TriggerStorage.create(arg_0 -> ((AddonContext)ctx).persistent(arg_0), ctx.logger(), this.id());
        this.config = REConfigHolder.get();
        ctx.logger().info("[{}] Addon registered successfully", (Object)MOD_ID);
    }

    public void onPathReady(class_3218 world, String pathKey, List<class_2338> refinedPath) {
        if (this.storage == null) {
            return;
        }
        if (refinedPath.size() < 16) {
            return;
        }
        int maxMarkers = this.config.maxMarkers();
        int stride = this.config.strideBlocks();
        int placed = 0;
        int acc = 0;
        for (int i = 1; i < refinedPath.size(); ++i) {
            int dz;
            class_2338 a = refinedPath.get(i - 1);
            class_2338 b = refinedPath.get(i);
            int dx = Math.abs(b.method_10263() - a.method_10263());
            int seg = Math.max(dx, dz = Math.abs(b.method_10260() - a.method_10260()));
            if ((acc += seg) < stride) continue;
            class_2338 p = b;
            this.storage.addMarker(world, p, AMBUSH_TRIGGER, this.config.triggerRadius(), new class_2487());
            if (++placed >= maxMarkers) break;
            acc = 0;
        }
        if (placed > 0) {
            LOGGER.debug("Ambush markers placed: {} on {}", (Object)placed, (Object)pathKey);
        }
    }

    public void onServerTick(MinecraftServer server) {
        if (this.storage == null) {
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            List<TriggerStorage.Marker> nearby;
            class_1937 class_19372 = player.method_37908();
            if (!(class_19372 instanceof class_3218)) continue;
            class_3218 world = (class_3218)class_19372;
            class_1923 cp = new class_1923(player.method_24515());
            if (!world.method_8393(cp.field_9181, cp.field_9180) || (nearby = this.storage.findMarkersNear(world, player.method_24515(), this.config.triggerRadius())).isEmpty()) continue;
            ArrayList<UUID> toRemove = new ArrayList<UUID>();
            for (TriggerStorage.Marker m : nearby) {
                if (!world.method_8393(m.pos().method_10263() >> 4, m.pos().method_10260() >> 4)) continue;
                this.handleAmbush(world, m.pos());
                toRemove.add(m.id());
            }
            if (toRemove.isEmpty()) continue;
            this.storage.markTriggered(world, toRemove, this.config.cooldownTicks());
        }
    }

    public void onChunkLoad(class_3218 world, class_1923 pos) {
    }

    private void handleAmbush(class_3218 world, class_2338 pos) {
        if (world.method_8407() == class_1267.field_5801) {
            return;
        }
        class_5819 rnd = world.method_8409();
        REConfig.SpawnSpec picked = AmbushAddon.pickSpawn(this.config, rnd);
        int count = picked.countMin() + rnd.method_43048(Math.max(1, picked.countMax() - picked.countMin() + 1));
        class_2960 chosenId = class_2960.method_12829((String)picked.entityId());
        for (int i = 0; i < count; ++i) {
            class_1297 e;
            int r = this.config.spawnOffset();
            int ox = rnd.method_43048(r * 2 + 1) - r;
            int oz = rnd.method_43048(r * 2 + 1) - r;
            class_2338 spawn = AmbushAddon.findGround(world, pos.method_10069(ox, 0, oz));
            class_1299 type = AmbushAddon.resolveEntityType(chosenId);
            if (type == null) {
                type = class_1299.field_6105;
            }
            if ((e = type.method_5883((class_1937)world, class_3730.field_16459)) == null) continue;
            if (e instanceof class_1308) {
                class_1308 me = (class_1308)e;
                me.method_5943((class_5425)world, world.method_8404(spawn), class_3730.field_16467, null);
                me.method_5725(spawn, rnd.method_43057() * 360.0f, 0.0f);
                world.method_8649((class_1297)me);
                if (i != 0 || !(me instanceof class_3732)) continue;
                class_3732 pe = (class_3732)me;
                pe.method_16217(true);
                continue;
            }
            e.method_5725(spawn, rnd.method_43057() * 360.0f, 0.0f);
            world.method_8649(e);
        }
    }

    private static class_1299<?> resolveEntityType(class_2960 id) {
        if (id == null) {
            return null;
        }
        return (class_1299)class_7923.field_41177.method_63535(id);
    }

    private static REConfig.SpawnSpec pickSpawn(REConfig cfg, class_5819 rnd) {
        List<REConfig.SpawnSpec> list = cfg.spawnSpecs();
        if (list == null || list.isEmpty()) {
            return new REConfig.SpawnSpec("minecraft:pillager", 100, 4, 5);
        }
        int total = 0;
        for (REConfig.SpawnSpec s : list) {
            if (s.weight() <= 0) continue;
            total += s.weight();
        }
        if (total <= 0) {
            return list.get(0);
        }
        int r = rnd.method_43048(total);
        int acc = 0;
        for (REConfig.SpawnSpec s : list) {
            if (s.weight() <= 0 || r >= (acc += s.weight())) continue;
            return s;
        }
        return list.getFirst();
    }

    private static class_2338 findGround(class_3218 world, class_2338 near) {
        int x = near.method_10263();
        int z = near.method_10260();
        int y = CacheManager.getHeight((class_3218)world, (int)x, (int)z);
        return new class_2338(x, y, z);
    }
}

