/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadencounters.fabric.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.oxcodsnet.roadencounters.config.AmbushConfig;
import net.oxcodsnet.roadencounters.config.REConfig;
import net.oxcodsnet.roadencounters.config.REConfigHolder;

public final class FabricREConfigBridge {
    private FabricREConfigBridge() {
    }

    public static void init() {
        ConfigHolder holder;
        try {
            holder = AutoConfig.getConfigHolder(AmbushConfig.class);
        }
        catch (Throwable e) {
            AutoConfig.register(AmbushConfig.class, GsonConfigSerializer::new);
            holder = AutoConfig.getConfigHolder(AmbushConfig.class);
        }
        FabricREConfigBridge.ensureBoundsAndPublish((ConfigHolder<AmbushConfig>)holder);
    }

    private static void ensureBoundsAndPublish(ConfigHolder<AmbushConfig> holder) {
        AmbushConfig cfg = (AmbushConfig)holder.getConfig();
        boolean changed = false;
        if (cfg.spawns != null) {
            for (AmbushConfig.SpawnEntry e : cfg.spawns) {
                if (e.countMax < e.countMin) {
                    e.countMax = e.countMin;
                    changed = true;
                }
                if (e.weight >= 0) continue;
                e.weight = 0;
                changed = true;
            }
        }
        if (cfg.spawns == null || cfg.spawns.isEmpty()) {
            cfg.spawns = new ArrayList<AmbushConfig.SpawnEntry>(List.of(AmbushConfig.SpawnEntry.defaultPillager()));
            changed = true;
        }
        if (changed) {
            holder.save();
        }
        REConfigHolder.set(new Impl(holder));
    }

    private record Impl(ConfigHolder<AmbushConfig> holder) implements REConfig
    {
        @Override
        public int maxMarkers() {
            return ((AmbushConfig)this.holder.getConfig()).maxMarkers;
        }

        @Override
        public int strideBlocks() {
            return ((AmbushConfig)this.holder.getConfig()).strideBlocks;
        }

        @Override
        public int triggerRadius() {
            return ((AmbushConfig)this.holder.getConfig()).triggerRadius;
        }

        @Override
        public int cooldownSeconds() {
            return ((AmbushConfig)this.holder.getConfig()).cooldownSeconds;
        }

        @Override
        public int spawnOffset() {
            return ((AmbushConfig)this.holder.getConfig()).spawnOffset;
        }

        @Override
        public List<REConfig.SpawnSpec> spawnSpecs() {
            AmbushConfig c = (AmbushConfig)this.holder.getConfig();
            ArrayList<REConfig.SpawnSpec> out = new ArrayList<REConfig.SpawnSpec>();
            if (c.spawns != null) {
                for (AmbushConfig.SpawnEntry e : c.spawns) {
                    out.add(new REConfig.SpawnSpec(e.entityId, e.weight, e.countMin, e.countMax));
                }
            }
            return Collections.unmodifiableList(out);
        }
    }
}

