/*
 * Decompiled with CFR 0.152.
 */
package net.oxcodsnet.roadencounters.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.oxcodsnet.roadarchitect.api.storage.PersistentStore;
import org.slf4j.Logger;

public final class TriggerStorage {
    private static final String LIST = "markers";
    private static final String ID = "id";
    private static final String POS = "pos";
    private static final String TYPE = "type";
    private static final String RADIUS = "radius";
    private static final String DATA = "data";
    private static final String NEXT_READY = "next_ready";
    private final class_2960 storeKey;
    private final Function<class_3218, PersistentStore> store;
    private final Logger logger;
    private final Map<class_3218, State> states = new WeakHashMap<class_3218, State>();

    public TriggerStorage(class_2960 storeKey, Function<class_3218, PersistentStore> store, Logger logger) {
        this.storeKey = storeKey;
        this.store = store;
        this.logger = logger;
    }

    public static TriggerStorage create(Function<class_3218, PersistentStore> store, Logger logger, class_2960 addonId) {
        return new TriggerStorage(class_2960.method_60655((String)addonId.method_12836(), (String)(addonId.method_12832() + "_triggers")), store, logger);
    }

    private State state(class_3218 world) {
        return this.states.computeIfAbsent(world, this::load);
    }

    private State load(class_3218 world) {
        State s = new State();
        Optional opt = this.store.apply(world).get(this.storeKey);
        if (opt.isEmpty()) {
            return s;
        }
        class_2487 tag = (class_2487)opt.get();
        class_2499 list = tag.method_10554(LIST, 10);
        for (int i = 0; i < list.size(); ++i) {
            long nextReady;
            class_2487 e = list.method_10602(i);
            UUID id = e.method_25926(ID);
            class_2338 pos = class_2338.method_10092((long)e.method_10537(POS));
            class_2960 type = class_2960.method_12829((String)e.method_10558(TYPE));
            int radius = e.method_10550(RADIUS);
            class_2487 data = e.method_10562(DATA);
            long l = nextReady = e.method_10545(NEXT_READY) ? e.method_10537(NEXT_READY) : 0L;
            if (type == null) continue;
            TriggerStorage.index(s, new Marker(id, pos, type, radius, data.method_10553(), nextReady));
        }
        return s;
    }

    private void save(class_3218 world, State s) {
        class_2499 list = new class_2499();
        for (Marker m : s.byId.values()) {
            class_2487 e = new class_2487();
            e.method_25927(ID, m.id());
            e.method_10544(POS, m.pos().method_10063());
            e.method_10582(TYPE, m.type().toString());
            e.method_10569(RADIUS, m.radius());
            e.method_10566(DATA, (class_2520)m.data().method_10553());
            if (m.nextReadyTick() > 0L) {
                e.method_10544(NEXT_READY, m.nextReadyTick());
            }
            list.add((Object)e);
        }
        class_2487 root = new class_2487();
        root.method_10566(LIST, (class_2520)list);
        this.store.apply(world).put(this.storeKey, root);
    }

    private static void index(State s, Marker m) {
        s.byId.put(m.id(), m);
        s.byChunk.computeIfAbsent(new class_1923(m.pos()), c -> ConcurrentHashMap.newKeySet()).add(m.id());
    }

    public void addMarker(class_3218 world, class_2338 pos, class_2960 type, int radius, class_2487 data) {
        State s = this.state(world);
        UUID id = UUID.randomUUID();
        TriggerStorage.index(s, new Marker(id, pos.method_10062(), type, radius, data == null ? new class_2487() : data.method_10553(), 0L));
        this.save(world, s);
        this.logger.debug("Added marker {} at {} (r={})", new Object[]{type, pos, radius});
    }

    public List<Marker> findMarkersNear(class_3218 world, class_2338 pos, int maxSearchRadiusBlocks) {
        State s = this.state(world);
        if (s.byId.isEmpty()) {
            return List.of();
        }
        int cx = pos.method_10263() >> 4;
        int cz = pos.method_10260() >> 4;
        int rChunks = Math.max(1, Math.min(8, maxSearchRadiusBlocks + 15 >> 4));
        long now = world.method_8510();
        ArrayList<Marker> out = new ArrayList<Marker>();
        for (int dx = -rChunks; dx <= rChunks; ++dx) {
            for (int dz = -rChunks; dz <= rChunks; ++dz) {
                Set<UUID> ids = s.byChunk.get(new class_1923(cx + dx, cz + dz));
                if (ids == null || ids.isEmpty()) continue;
                for (UUID id : ids) {
                    int rz;
                    int rx;
                    Marker m = s.byId.get(id);
                    if (m == null || m.nextReadyTick() > now || (long)(rx = m.pos().method_10263() - pos.method_10263()) * (long)rx + (long)(rz = m.pos().method_10260() - pos.method_10260()) * (long)rz > (long)m.radius() * (long)m.radius()) continue;
                    out.add(m);
                }
            }
        }
        return out;
    }

    public void markTriggered(class_3218 world, Collection<UUID> ids, long cooldownTicks) {
        if (ids.isEmpty()) {
            return;
        }
        State s = this.state(world);
        long until = world.method_8510() + Math.max(0L, cooldownTicks);
        for (UUID id : ids) {
            Marker m = s.byId.get(id);
            if (m == null) continue;
            s.byId.put(id, new Marker(m.id(), m.pos(), m.type(), m.radius(), m.data(), until));
        }
        this.save(world, s);
    }

    private static final class State {
        final Map<UUID, Marker> byId = new ConcurrentHashMap<UUID, Marker>();
        final Map<class_1923, Set<UUID>> byChunk = new ConcurrentHashMap<class_1923, Set<UUID>>();

        private State() {
        }
    }

    public record Marker(UUID id, class_2338 pos, class_2960 type, int radius, class_2487 data, long nextReadyTick) {
    }
}

