/*
 * Decompiled with CFR 0.152.
 */
package net.mattseq.item_holograms.events;

import net.mattseq.item_holograms.ItemLabelCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientTickHandler {
    private static long lastCleanupTime = 0L;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        long gameTime = world.m_46467_();
        if (gameTime - lastCleanupTime > 600L) {
            ClientTickHandler.cleanupCache((Level)world);
            lastCleanupTime = gameTime;
        }
    }

    private static void cleanupCache(Level world) {
        ItemLabelCache.cache.entrySet().removeIf(entry -> world.m_6815_(((Integer)entry.getKey()).intValue()) == null);
    }
}

