/*
 * Decompiled with CFR 0.152.
 */
package net.mattseq.item_holograms.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.mattseq.item_holograms.ItemLabelCache;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderEventHandler {
    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        Camera camera = mc.f_91063_.m_109153_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        long gameTime = mc.f_91073_.m_46467_();
        Vec3 camPos = camera.m_90583_();
        Frustum frustum = event.getFrustum();
        frustum.m_113002_(camPos.f_82479_, camPos.f_82480_, camPos.f_82481_);
        assert (player != null);
        List items = player.m_9236_().m_45976_(ItemEntity.class, player.m_20191_().m_82400_(32.0));
        for (ItemEntity item : items) {
            if (!frustum.m_113029_(item.m_20191_())) continue;
            ItemLabelCache.CachedLabel cached = ItemLabelCache.get(item.m_19879_());
            ItemStack stack = item.m_32055_();
            boolean updateLabel = false;
            boolean updateLOS = false;
            if (cached == null) {
                updateLabel = true;
                updateLOS = true;
            } else if (!ItemStack.m_150942_((ItemStack)cached.lastStack, (ItemStack)stack) || cached.lastStack.m_41613_() != stack.m_41613_()) {
                updateLabel = true;
            }
            if (cached == null || gameTime - cached.lastUpdate > 10L) {
                updateLOS = true;
            }
            if (updateLabel) {
                MutableComponent comp = item.m_32055_().m_41786_().m_6881_();
                ChatFormatting rarityFmt = item.m_32055_().m_41791_().f_43022_;
                comp = comp.m_130940_(rarityFmt);
                int count = item.m_32055_().m_41613_();
                if (count > 1) {
                    comp = comp.m_7220_((Component)Component.m_237113_((String)(" x" + count)).m_130940_(ChatFormatting.WHITE));
                }
                if (cached == null) {
                    cached = new ItemLabelCache.CachedLabel((Component)comp, stack, true, gameTime);
                    ItemLabelCache.put(item.m_19879_(), cached);
                } else {
                    cached.label = comp;
                    cached.lastStack = stack.m_41777_();
                }
            }
            if (updateLOS) {
                Vec3 targetPos = item.m_20191_().m_82399_();
                BlockHitResult result = mc.f_91073_.m_45547_(new ClipContext(camPos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                cached.visibleLOS = result.m_6662_() != HitResult.Type.BLOCK;
                cached.lastUpdate = gameTime;
            }
            if (!cached.visibleLOS) continue;
            poseStack.m_85836_();
            double yOffset = Math.sin((double)System.currentTimeMillis() / 500.0) * 0.1;
            poseStack.m_85837_(0.0, yOffset, 0.0);
            Vec3 itemPos = item.m_20182_().m_82546_(camPos);
            poseStack.m_85837_(itemPos.f_82479_, itemPos.f_82480_ + 1.0, itemPos.f_82481_);
            poseStack.m_252781_(mc.m_91290_().m_253208_());
            double distance = player.m_20270_((Entity)item);
            float scale = (float)(0.05 * (distance / 16.0));
            scale = (float)Math.min((double)scale, 0.05);
            poseStack.m_85841_(-scale, -scale, scale);
            int textWidth = mc.f_91062_.m_92852_((FormattedText)cached.label);
            float x = (float)(-textWidth) / 2.0f;
            float y = 0.0f;
            mc.f_91062_.m_272077_(cached.label, x, y, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            poseStack.m_85849_();
        }
        buffer.m_109911_();
    }

    private static void drawBox(PoseStack poseStack, float x1, float y1, float x2, float y2, int argbColor) {
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float a = (float)(argbColor >> 24 & 0xFF) / 255.0f;
        float r = (float)(argbColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(argbColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(argbColor & 0xFF) / 255.0f;
        buffer.m_252986_(matrix, x1, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, x2, y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, x2, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        buffer.m_252986_(matrix, x1, y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.disableBlend();
    }
}

