/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic;

import it.unimi.dsi.fastutil.ints.IntBooleanPair;
import it.unimi.dsi.fastutil.objects.ObjectBooleanPair;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.api.ceremony.StartupContext;
import pokefenn.totemic.api.event.CeremonyEvent;
import pokefenn.totemic.api.event.MedicineBagEffectEvent;
import pokefenn.totemic.api.event.TotemEffectEvent;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.api.totem.MedicineBagEffect;
import pokefenn.totemic.api.totem.TotemCarving;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.api.totem.TotemEffectContext;

public class TotemicEventHooks {
    private static final TotemicEventHooks INSTANCE = new TotemicEventHooks();

    public static TotemicEventHooks get() {
        return INSTANCE;
    }

    public ObjectBooleanPair<Optional<Ceremony>> fireCeremonySelection(LevelAccessor level, BlockPos pos, Entity initiator, List<MusicInstrument> selectors, Optional<Ceremony> ceremony) {
        CeremonyEvent.Selection event = new CeremonyEvent.Selection(level, pos, initiator, selectors, ceremony);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return ObjectBooleanPair.of(event.getCeremony(), (boolean)event.getSkipSelectionCheck());
    }

    public boolean fireCeremonyStartupTick(LevelAccessor level, BlockPos pos, Ceremony ceremony, CeremonyInstance instance, StartupContext context) {
        return !MinecraftForge.EVENT_BUS.post((Event)new CeremonyEvent.StartupTick(level, pos, ceremony, instance, context));
    }

    public void fireCeremonyStartupFail(LevelAccessor level, BlockPos pos, Ceremony ceremony, CeremonyInstance instance, StartupContext context) {
        MinecraftForge.EVENT_BUS.post((Event)new CeremonyEvent.StartupFail(level, pos, ceremony, instance, context));
    }

    public boolean fireCeremonyStartupSuccess(LevelAccessor level, BlockPos pos, Ceremony ceremony, CeremonyInstance instance, StartupContext context) {
        return !MinecraftForge.EVENT_BUS.post((Event)new CeremonyEvent.StartupSuccess(level, pos, ceremony, instance, context));
    }

    public boolean fireCeremonyEffectTick(LevelAccessor level, BlockPos pos, Ceremony ceremony, CeremonyInstance instance, CeremonyEffectContext context) {
        return !MinecraftForge.EVENT_BUS.post((Event)new CeremonyEvent.EffectTick(level, pos, ceremony, instance, context));
    }

    public boolean fireTotemEffectEvent(LevelAccessor level, BlockPos pos, TotemEffect effect, int repetition, TotemEffectContext context) {
        return !MinecraftForge.EVENT_BUS.post((Event)new TotemEffectEvent(level, pos, effect, repetition, context));
    }

    public IntBooleanPair fireMedicineBagEffectEvent(MedicineBagEffect effect, TotemCarving carving, Player player, ItemStack medicineBag, int charge, int chargeToDeduct) {
        MedicineBagEffectEvent event = new MedicineBagEffectEvent(effect, carving, player, medicineBag, charge, chargeToDeduct);
        boolean canceled = MinecraftForge.EVENT_BUS.post((Event)event);
        return IntBooleanPair.of((int)event.getChargeToDeduct(), (!canceled ? 1 : 0) != 0);
    }
}

